/*
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.homework.HomeworkAssignmentSearch' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.homeworkassignmentsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins : "formlabelrequired",
	defaults: {
		labelAlign: 'top'
	},
	items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden: true,
				store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				editable:false,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'course',
				itemId:'course_Id',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
				disabled : true,
				valueField:'courseId',
				displayField:'courseCodeName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hideTrigger:false,
				minChars:3,
				forceSelection : true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				queryParam:'name',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'courseVarient',
				itemId:'courseVarient_Id',
				fieldLabel: getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField : 'courseVariantCode',
				valueField : 'id',
				disabled:true,
				forceSelection:true,
				typeAhead:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},

					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'program',
				itemId : 'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
	        	displayField : 'valueCode',
	        	valueField : 'id',
				typeAhead : false,
	            forceSelection:true,
	            disabled:true,
	            hideTrigger:false,
	    	    triggerAction: 'all',
	    	    queryParam:'name',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
	        	displayField : 'value',
	        	valueField : 'id',
				disabled : true,
				forceSelection : true
			},{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
	        	displayField : 'value',
	        	valueField : 'id',
				disabled : true,
				forceSelection : true
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 256,
			labelAlign: 'top',
			name : 'sectionId',
			itemId : 'programCoursection_ID',
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			disabled:true,
			forceSelection : true
		},{
			xtype: 'customcombobox',
			name:'studentNameNew',
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			fieldLabel:getExaminationTranslation('STUDENT_ID_NAME'),
			labelStyle: 'width: 250px;',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}
		]},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'topicTypeId',
				itemId:'topicType_Id',
				fieldLabel: getCourseTxCommonTranslation('HW_TOPIC_TYPE'),
				store:'coursetransaction.coursereading.TopicType',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true
			},{
				xtype: 'customcombobox',
				name: 'topicName',
				itemId:'topicName_Id',
				fieldLabel: getCourseTxCommonTranslation('HW_TOPIC_NAME'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true
			}]
		},{ 
			xtype:'fieldset',
			title:getEnquiryTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			defaults: {
				labelAlign: 'top',
			},
			/*style: {
				marginTop: '40px!important',
				marginBottom: '40px!important',
			},*/
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					 xtype: 'customcombobox',
				     name: 'assignmentType',
				     itemId:'assignmentType_Is',
				     fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_TYPE'),
				     store:'coursetransaction.homework.HW_AssignmentTypeDropDown',
				     displayField:'value',
				     valueField:'id',
				     forceSelection:true,
				     typeAhead:true,
	    		},{
	    			xtype: 'customcombobox',
	    			name: 'assignmentName',
	    			itemId:'assignmentNameId',
	    			fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_NAME'),
					store:'coursetransaction.homework.AssignmentNameDropDown',
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					typeAhead:true,
					queryParam:'searchName',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					}
	    		},{
	    			xtype:'combo',
	    			name: 'assessmentType',
	    			itemId:'assessmentTypeItemId_studentWise',
	    			fieldLabel : getExaminationTranslation('EVALUATION_TYPE'),
	    			valueField: 'id',
	    			displayField: 'id',
	    			typeAhead:true,
	    			forceSelection:true,
	    			queryMode:'local',
	    			store:['All','Random Code Assessment','Regular Assessment']
	    		}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					labelAlign:'top',
					width:223
				},
				items:[  {
					xtype: 'datefield',
					name: 'fromDate',
					itemId:'fromDate',
					fieldLabel: getCourseTxCommonTranslation('HW_FROM_DATE'),
					endDateField : 'toDate',
					vtype : 'daterange',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}

				},{
					xtype: 'datefield',
					name: 'toDate',
					itemId:'toDate',
					fieldLabel: getCourseTxCommonTranslation('HW_TO_DATE'),
					startDateField : 'fromDate',
					vtype : 'daterange',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]	
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
