
Ext.define('Academia.view.coursetransaction.homework.assignmentDetails.GroupsAssignmentGrid', {
	extend: 'Ext.window.Window',
	alias: 'widget.groupsassignmentgrid',
	modal : true,
	resizable:true,
	autoScroll: false,
	maxHeight: '65%',
	width: '50%',
	frame: true,
	title: getCourseTxCommonTranslation('HW_ASSIGNMENT_GROUP_STUDENT'),
	items:[{
        xtype: 'form',
        id:'groupAssignmentForm_Id',
        plugins:"formlabelrequired",
        
        items: [{
			xtype:'panel',
			width: '100%',
			cls:'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'sectionTypeId',
				columns: 2,
				vertical: false,				
				items: [{
					boxLabel: getProgramandcourseTranslation('CREATE_GROUP_MANNUALLY'),
					name: 'sectionType',
					inputValue: 'CREATE_GROUP_MANNUALLY',
					checked:true
				},{
					boxLabel: getProgramandcourseTranslation('SELECT_GROUP')+"<span style='font-size:12px;'>("+getProgramandcourseTranslation('FROM_EXISTING_GROUP_ASSIGNMENT')+")</span>",
					name: 'sectionType',
					inputValue: 'EXISTING_SELECT_GROUP'
				}]
			}]
		},{
			xtype : 'fieldcontainer',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			margin:'0 0 0 10px',
			items : [{
				xtype : 'textfield',
				name:'groupName',
				itemId : 'groupNameId',
				fieldLabel:getCourseTxCommonTranslation('HW_GROUP_NAME'),
				allowBlank : false
			},{
				xtype : 'customcombobox',
				name : 'existinAssignmentGroupName',
				itemId : 'existinAssignmentGroupNameId',
				fieldLabel : getProgramandcourseTranslation('SELECT_GROUP'),
				store:Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.AssignmentGroupNameStore'),
				displayField : 'groupName',
				valueField : 'id',
				typeAhead : true,
				hidden: true,
				editable:false
			}]
		},{
			xtype : 'fieldcontainer',
			items : [{
				xtype: 'grid',
				name : 'addAssignmentGroupName',
				itemId : 'addAssignmentGroupNameId',
				columnLines: true,
				maxHeight: 200,
				border:true,
				selType:'checkboxmodel',
				selModel: {
					multiSelect :true,
					mode:'SIMPLE',
					checkOnly : false
				},
				store : 'coursetransaction.homework.assignmentdetails.AssignmentIndividualStore',
				columns : [{
			header :getCourseTxCommonTranslation('HW_ADMISSION_ID'),
			dataIndex : 'admissionCode',
			flex:1
		},{
			header : getCourseTxCommonTranslation('HW_STUDENT_NAME'),
			dataIndex : 'studentName',
			flex:1
		},{
			header : getCourseTxCommonTranslation('Program'),
			dataIndex : 'programName',
			flex:1,
			sortable : true
		},{
			header : getCourseTxCommonTranslation('Batch'),
			dataIndex : 'batchName',
			flex:1,
			sortable : true
		},{
			header : getCourseTxCommonTranslation('Period'),
			dataIndex : 'periodName',
			flex:1,
			sortable : true
		},{
			header : getCourseTxCommonTranslation('HW_GROUP_LEADER'),
			dataIndex : 'groupLeader',
			flex:1,
		  renderer: function(value, meta, record)
		  {
			  var sectionType = this.up('form').down('#sectionTypeId').getValue();
			  var val =false;
			  if(!isNullOrEmpty(value) && (value || value == "true")){
				  val = true;
			  }
			  if(sectionType.sectionType==="EXISTING_SELECT_GROUP"){
				  return Ext.String.format("<input type='radio' name='groupLeader' defaultChecked='false' value='groupLeader' disabled onchange='this.cellclick;'"+(val ? 'checked="true"' : '')+" />");
			  }
			  else{
				  return Ext.String.format("<input type='radio' name='groupLeader' defaultChecked='false' value='groupLeader' onchange='this.cellclick;'"+(val ? 'checked="true"' : '')+" />");  
			  }
			  
		  }
		}],listeners:{
			cellclick:function(view, cell, cellIndex, record, row, rowIndex, e){
				if(e.target.type=="radio"){
					 var sectionType = view.up('form').down('#sectionTypeId').getValue();
					 if(sectionType.sectionType==="EXISTING_SELECT_GROUP"){
						 return false;
					 }
					var selcLength = view.getSelectionModel().selected.length
					for( var i = 0; i < selcLength; i++) 
					{
						view.getSelectionModel().selected.items[i].data.groupLeader = null;
					}

					//-- user can only check radio if record is selected (IF/ELSE)
					if(view.getSelectionModel().isRowSelected(record)){
						record.data.groupLeader=e.target.checked;
						return false;
					}
					else
					{
						//--removing group leader from already selected records
						var allSelected = view.getSelectionModel().selected.items;
						Ext.each(allSelected,function(currentRecord){
							currentRecord.data.groupLeader = null;
						});
						e.target.checked = false;
						record.data.groupLeader = null;
						return false;
					}
				}else if(cellIndex==0){
					//-- On deselecting record remove radio check
					if(view.getSelectionModel().isRowSelected(record)){
						row.cells[row.cells.length-1].children[0].children[0].checked = false;
						record.data.groupLeader=null;
					}
				}else{
					//-- Remove group leader record, If radio is not checked.
					if(e.target.checked==false){
						record.data.groupLeader=null;
					}
				}
			},
			beforedeselect: function( view, record, index, eOpts ){
				//-- On deselecting record remove radio check
				if(view.view.getSelectionModel().isRowSelected(record)){
					var row = Ext.query('tr[data-recordid='+record.internalId+']')[Ext.query('tr[data-recordid='+record.internalId+']').length-1];
					row.cells[row.cells.length-1].children[0].children[0].checked = false;
					record.data.groupLeader=null;
				}
			}
		}
			}]
		},{
    	xtype:'fieldcontainer',
    	width:'100%',
    	cls:'windowBtnPos',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SAVE'),
    		itemId: 'group_assignment_Add',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind : true
    	},{
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel', // edited by Guruling
    		itemId: 'cancelBtn',
    		scale: CONSTANTS.BUTTONSIZE

    	}]
    } ]
} ]
});
