/**
 * @Dharmendra.Prajapati
 * 
 * 
 */
Ext
		.define(
				'Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetails',
				{
					extend : 'Ext.window.Window',
					alias : 'widget.evaluationdetails',
					modal : true,
					autoScroll : true,
					title : getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'),
					maxHeight : 600,
					items : [ {
						xtype : 'customfieldform',
						customFieldEntity : CONSTANTS.GROUP_HOMEWORK_ASSIGNMENT_CD,
						columns : 1,
						method : 'POST',
						standardSubmit : false,
						plugins : "formlabelrequired",
						defaults : {
							labelAlign : 'top',
							width: 256
						},
						items : [
								{
									xtype : 'hidden',
									name : 'id'
								},
								{
									xtype : 'hidden',
									name : 'studentHiddenId'
								},
								{
									xtype : 'fieldcontainer',
									layout : 'vbox',
									defaults : {
										labelAlign : 'top',
										width: 256
									},
									items : [
											{
												xtype : 'customcombobox',
												name : 'groupName',
												id : 'groupNameCombo_Id',
												itemId : 'groupName_Id',
												hidden : true,
												fieldLabel : getCourseTxCommonTranslation('HW_GROUP_NAME'),
												store : 'coursetransaction.homework.submissiondetails.GroupName',
												displayField : 'value',
												valueField : 'value'
											// allowBlank: false
											},
											{
												xtype : 'customcombobox',
												name : 'studentId',
												// readOnly:true,
												itemId : 'studentName_Id',
												fieldLabel : getCourseTxCommonTranslation('HW_STUDENT_NAME'),
												store : 'coursetransaction.homework.submissiondetails.StudentName',
												displayField : 'value',
												valueField : 'id'
											},
											{
												xtype : 'textfield',
												name : 'gradeObtained',
												itemId : 'gradeObtained_Id',
												fieldLabel : getCourseTxCommonTranslation('HW_GRADE'),
												hidden : true
											},
											{
												xtype : 'numberfield',
												name : 'markObtained',
												itemId : 'markObtained_Id',
												fieldLabel : getCourseTxCommonTranslation('HW_MARK'),
												minValue : 0,
												maxValue : 100
											// minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),

											} ]
								},
								{
									xtype : 'radiogroup',
									itemId : 'submissionStatusId',
									fieldLabel : getCourseTxCommonTranslation('HW_SUBMISSION_COMPLETED'),
									items : [
											{
												boxLabel : getCourseTxCommonTranslation('YES'),
												name : 'submissionStatus',
												inputValue : getCourseTxCommonTranslation('HW_COMPLETED'),
												checked : true
											},
											{
												boxLabel : getCourseTxCommonTranslation('NO'),
												name : 'submissionStatus',
												inputValue : getCourseTxCommonTranslation('HW_PENDING')
											} ]
								},
								{
									xtype : 'radiogroup',
									itemId : 'reSubmissionStatusId',
									style : {
										marginTop : '10px'
									},
									hidden : true,
									fieldLabel : getCourseTxCommonTranslation('HW_RE_SUBMISSION_REQUIRED'),
									items : [
											{
												boxLabel : getCourseTxCommonTranslation('YES'),
												name : 'reSubmissionStatus',
												inputValue : true
											},
											{
												boxLabel : getCourseTxCommonTranslation('NO'),
												name : 'reSubmissionStatus',
												inputValue : false,
												checked : true
											} ]
								},
								{
									xtype : 'datefield',
									fieldLabel : getCourseTxCommonTranslation('HW_RESUBMISSION_DATE'),
									name : 'resubmissionDate',
									allowBlank : false,
									hidden : true,
									itemId : 'resubmissionDate',
									//--submitFormat : CONSTANTS.DATE_TIME_FORMATDMY,
									// vtype: 'daterange',
									// startDateField:'submissionDate',
									listeners : {
										render : function(field) {
											return dateFormatRender(field);
										}
									}
								},
								{
									xtype : 'textareafield',
									style : {
										marginTop : '20px'
									},
									fieldLabel : getCourseTxCommonTranslation('HW_EVALUATION_REMARKS'),
									name : 'remarks',
									enforceMaxLength : true,
									maxLength : 255
								}, {
									xtype : 'fieldcontainer',
									items : [ {
										xtype : 'button',
										text : getCommonTranslation('SAVE'),
										itemId : 'btnSubmit',
										ui : 'CustomBtnSubmit',
										scale : CONSTANTS.BUTTONSIZE,
										formBind : true
									}, {
										xtype : 'button',
										text : getCommonTranslation('CANCEL'),
										itemId : 'btnCancel',
										ui : 'CustomBtnCancel',
										scale : CONSTANTS.BUTTONSIZE
									} ]
								} ]
					} ]
				});
