/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.managedistribution.ManageDistributionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managedistributionsearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [
	        {

	        	xtype : 'fieldcontainer',
	        	width: 'auto',
	        	layout : {
	        		type : 'hbox'
	        	},
	        	defaults : {
	        		width: 256,
	        		labelAlign : 'top'
	        	},
	        	items : [{


	        		xtype: 'multiselectcombofield',
	        		width: 536,
	        		//height: 'auto',
	        		name: 'multiselectAcademyLocation',
	        		itemId: 'multiselectAcademyLocationId',
	        		cls: 'multiselectAcademyLocation',
	        		allowBlank : false,
	        		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//	        		translationKey: 'ACADEMY_LOCATION',
	        		store:'common.AccesibleAcademyLocationNameSeparated',
	        		displayField:'value',
	        		valueField:'id',
	        		matchFieldWidth:true,
	        		queryMode:'local',
	        		listConfig: {
	        			listeners: {
	        				beforeshow: function(picker) {
	        					picker.width = picker.up('combobox').getSize().width;
	        				}
	        			},
	        			loadingText: getCommonTranslation('SEARCHING'),
	        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			getInnerTpl: function() {
	        				return '<div class="search-item">' +
	        				'{code}' +
	        				'</div>';
	        			}
	        		}
	        	
	        	
	        	}]
	        },{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//			translationKey: 'PROGRAM',
			name : 'programId',
			itemId : 'programId',
			store:'common.ProgramByAcademyLocationStore',
			displayField:'valueCode',
			valueField:'id',
			width:450,
			typeAhead:true,
        	queryParam:'programName',
        	minChars:3,
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}' +
        			'</div>';
        		}
        	}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 256,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'sectionId',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				forceSelection : true
			}
			]},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('DISTRIBUTION_LIST'),
				name : 'distributionId',
				itemId : 'distributionId',
				store:'coursetransaction.studymaterialdistributionnew.DistributionListStr',
				width: 256,
				labelAlign: 'top',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'fieldcontainer',
				width: 'auto',
	    		layout : {
	    			type : 'hbox'
	    		},
	    		cls: 'customSearchPanelBtnsFieldContainerCls',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind:true,
					margin: '0 32 0 0'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE	        				
				}]
			}]
      //}]
});