Ext.define('Academia.view.coursetransaction.manageperiodenrollment.ChangePaymentTermWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.changepaymenttermwindow',

	title: getCommonTranslation('CHANGE_PAYMENT_TERM'),

	autoScroll: true,
	maxHeight: 600,
	modal: true,
	items: [{
		xtype: 'form',
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'currentPaymentTerm',
				itemId:'currentPaymentTerm',
				fieldLabel: getCommonTranslation('CURRENT_PAYMENT_TERM'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{	
				xtype: 'customcombobox',
				name: 'paymentGroup',
				itemId:'paymentGroup',
				fieldLabel: getCommonTranslation('PAYMENT_GROUP'),
				//store: 'feeandpayment.FeePaymentGroup',
				store: 'feeandpayment.AllPaymentGroup',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{	
				xtype: 'customcombobox',
				name: 'paymentTerm',
				itemId:'paymentTerm',
				fieldLabel: getCommonTranslation('SELECT_PAYMENT_TERM'),
				store: 'feeandpayment.FeePaymentTerm',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                        picker.maxWidth = picker.up('combobox').getSize().width;
	                    }
	                }
	            }
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]

});