/**
 * @author Amit Gupta
 */

Ext.define('Academia.view.coursetransaction.manageperiodenrollment.EnrollToPeriodEnrollmentWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.enrolltoperiodenrollmentwin',
	title:getCommonTranslation('PERIOD_ENROLLMENT'),
	frame: true,
	autoScroll:true,
	modal:true,
	plugins : "formlabelrequired",
	items: [{
		xtype: 'form',
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'program',
				itemId:'program',
				fieldLabel: getCommonTranslation('PROGRAM'),
			},{
				xtype:'displayfield',
				name:'batch',
				itemId:'batch',
				fieldLabel:getCommonTranslation('BATCH')
			},{
				xtype:'displayfield',
				name:'currentPeriod',
				itemId:'currentPeriod',
				fieldLabel:getCommonTranslation('CURRENT_PERIOD')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{	
				xtype: 'customcombobox',
				name: 'enrollToPeriod',
				itemId:'enrollToPeriod',
				fieldLabel: getCommonTranslation('ENROLL_TO_PERIOD'),
				store: 'coursetransaction.manageperiodenrollment.OptionalPeriodStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'datefield',
				name: 'enrollmentDate',
				itemId:'enrollmentDate',
				allowBlank:true,
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				editable:false,
				fieldLabel:getCommonTranslation('ENROLLMENT_DATE'),
//				value:new Date(),
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});