/**
 * Amit Gupta
 * 
 */
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentSearch', {
	extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.manageperiodenrollmentsearch',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame : false,
	method : 'POST',
	standardSubmit : false,
	cls : 'customSearchPanel',
	items : [ {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academyLocationPeriodEnrollment',
			itemId:'academyLocationPeriodEnrollment',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AcademyLocationsByUserStore'),
			width: 536,
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			allowBlank:false,
			typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'periodWiseAcademicTerm',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			itemId:'periodWiseAcademicTermId',
			store : Ext.create('Academia.store.common.findAcademicTermForRegistrationCheckTrue'),
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			editable:false,
			typeAhead:false,
			forceSelection:false,
			queryMode: 'local'
		}]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'studentNameSearch',
			itemId : 'studentNameSearch',
			store : Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'),
			fieldLabel : getCommonTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
			valueField : 'id',
			displayField : 'valueCode',
			queryParam : 'name',
			minChars : 3,
			width : 230,
			typeAhead : false,
			hideTrigger : false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction : '',
			forceSelection : true,
			allowBlank : true,
			enableKeyEvents : 'true',
			listConfig : {
				listeners : {
					beforeshow : function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">' + '{code} / {value}' + '</div>';
				}
			},
			listeners:{
				select:function(obj,record){
					obj.admissionId =record[0].data.secondId
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PERIOD_ENROLLMENT_STATUS'),
			name : 'statusId',
			itemId : 'statusId',
			store : 'coursetransaction.manageperiodenrollment.PeriodEnrollStatusStore',
			labelAlign : 'top',
			displayField : 'value',
			valueField : 'id',
			allowBlank:false,
			forceSelection : false
		}, {
			xtype : 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programId',
			store : Ext.create('Academia.store.common.ProgramForRegistrationProcessStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam : 'programName',
			minChars : 3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents : 'true',
			hideTrigger : false,
			forceSelection : true,
			allowBlank:false,
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig : {
				listeners : {
					beforeshow : function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">' + '{code} / {value}' + '</div>';
				}
			}
		}]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'batchId',
			itemId : 'batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled : true,
			store : 'enquiry.studentDetail.CurrentAndFutureBatchForRegistrationStore',
			valueField : 'id',
			displayField : 'value',
			allowBlank:false,
		},{
			xtype : 'customcombobox',
			name : 'periodId',
			itemId : 'periodId',
			fieldLabel : getCourseTxCommonTranslation('PERIOD'),
			store : 'course.readingmaterial.ProgramPeriodForRegistrationProcessStore',
			displayField : 'value',
			valueField : 'id',
			forceSelection : true,
			typeAhead:false,
			allowBlank:false,
			disabled : true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			labelAlign : 'top',
			name : 'sectionId',
			itemId : 'sectionId',
			disabled : true,
			store : 'attendance.SectionsForRegistrationProcess',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			allowBlank : true,
			typeAhead:false,
	 	    forceSelection : false
		}]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchBtn',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true,
			margin: '0 36 0 0'
		}, {
			xtype : 'button',
			text : getCourseTxCommonTranslation('RESET'),
			itemId : 'resetBtn',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
});