Ext.define('Academia.view.coursetransaction.promotion.PreviousProgressionLettersWindow',{
	extend:'Ext.window.Window',
	alias:'widget.previousProgressionLettersWindow',
	modal : true,
	resizable:false,
	autoScroll:true,
	title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
	height: 600,
	width: 1150,
	frame: true,	
	layout: 'vbox',
	closeAction: 'destroy',
	initComponent: function() {
        var this$ = this;
        var store = Ext.create('Academia.store.personinfo.student.StudentForAcademicToicsStore');
        Ext.apply(this$, {
        	items:[{
        		xtype: 'form',
        		plugins: "formlabelrequired",  
        		autoScroll: true,
        		width: 1055,
        		items:[{
        			xtype : 'fieldcontainer',
        			width: 'auto',
        			layout : {
        				type : 'vbox'
        			},
        			defaults : {
        				width : '100%',
        				labelAlign : 'top'
        			},
        			items:[{
        				xtype : 'textfield',
        				fieldLabel : getCommonTranslation('SUBJECT'),		
        				name : 'subjectLine',
        				itemId : 'subjectLine',
        				allowBlank: false,
        				readOnly: true
        			},{
    					xtype: 'ckeditor',
        				fieldLabel : getCommonTranslation('CONTENT'),
    					itemId: 'userGeneratedMsgContent',
    					name:'userGeneratedMsgContent',
    					cls: 'ckEditorCls',
    					height: 400,
    					maxLength: 20000,
    					enforceMaxLength : true,
    					allowBlank:false
    				}]
        		},{
        			xtype: 'fieldcontainer',
        			width: 'auto',
        			items: [{
        				xtype: 'button',
        				text: getCommonTranslation('MARKSHEET_PREVIEW'),
        				itemId: 'marksheetPreviewBtn',
        				buttonAlign: 'left',
        				ui: 'CustomBtnSubmit',
        				scale: CONSTANTS.BUTTONSIZE,
        				formBind:true
        			}]
        		}]
        	}]
        });
        this$.callParent(arguments);
    }
});