/**
 * @author Ashutosh
 */
Ext.define('Academia.view.coursetransaction.promotion.PromotionAddCommiteeWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.promotionaddcommitteewindow',
	modal: true,
	frame: true,
	title: getCommonTranslation('ADD_TO_PANEL'),
	width: 400,
	height: 200, 
	layout: 'fit',
	resizable: false,
	items: [{
		xtype: 'form',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype : 'fieldcontainer',
			width : '200%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'committeId',
				itemId:'committeId',
				fieldLabel: getCommonTranslation('PANEL_CODE_NAME'),
				store:'committee.committee.AddCommitteeStore',
				valueField:'id',
				displayField:'value',
				allowBlank:false,
				forceSelection:true,
				triggerAction: 'all',
				minChars:3,
				queryParam:'nameOrCode',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'btnSubmit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
                	button.up('window').close();
                }
			}]	
		}]
	}]
});
