/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanBasicSearchFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.coursecoverageplanbasicsearchfilter',
	frame: false,
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	style: 'margin-bottom: 0px !important',
	items: [{
		xtype: 'form',
		width: '100%',
		cls:'customSearchPanel',
		items: [{
			xtype:'hidden',
			name:'resourceTypeId'
		},{
			xtype:'hidden',
			name:'locationId'
		},{
			xtype:'hidden',
			name:'courseVariantId'
		},{
			xtype : 'radiogroup',
			itemId : 'courseSectionTypeRadio',
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
				name : 'sectionType',
				inputValue : 'PBS',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
				name : 'sectionType',
				inputValue : 'CBS'
			} ]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'programBatchPeriodContainer',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			hidden : true,
			items: [{
				xtype: 'customcombobox',
				name: 'program',
				itemId : 'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store : Ext.create('Academia.store.common.AssignedProgramStore'),
	        	displayField : 'code',
	        	valueField : 'id',
				queryParam:'programName',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}'  +
		                    '</div>';
		                }
		            }
				
				
			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
	        	displayField : 'batchName',
	        	valueField : 'id',
				disabled : true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
	        	displayField : 'programPeriodName',
	        	valueField : 'id',
				disabled : true,
				editable : false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				queryMode: 'local',
				typeAhead: false,
				forceSelection: true,
				allowBlank: false,
				anyMatch: true,
				hidden : true
			},{
				xtype: 'customcombobox',
				name: 'cbsProgram',
				itemId : 'cbsProgramId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'valueCode',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'cbsBatch',
				itemId : 'cbsBatchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				editable : false,
				queryMode: 'local'
				
			}]},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'courseComponentSectionContainer',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'cbsPeriod',
				itemId : 'cbsPeriodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				editable : false,
				queryMode: 'local'
			},{
				xtype: 'customcombobox',
				name: 'course',
				itemId: 'courseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store:Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
				displayField : 'value',
				valueField : 'id',
				forceSelection:true,
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{courseCodeName}'  +
		                    '</div>';
		                }
		            }
			},{
				xtype: 'customcombobox',
				name: 'component',
				itemId: 'componentSectionId',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store:'course.coursetopic.CourseComponentStore',
				displayField:'value',
				valueField:'id',
				hidden : true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'section',
				itemId: 'courseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store : Ext.create('Academia.store.programCourseDashboard.ParameterisedCourseSectionStore'),
				displayField : 'value',
				valueField : 'id',
				disabled:true,
				editable : false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'courseComponentSectionContainer_1',
			hidden : true,
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'course_1',
				itemId: 'courseId_1',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
	        	displayField : 'value',
	        	valueField : 'id',
				disabled : true,
				queryParam:'name',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}/{code}'  +
		                    '</div>';
		                }
		            }
			},{
				xtype: 'customcombobox',
				name: 'component_1',
				itemId: 'componentSectionId_1',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store : 'course.coursetopic.CourseComponentStore',
	        	displayField : 'value',
	        	valueField : 'id',
				hidden : true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'section_1',
				itemId: 'courseSection_Id_1',
				fieldLabel: getCommonTranslation('SECTION'),
				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar'),
	        	displayField : 'sectionCode',
	        	valueField : 'id',
				disabled:true,
				editable : false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				name: 'topics',
				itemId: 'topicsId',
				fieldLabel:getCourseTxCommonTranslation('TOPIC'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
	        	displayField : 'value',
	        	valueField : 'id',
				disabled:true,
				editable : false,
				autoloadStore:false,
			},{
				xtype: 'multiselectcombofield',
				name: 'faculty',
				itemId: 'facultyId',
				fieldLabel:getCourseTxCommonTranslation('FACULTY'),
				autoloadStore: false,
				width: 256,
				store : Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
				displayField : 'value',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'room',
				itemId: 'roomId',
				fieldLabel:getCommonTranslation('ROOM'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
				displayField : 'value',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'facultyDepartment',
				itemId: 'facultyDepartmentId',
				fieldLabel:getCommonTranslation('FACULTY_DEPARTMENT'),
				autoloadStore: false,
				width: 256,
				store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ParamatrizedFacultyDepartement'),
				displayField : 'value',
				valueField : 'id',
				queryParam:'query',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
					name : 'fromDate',
					itemId:'fromDate_Id',							
					format : CONSTANTS.DATE_FORMAT,
					endDateField : 'toDate_Id',
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				},{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('TO_DATE'),
					name : 'toDate',
					itemId:'toDate_Id',							
					format : CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					startDateField : 'fromDate_Id',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				},{
        			xtype : 'customcombobox',
        			name : 'attendanceMarked',
        			itemId:'attendanceMarked',
        			fieldLabel : getCommonTranslation('ATTENDANCE_MARKED'),		
        			store:'common.AttendanceMarkedType',
        			valueField : 'value',
        			displayField : 'name',
        			triggerAction : 'all',
        			editable : false,
        			allowBlank : true
        		}
				]},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		            defaults: {
		                width: 256,
		                labelAlign: 'top'
		            },
		            items: [{
				            xtype: 'checkboxfield',
				            width: 'auto',
				            labelAlign: 'right',
				            itemId:'cancelledSessions',
				            boxLabel: getCommonTranslation('ONLY_CANCELLED_SESSIONS'),
				            name: 'cancelledSessions',
				            inputValue : true,
				            uncheckedValue: false 
				        }]
		        	
				}, {
					xtype: 'fieldcontainer',
					width: 'auto',
		    		layout : {
		    			type : 'hbox'
		    		},
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
					items: [{
						xtype: 'button',
						text: getCommonTranslation('SEARCH'),
						itemId: 'quickSearchId',
						buttonAlign: 'left',
						ui: 'CustomBtnSubmit',
						scale: CONSTANTS.BUTTONSIZE
					},{
						xtype: 'button',
						itemId: 'resetBtn',
						text: getCommonTranslation('RESET'),
						ui:'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]
				}]
	}]
});