/**
 * Dharmendra.prajapati
 */

Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewSession',
				{
					extend : 'Ext.window.Window',
					alias : 'widget.newsession',
					title : getCourseTxCommonTranslation('ADD_NEW_SESSION'),
					modal : true,
					maxHeight : 600,
					autoScroll : true,
					items : [ {
						xtype : 'form',
						method : 'POST',
						itemId : 'newSession',
						autoScroll : true,
						margin : 0,
						// bodyPadding: '10 10 10 10',
						layout : {
							type : 'vbox'
						},
						defaults : {
							labelAlign : 'top'
						},
						standardSubmit : false,
						plugins : "formlabelrequired",
						items : [
								{
									xtype : 'hidden',
									name : 'id'
								},
								{
									xtype : 'hidden',
									name : 'roomId'
								},
								{
									xtype : 'hidden',
									name : 'sectionType'
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									defaults : {
										labelAlign : 'top',
										width: 256
									},
									layout : {
										type : 'hbox'
									},
									items : [
											{
												xtype : 'customcombobox',
												name : 'course',
												itemId : 'courseId',
												fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
												store : Ext
														.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
												displayField : 'value',
												valueField : 'id',
												queryParam : 'name',
												minChars : 3,
												forceSelection : true,
												allowBlank : false,
												emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
												listConfig : {
													listeners : {
														beforeshow : function(
																picker) {
															picker.minWidth = picker
																	.up(
																			'combobox')
																	.getSize().width;
														}
													},
													loadingText : getCommonTranslation('SEARCHING'),
													emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
													getInnerTpl : function() {
														return '<div class="search-item">'
																+ '{courseCodeName}'
																+ '</div>';
													}
												}
											},
											{
												xtype : 'customcombobox',
												name : 'courseSection',
												itemId : 'courseSection_Id',
												fieldLabel : getCommonTranslation('SECTION'),
												store : Ext
														.create('Academia.store.programCourseDashboard.ParameterisedSectionDetailsStore'),
												displayField : 'value',
												valueField : 'id',
												hidden : false,
												disabled : true,
												typeAhead : false,
												editable : false,
												allowBlank : false,
												forceSelection : true
											} ]
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									defaults : {
										labelAlign : 'top',
										width: 256
									},
									layout : {
										type : 'hbox'
									},
									items : [
											{
												xtype : 'textfield',
												name : 'session',
												readOnly : true,
												itemId : 'session_Id',
												//fieldLabel : getProgramandcourseTranslation('SESSION_NUMBER'),
												fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
												//disabled : true,
												emptyText : getCommonTranslation('AUTO_GENERATED')
											},
											{

												xtype : 'datefield',
												width: 256,
												name : 'sessionDate',
												itemId : 'sessionDateId',
												fieldLabel : getCommonTranslation('SESSION_DATE'),
												// allowBlank : false,
												listeners : {
													render : function(obj) {
														obj = dateFormatRender(obj);
														obj
																.setValue(new Date());
													}
												}

											} ]
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									defaults : {
										labelAlign : 'top',
										width: 256
									},
									layout : {
										type : 'hbox'
									},
									items : [
											{
												xtype : 'timefield',
												name : 'slotFrom',
												itemId : 'slotFrom',
												fieldLabel : getCourseTxCommonTranslation('CVG_TIME_FROM'),
												format : 'g:i A',
												vtype : 'timerange',
												endTimeField : 'slotTo',
												allowBlank : false
											},
											{

												xtype : 'timefield',
												name : 'slotTo',
												itemId : 'slotTo',
												fieldLabel : getCourseTxCommonTranslation('CVG_TIME_TO'),
												format : 'g:i A',
												vtype : 'timerange',
												startTimeField : 'slotFrom',
												allowBlank : false

											} ]
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									defaults : {
										labelAlign : 'top',
										width: 256
									},
									layout : {
										type : 'hbox'
									},
									items : [
											{
												xtype : 'customcombobox',
												name : 'classRoom',
												fieldLabel : getCourseTxCommonTranslation('CVG_ROOM'),
												itemId : 'classRommId',
												//store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoomStore',
												store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewClassRoomStore',
												displayField : 'code',
												valueField : 'id',
												queryMode : 'local',
												disabled : true,
												typeAhead : true,
												allowBlank : false,
												forceSelection : true
											},
											{
												xtype : 'textfield',
												name : 'studentNum',
												// itemId:'studentNumId',
												readOnly : true,
												hidden : false,
												fieldLabel : getCourseTxCommonTranslation('NO_OF_STUDENT')
											} ]
								},
								{
									xtype : 'multiselectcombofield',
									name : 'courseTopic',
									itemId : 'newSessionTopic_Id',
									width: 536,
									// fieldLabel:
									// getCourseTxCommonTranslation('CVG_TOPIC'),
									fieldLabel : getCommonTranslation('TOPICS'),
									//store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
									store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
									displayField : 'value',
									valueField : 'id',
									typeAhead : true,
									allowBlank : true,
									forceSelection : true,
									editable : false,
									disabled : true,
									listConfig : {
										listeners : {
											beforeshow : function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
											}
										}
									}
								},
								{
									xtype : 'multiselectcombofield',
									name : 'assignFaculty',
									itemId : 'assignFacultyId',
									width: 536,
									fieldLabel : getCourseTxCommonTranslation('CVG_ASSIGN_FACULTY'),
									store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection',
									displayField : 'value',
									valueField : 'id',
									disabled : true,
									allowBlank : false,
									typeAhead : true,
									forceSelection : true,
									addAllSelector : false,
									listConfig : {
										listeners : {
											beforeshow : function(picker) {
												picker.minWidth = picker.up(
														'combobox').getSize().width;
												picker.width = 'auto';
												setTimeout(
														function() {
															picker.el.dom.style.width = 'auto';
															picker.el.dom.style.minWidth = picker
																	.up(
																			'combobox')
																	.getSize().width
																	+ 'px';
														}, 10);
											},
											refresh : function(boundList, eOpts) {
												try {
													var combo = boundList
															.up('combo');
													var allItems = combo.listKeyNav.boundList.all.elements;
													var selectedDate = '';
													var comboStore = combo
															.getStore();
													if (typeof combo.getValue() != "string"
															&& combo.getValue().length < 6) {
														Ext
																.each(
																		allItems,
																		function(
																				currentItem) {
																			currentItem.classList
																					.remove("disabledComboItem");
																		});
													} else if (combo.getValue().length == 6) {
														var valueArray = [];
														Ext
																.each(
																		combo
																				.getValue(),
																		function(
																				currentValue) {
																			if (typeof currentValue == "object") {
																				valueArray
																						.push(currentValue
																								.get('id'));
																			} else {
																				valueArray
																						.push(currentValue);
																			}
																		});

														Ext
																.each(
																		allItems,
																		function(
																				currentItem) {
																			var currentFacultyId = currentItem.viewRecordId;
																			var currentFacultyRecord = comboStore
																					.findRecord(
																							'id',
																							currentFacultyId);
																			if (valueArray
																					.indexOf(currentFacultyRecord
																							.get('id')) != "-1") {
																				currentItem.classList
																						.remove("disabledComboItem")
																			} else {
																				currentItem.classList
																						.add("disabledComboItem");
																			}
																		});

													}
												} catch (e) {
												}
											}
										}
									},
									listeners : {
										beforeselect : function(selModel,
												record, index) {
											var combo = selModel.view.field;
											if (!isNullOrEmpty(combo.getValue())
													&& combo.getValue() != "") {
												if (typeof combo.getValue() == "object"
														&& combo.getValue().length == 6) {
													return false;
												}
											}
										},
										change : function(combo, newValue,
												oldValue, eOpt) {
											var allItems = combo.listKeyNav.boundList.all.elements;
											var selectedDate = '';
											var comboStore = combo.getStore();
											if (typeof combo.getValue() != "string"
													&& combo.getValue().length < 6) {
												Ext
														.each(
																allItems,
																function(
																		currentItem) {
																	currentItem.classList
																			.remove("disabledComboItem");
																});
											} else if (combo.getValue().length == 6) {
												var valueArray = [];
												Ext
														.each(
																combo
																		.getValue(),
																function(
																		currentValue) {
																	if (typeof currentValue == "object") {
																		valueArray
																				.push(currentValue
																						.get('id'));
																	} else {
																		valueArray
																				.push(currentValue);
																	}
																});

												Ext
														.each(
																allItems,
																function(
																		currentItem) {
																	var currentFacultyId = currentItem.viewRecordId;
																	var currentFacultyRecord = comboStore
																			.findRecord(
																					'id',
																					currentFacultyId);
																	if (valueArray
																			.indexOf(currentFacultyRecord
																					.get('id')) != "-1") {
																		currentItem.classList
																				.remove("disabledComboItem")
																	} else {
																		currentItem.classList
																				.add("disabledComboItem");
																	}
																});

											}

										}
									}
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									width: 536,
									items : [
											{
												xtype : 'checkboxfield',
												width : 200,
												labelAlign : 'right',
												boxLabel : getCourseTxCommonTranslation('CVG_OPTIONAL_SESSION'),
												name : 'optionalSession',
												inputValue : true,
												uncheckedValue : false
											},
											{
												xtype : 'checkboxfield',
												width : 260,
												labelAlign : 'right',
												boxLabel : getCourseTxCommonTranslation('CVG_SESSION_ATTENDANCE'),
												name : 'whetherAttendanceToBeEntered',
												inputValue : true,
												uncheckedValue : false
											} ]
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									width: 536,
									cls:'sessionStatus',
									items : [
											{
												xtype : 'checkboxfield',
												width : 200,
												labelAlign : 'right',
												boxLabel : getCourseTxCommonTranslation('CVG_SESSION_PLANNED'),
												name : 'sessionPlanned',
												readOnly : true,
												inputValue : true,
												uncheckedValue : false
											},{
												xtype : 'displayfield',
												name : 'sessionStatus',
												fieldLabel : getCourseTxCommonTranslation('SESSION_STATUS'),
												value : getCourseTxCommonTranslation('HW_ACTIVE'),
												
												
											}]
								},
								{
									xtype : 'fieldcontainer',
									//        	width:'100%',
									cls : 'windowBtnPos',
									//			layout:'hbox',
									//			style:{marginTop:'10px'},
									items : [
											{
												xtype : 'button',
												action : 'Submit',
												text : getCourseTxCommonTranslation('SAVE'),
												formBind : true,
												itemId : 'SubmitBtn',
												ui : 'CustomBtnSubmit',
												scale : CONSTANTS.BUTTONSIZE
											},
											{
												xtype : 'button',
												text : getCourseTxCommonTranslation('CANCEL'),
												ui : 'CustomBtnCancel',
												itemId : 'CancelBtn',
												scale : CONSTANTS.BUTTONSIZE
											} ]
								} ]
					} ]
				});