var consolidateSummaryGridStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.EditCourseSectionGridStore');
Ext.define('Academia.view.coursetransaction.sectionmanagement.EditCourseSectionListGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.editcoursesectionlistgrid',
	store : consolidateSummaryGridStore,
	title: getProgramandcourseTranslation('COURSE_SECTION_LIST'),
	border: true,
	autoScroll: false,
	selType :'checkboxmodel',
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'editcoursesectiongroupstructure':1
		}
	},
	/*dockedItems : [{
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : consolidateSummaryGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SAVE'),
		itemId: 'saveBtnNew',
		formBind:true,
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getExaminationTranslation('RESET'),
		itemId: 'resetGridBtnNew',
		scale: CONSTANTS.BUTTONSIZE,
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	columns: [{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1,
	},{
		header : getCommonTranslation('CAMPUS_CODE'),
		dataIndex : 'campusCode',
		flex : 1
	},{
		header : getCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionName',
		flex : 1,
		editor: {
			xtype: 'textfield',
			name:'sectionName',
			itemId:'sectionName',
			maxLength:99,
			allowBlank:false
		},
		renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				return val;
			}
		}
	},{
		header : getCourseTxCommonTranslation('HOME_ROOM'),
		dataIndex : 'roomId',
		flex : 1,
		editor: {
			xtype: 'customcombobox',
			name:'roomId',
			itemId:'roomId',
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			editable:false,
			listeners: {
				select: function(combo, record) {
					var roomId = record[0].get("id");
					var grid = combo.up('grid');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID,
						params : {
							id:roomId
						},
						method : 'GET',
						success : function(form, action) {
							var resData = 	Ext.JSON.decode(form.responseText);
							var resourceBookingPurposes = resData.resourceBookingPurposes;
							var acadmicFlag = false;
							for(var i=0; i<resourceBookingPurposes.length;i++){
								if(resourceBookingPurposes[i].bookingPurpose.value == 'Academic'){
									acadmicFlag = true;
									var capacity = resourceBookingPurposes[i].capacity;
									selectedRecord.set('roomId',resData.id);
									selectedRecord.set('maxCapacity',capacity);
								}
							}
							/*if(!acadmicFlag){
								programWinForm.findField('assignHomeRoom').reset();
								programWinForm.findField('maxCapacity').reset();
								showWarningMessage(getCommonTranslation('ALERT'),getCourseTxCommonTranslation('ACADMIC_ROOM_MSG'));
							}*/
						}
					});
					}
				
			}
		},
		listeners: {
			render: function(combo){
				combo.getEditor().store.load();
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    				else{
        				rec.tdCls = 'gridInputCustomStyle';
        				return getExaminationTranslation('CLICK_TO_ENTER');
        			}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				rec.tdCls = 'gridInputCustomStyle';
    				return getExaminationTranslation('CLICK_TO_ENTER');
    			}
    		}
    	}
		/*renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_SELECT');
			}else{
				return rec.record.data.roomId;
			}
			return rec.record.data.roomId;
		}*/
	},{
		header : getCourseTxCommonTranslation('MAX_CAPACITY'),
		dataIndex : 'maxCapacity',
		flex : 1,
		editor: {
			xtype: 'numberfield',
			name:'maxCapacity',
			itemId:'maxCapacity',
			minValue:0,
  		    maxValue : 5000,
  		    hideTrigger:true,
			allowExponential:false,
			allowDecimals:false,
		},
		renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				return val;
			}
		}
	},{
		header : getCommonTranslation('EVALUATION_PLAN'),
		dataIndex : 'printNameInMarksheet',///
		flex : 1,
		sortable: false
	},
	{
		header : getCommonTranslation('ENROLLMENT_CRITERIA'),
		dataIndex : 'studentCourseEnrollmentCriteria',
		flex : 1,
		editor: {
			xtype: 'customcombobox',
			name:'studentCourseEnrollmentCriteria',
			itemId:'studentCourseEnrollmentCriteria',
			store:'common.StudentEnrolmentCriteriaStore',
			displayField:'value',
			valueField:'id',
			editable:false
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    				else{
        				rec.tdCls = 'gridInputCustomStyle';
        				return getExaminationTranslation('CLICK_TO_ENTER');
        			}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				rec.tdCls = 'gridInputCustomStyle';
    				return getExaminationTranslation('CLICK_TO_ENTER');
    			}
    		}
    	}
		/*renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_SELECT');
			}else{
				return rec.record.data.studentCourseEnrollmentCriteria;
			}
			return rec.record.data.studentCourseEnrollmentCriteria;
		}*/
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(editor, context) {
				if(editor.context.field=='printNameInMarksheet'){   ///
	    			if(!isNullOrEmpty(context.record.data.printNameInMarksheet)){
	    				context.grid.columns[4].getEditor().setReadOnly(true);
	    				return context.colIdx !== 4;
	    			}else{
	    				context.grid.columns[4].getEditor().setReadOnly(false);
	    			}

	    		}
				if(editor.context.field=='evaluationPlanId'){
					return false;
				}
            }
	
        }
	}]
});
