var consolidateDetailedGridStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseVariantProgramMappingGridStore');
Ext.define('Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionDetailedViewGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managecoursesectiondetailedviewgrid',
	store : consolidateDetailedGridStore,
	title: getCommonTranslation('COURSE_SECTION_LIST'),
	border: true,
	selType :'checkboxmodel',
	itemId: 'managecoursesectiondetailedviewgridId',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : consolidateDetailedGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled : true
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hidden : true,
		disabled : true
	},{
		xtype: 'button',
		text:getCommonTranslation('ADD_FACULTY'),
		itemId:'addFaculty',
		tooltip :getCommonTranslation('ADD_FACULTY'),
		disabled:true
	},{
		xtype: 'button',
		text:getCourseTxCommonTranslation('MAP_PROGRAM_PERIOD'),
		itemId:'mapProgramPeriod',
		tooltip :getCourseTxCommonTranslation('MAP_PROGRAM_PERIOD'),
		disabled:true
	},{
		 xtype: 'button',
		 itemId: 'studentEnrollmentBtn',
		 text: getCommonTranslation('STUDENT_ENROLLMENT')
	 },{
		 xtype: 'button',
		 itemId: 'courseEnrollmentBtn',
		 text: getCommonTranslation('COURSE_ENROLLMENT')
	 }],
	columns: [{
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex : 1,
		hidden : true
	},{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1,
		hidden : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1
	},{
		header : getCommonTranslation('CAMPUS_CODE'),
		dataIndex : 'campusCode',
		flex : 1
	},{
		header : getCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionName',
		flex : 1
	},{
		header : getCommonTranslation('SECTION_PRINT_NAME'),
		dataIndex : 'sectionPrintName',
		flex : 1,
		hidden : true
	},{
		header : getCommonTranslation('CALENDAR'),
		dataIndex : 'calendar',
		flex : 1,
		hidden : true
	},{
		header : getCommonTranslation('HOME_ROOM'),
		dataIndex : 'homeRoom',
		flex : 1
	},{
		header : getCommonTranslation('CAPACITY'),
		dataIndex : 'maxCapacity',
		flex : 1
	},{
		header : getCommonTranslation('PRIMARY_FACULTY'),
		dataIndex : 'primaryFaculty',
		flex : 1
	},{
		header : getCommonTranslation('ENROLLED_STUDENTS'),
		dataIndex : 'enrolledstudents',
		flex : 1,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCommonTranslation('PROGRAMS_ASSOCIATED'),
		dataIndex : 'programAssociated',
		flex : 1
	}]
});
