/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.MapProgramPeriodWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.mapprogramperiodwin',
	title:getCourseTxCommonTranslation('PROGRAM_PERIOD'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'mapprogramperiodwinId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				hidden : false,
				width: 256,
				editable : false 
			},{
				
				xtype: 'customcombobox',
				name: 'program',
			    itemId:'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				 store:'common.ProgramByAcademyLocationStore',
				allowBlank:false,
				displayField:'valueCode',
				valueField:'id',
				width: 256,
				typeAhead:false,
				minChars:3,
				forceSelection:true,
				queryParam:'programName',
			    typeAhead:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }  
	            }
			}]  
		},
		{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'batchId',
				fieldLabel: getCourseTxCommonTranslation('BATCH'),
				itemId:'batchId',
				allowBlank:false,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				disabled : true
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				width: 256,
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				disabled : true
			}]  
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});