/**
 * Abhishek Bais
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.ProgramBatchStudentUnenrolledSectionDetails',{
	extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.programbatchstudentunenrolledsectiondetails',
	plugins : "formlabelrequired",
	cls:'horizontalScrollingFixed customSearchPanel',
	
	defaults : {
		labelAlign : 'top',
		width: 256,
		margin: 0
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype:'hidden',
			name:'sectionId',
			itemId:'sectionId'
		},{
			xtype:'hidden',
			name:'periodId',
			itemId:'periodId'
		},{
			xtype:'displayfield',
			name:'programName',
			itemId:'programName',
			fieldLabel: getCommonTranslation('PROGRAM_NAME'),
		},{
			xtype:'displayfield',
			name:'batchName',
			itemId:'batchName',
			fieldLabel: getCommonTranslation('BATCH_NAME'),
		},{
			xtype: 'displayfield',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD')
		},{
			xtype: 'displayfield',
			name: 'sectionGroupName',
			itemId:'sectionGroupName',
			hidden : true,
			fieldLabel: getCourseTxCommonTranslation('SECTION_GROUP_NAME')
		}
		]},
		{
			xtype : 'fieldcontainer',
			itemId:'programBatchExam_Id',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				fieldLabel: getProgramandcourseTranslation('EXAM_TYPE'),
				itemId:'examTypeId',
				name: 'examType',
				store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.courses.ExamTypeStore'),
				valueField: 'id',
				displayField: 'value',
				allowBlank:true,
				typeAhead:true
			},
			{
				xtype: 'customcombobox',
	            fieldLabel: getPersonModuleTranslation('NAME_OF_EXAM'),
	            store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.courses.ExamNameStore'),
	            valueField: 'id',
	            displayField: 'value',
	            name: 'examinationName',
	            itemId: 'examinationName',
	            allowBlank:true,
	            editable: false,
	            hideTrigger:false,
	            triggerAction: 'all',
	            forceSelection:false,
	            disabled:true
	        }
				
			]},
			{
				xtype : 'fieldcontainer',
				itemId:'programBatchExamMarks_Id',
				width: 'auto',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'numberfield',
					fieldLabel: getCommonTranslation('EXAM_PASSED_MIN_MARKS'),
					itemId:'minId',
					name: 'MIN_ID',
					valueField: 'id',
					minValue:0,
					displayField: 'value',
					allowBlank:true,
					typeAhead:true,
					forceSelection:false	 ,
					disabled:true,
					forceSelection : false,
					validateOnBlur: true,
					validator : function(val) {
						var me = this;
						var maxValueField = Ext.ComponentQuery.query('numberfield#maxId')[0];
						var maxValue = maxValueField.getValue();
						var minValue = me.minValue;
						if(isNullOrEmpty(maxValue)){
							maxValue = 1000;
						}
						if (minValue != null) {
							if (val >maxValue || val < minValue) {
								if(val < minValue){
									
									return 'This field value should be greater than or equal to '+minValue;
								}
								else if(val > maxValue){
									return 'This field value should be less than or equal to '+maxValue;
								}
							} else {
								maxValueField.clearInvalid();
								me.clearInvalid();
								return true;
							}
						} else {
							return true;
						}
					},
					listeners: {
						validitychange: function(field, isValid, eOpts){
							setTimeout(function(){
								field.isValid();
							},100);
						}
					}

				},
				{
					xtype : 'numberfield',
					fieldLabel : getCommonTranslation('EXAM_PASSED_MAX_MARKS'),
					width: 256,
					labelAlign: 'top',
					name : 'MAX_ID',
					itemId : 'maxId',
					minValue:0,
					maxValue:1000,
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : false,
					validateOnBlur: true,
					validator : function(val) {
						var me = this;
						var minValueField = Ext.ComponentQuery.query('numberfield#minId')[0];
						var minValue = minValueField.getValue();
						var maxValue = me.maximumValue;
						if(isNullOrEmpty(minValue)){
							minValue = 0;
						}
						if (minValue != null) {
							if (val < minValue || val > maxValue) {
								if(val < minValue){
									return 'This field value should be greater than or equal to '+minValue;
								}
								else if(val > maxValue){
									return 'This field value should be less than or equal to '+maxValue;
								}
							} else {
								minValueField.clearInvalid();
								me.clearInvalid();
								return true;
							}
						} else {
							return true;
						}
					},
					listeners: {
						validitychange: function(field, isValid, eOpts){
							setTimeout(function(){
								field.isValid();
							},100);
						}
					}
				}
					
				]},
				{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentUnerolledSearchBtn',
			//buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetCbsUnenrolledButton',
		//	buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
