/**
 * @author Dharmendra.Prajapati
 * @author seshagiri.k 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.CourseEnrollmentCourseSectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courseenrollmentcoursesectionsearch',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		/*xtype: 'form',
        width: '100%',
        items: [{*/
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			itemId: 'programId',
			name: 'PROGRAM_ID',
			store:'program.ProgramsAssociatedWithCourseVariant',
			displayField:'valueCode',
			valueField: 'id',
			queryParam:'qry',
			minChars:3,
			allowBlank:false,
			typeAhead:true,
			//forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			name: 'PROGRAM_BATCH_ID',
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			typeAhead:true,
			//forceSelection:true,		
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			itemId:'periodId',
			name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
			store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			forceSelection:true	 ,
			disabled:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSES'),
			itemId: 'courseCodeId',
			name: 'COURSE_ID',
			store:'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
			valueField:'id',
			displayField:'valueCode',
			allowBlank:true,
			disabled:true,
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			hidden:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
			store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
			displayField: 'code',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			hidden:true,
			allowBlank:true,
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentCourseSectionSearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetButton',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
//}]
});