/*
 * @author sumit meena
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.StudentSearch', {   
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.studentsearch',
	title : getCommonTranslation('QUICK_SEARCH'),
	autoScroll: true,
	//frame: true,
	method : 'POST',
	isMinWidthNotRequired: true,
	//layout : 'vbox',
	standardSubmit : false,
	cls: 'customSearchPanel',
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'id'
	},{
			xtype:'hidden',
			name:'batchId'
		},{
			xtype:'hidden',
			name:'periodId'
		},{
			xtype:'hidden',
			name:'sectionId'
		},{
			xtype:'hidden',
			name:'courseGroupId'
		},{
			xtype:'hidden',
			name:'admissionId'
		},{
			xtype:'fieldcontainer',
		width: 'auto',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name:'studentNameSearch',
				itemId: 'studentFieldItemId',
				store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
				fieldLabel:getCommonTranslation('STUDENT_CODE_NAME'),
			width: 256,
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:5,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_FIVE_CHAR'),
				forceSelection:true,
				allowBlank:false,
			matchFieldWidth:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				width: 256,
				fieldLabel: getCourseTxCommonTranslation('PROGRAM_BATCH'),
				store : Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.ProgramBatchPeriodByStudentId'),
				displayField : 'programbatchName',
				valueField : 'admissionId',
				disabled : true,
				editable : false,
			allowBlank:false,
			  matchFieldWidth:true,
              listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				}
           }
			},{	
			    	   xtype: 'customcombobox',
			    	   name:'programId',
			    	   itemId:'programIdItemId',
			    	   store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentSearchProgamCombo',
			    	   displayField: 'programShortName',
			    	   valueField: 'programId',
			    	   disabled:true,
			    	   hidden:true,
		    	   fieldLabel:getCourseTxCommonTranslation('PROGRAM'),
		    	   matchFieldWidth:true,
                   listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
		       },{	
		    	   xtype: 'customcombobox',
		    	   name:'fPeriodId',
		    	   itemId:'periodId',
		    	   store : Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.AllFuturePeriodForStudentStore'),
		    	   displayField: 'value',
		    	   valueField: 'id',
		    	   disabled : true,
				    editable : false,
					allowBlank:false,
		    	   fieldLabel:getProgramandcourseTranslation('PERIOD'),
		    	   matchFieldWidth:true,
                   listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			       }]},{
			            xtype: 'fieldcontainer',
			            width: 'auto',
			            layout: 'hbox',
			            defaults: {
			                width: 256,
			                labelAlign: 'top'
			            },
			            items: [{
					            xtype: 'checkboxfield',
					            labelAlign: 'right',
					            itemId:'allowRepeatCourses',
					            boxLabel: getProgramandcourseTranslation('SHOW_REPEAT_COURSES'),
					            name: 'allowRepeatCourses',
					            inputValue : true,
					            uncheckedValue: false 
					        },{
					            xtype: 'checkboxfield',
					            labelAlign: 'right',
					            itemId:'allowBacklogCourses',
					            boxLabel: getProgramandcourseTranslation('SHOW_BACKLOG_COURSES'),
					            name: 'allowBacklogCourses',
					            inputValue : true,
					            uncheckedValue: false 
					        }]
			        	},{
			    	   xtype: 'fieldcontainer',
			    	   //width: 'auto',
			    	   style:{
			    		   'margin-left':'-64px !important' 
			    	   },
			    	   layout: 'hbox',
			   		cls: 'customSearchPanelBtnsFieldContainerCls',
			    	   items: [{
			    		   xtype: 'button',
			    		   text: getCommonTranslation('SEARCH'),
			    		   itemId: 'studentEnrolmntDetailTabSearchBtn',
			    		   //buttonAlign: 'left',
			    		   ui: 'CustomBtnSubmit',
			    		   formBind:true,
			    		   scale: CONSTANTS.BUTTONSIZE
			    	   },{
			    		   xtype: 'button',
			    		   text: getCourseTxCommonTranslation('RESET'),
			    		   itemId: 'studentEnrolmntDetailTabResetBtn',
			    		   //buttonAlign: 'left',
			    		   ui: 'CustomBtnCancel',
			    		   scale: CONSTANTS.BUTTONSIZE
			    	   }]
			       }]
});
