/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.importStudentCourseEnrollment.DownloadTemplateLegacyStudentCourseEnrollment',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadtemplatelegacystudentenrollmentform',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame: false,
	border:false,
	method : 'POST',
	standardSubmit : false,
	items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStore'),
				valueField : 'id',
				typeAhead : true,
				allowBlank : false,
				editable : false
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId: 'program_Id',
				name: 'program',
				store:Ext.create('Academia.store.feeandpayment.dashboardAndReports.FeeProgramCodeStore'),
				displayField:'valueCode',
				valueField: 'id',
				allowBlank:false,
				typeAhead:false,
				disabled:true,
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				name : 'batch',
				itemId : 'batch_Id',
				store : Ext.create('Academia.store.program.programDetails.programBatches.ProgramBatchesGridStore'),
				displayField : 'name',
				valueField : 'id',
				typeAhead : true,
				disabled:true,
				forceSelection : true,
				allowBlank : false
			}]
		},
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'period',
				itemId : 'period_Id',
				store : Ext.create('Academia.store.program.programDetails.programBatches.LegacyStudentPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead : true,
				forceSelection : true,
				disabled:true,
				allowBlank : false
			},{
				xtype : 'multiselectcombofield',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				name : 'CourseVariantName',
				itemId : 'CourseVariantID',
				store : Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField : 'courseVariantCode',
				valueField : 'id',
				minChars:3,
				queryParam:'name',
				allowBlank : false,
				disabled:true,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				matchFieldWidth:true,
				queryMode:'remote',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
			layout: 'hbox',
			style:{
    			'margin-left':'-32px !important'
    		},
			items: [{
				xtype:'button',
				itemId:'studentcourseenrollmentDownload',
				text:getCommonTranslation('DOWNLOAD_TEMPLATE'),
				ui: 'CustomBtnSubmit',
				formBind:true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
});