/**
 * @author Dharmendra.Prajapati
 * @author seshagiri.k 
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.CBSProgramFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.cbsprogramfilter',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			itemId: 'programId',
			name: 'PROGRAM_ID',
			store:'program.ProgramsAssociatedWithCourseVariant',
			displayField:'valueCode',
			valueField: 'id',
			queryParam:'qry',
			minChars:3,
			allowBlank:false,
			typeAhead:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			name: 'PROGRAM_BATCH_ID',
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			typeAhead:true,
			disabled:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			itemId:'periodId',
			name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
			store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			forceSelection:true	 ,
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 256,
			labelAlign: 'top',
			name : 'PROGRAM_BATCH_SECTION_ID',
			itemId : 'program_Batch_Section_Config_ID',
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			disabled:true,
			forceSelection : true
		},/*{
			xtype: 'customcombobox',
			name: 'courseType',
			itemId:'courseTypeId',
			value:'1',
			fieldLabel: getCourseTxCommonTranslation('COURSE_TYPE'),
			 store: Ext.create('Ext.data.Store', {
                 fields: ['id', 'value'],
                 data: [{
                     id: '1',
                     value: getCourseTxCommonTranslation('REGULAR')
                 }, {
                     id: '2',
                     value: getCourseTxCommonTranslation('ADDITIONAL')
                 },{
                     id: '3',
                     value: getCourseTxCommonTranslation('REPEAT')
                 },{
                     id: '4',
                     value: getCourseTxCommonTranslation('BECKLOG')
                 }]
             }),
             displayField: 'value',
             valueField: 'id',
             forceSelection: true,
             editable: false,
             allowBlank: true
         },*/{
			xtype: 'customcombobox',
			fieldLabel: getProgramandcourseTranslation('EXAM_TYPE'),
			itemId:'examTypeId',
			name: 'examType',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.courses.ExamTypeStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true
		}]},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
	            fieldLabel: getPersonModuleTranslation('NAME_OF_EXAM'),
	            store: 'coursetransaction.studentenrollment.studentenrollmentdetail.courses.ExamNameStore',
	            valueField: 'id',
	            displayField: 'value',
	            name: 'examinationName',
	            itemId: 'examinationName',
	            allowBlank:true,
	            editable: false,
	            hideTrigger:false,
	            triggerAction: 'all',
	            forceSelection:false,
	            disabled:true
	        },{
				xtype: 'numberfield',
				fieldLabel: getCommonTranslation('EXAM_PASSED_MIN_MARKS'),
				itemId:'minId',
				name: 'MIN_ID',
				valueField: 'id',
				minValue:0,
				maxValue:1000,
				displayField: 'value',
				allowBlank:true,
				typeAhead:true,
				forceSelection:false	 ,
				disabled:true
			},{
				xtype : 'numberfield',
				fieldLabel : getCommonTranslation('EXAM_PASSED_MAX_MARKS'),
				width: 256,
				labelAlign: 'top',
				name : 'MAX_ID',
				itemId : 'maxId',
				minValue:0,
				maxValue:1000,
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				forceSelection : false,
				validateOnBlur: true,
				validator : function(val) {
					var me = this;
					var minValueField = Ext.ComponentQuery.query('numberfield#minId')[0];
					var minValue = minValueField.getValue();
					var maxValue = me.maximumValue;
					if(isNullOrEmpty(minValue)){
						minValue = 0;
					}
					if (minValue != null) {
						if (val < minValue || val > maxValue) {
							if(val < minValue){
								return 'This field value should be greater than or equal to '+minValue;
							}
							else if(val > maxValue){
								return 'This field value should be less than or equal to '+maxValue;
							}
						} else {
							minValueField.clearInvalid();
							me.clearInvalid();
							return true;
						}
					} else {
						return true;
					}
				},
				listeners: {
					validitychange: function(field, isValid, eOpts){
						setTimeout(function(){
							field.isValid();
						},100);
					}
				}
			}]},
		{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items : [/*{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSES'),
			itemId: 'courseCodeId',
			name: 'COURSE_ID',
			store:'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
			valueField:'id',
			displayField:'valueCode',
			allowBlank:true,
			disabled:true,
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			hidden:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
			store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
			displayField: 'code',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			hidden:true,
			allowBlank:true,
			disabled:true
		}*/]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentCourseSectionSearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetCbsUnenrolledButton',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
//}]
});