Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.PBSCourseEnrollmentGrid',
	{
		extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
		alias : 'widget.pbscourseenrollmentgrid',
		store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid',
		title : getProgramandcourseTranslation('LIST_OF_EROLLED_STUDENTS'),
		selType : 'checkboxmodel',
		itemId : 'PBSCourseEnrollmentGridItemId',
		selModel : {
			multiSelect : true,
			mode : 'SIMPLE',
			checkOnly : false
		},
		border : true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		initComponent : function() {
			var grid = this;
			grid.addExportToolBarItems(grid);
			this.callParent(arguments);
		},
		dockedItems : [ {
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins : [ 'pagesize' ],
				displayInfo : true,
				emptyMsg : getCommonTranslation('NORESULTSNMESSAGE'),
				store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid'
			} ]
		} ],
		tbar : [
				{
					xtype : 'button',
					itemId : 'btnCourseUnEnrollStudent',
					text : getCommonTranslation('UNENROLL'),
					tooltip : getCommonTranslation('UNENROLL'),
				},
				{
					xtype : 'button',
					text : getCommonTranslation('DEENROLL'),
					itemId : 'btnCourseDeEnrollStudent',
					tooltip : 'It wont Keep De-Enrollment Records'
				},
				{
					xtype : 'button',
					itemId : 'btnPBSChangeCourseEnrollemntDate',
					text : getProgramandcourseTranslation('CHANGE_ENROLLMENT_DATE'),
				} ],
		columns : [ {
			header : getCommonTranslation('STUDENT_CODE'),
			dataIndex : 'studentCode',
			sortable : true,
			flex : .1,
			renderer:function(value,meta,record){
				if(record.data.studentCode == 0){
					return record.data.studentCode ;
				} else {
					return '<a href=#>'+record.data.studentCode +'</a>'
				}
			}
		}, {
			header : getCommonTranslation('ADMISSION_CODE'),
			dataIndex : 'admissionCode',
			sortable : true,
			flex : .1
		}, {
			header : getCommonTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex : .1
		}, {
			header : getCommonTranslation('FIRST_NAME'),
			dataIndex : 'firstName',
			flex : .1,
			hidden : true
		}, {
			header : getCommonTranslation('MIDDLE_NAME'),
			dataIndex : 'middleName',
			flex : .1,
			hidden : true
		}, {
			header : getCommonTranslation('LAST_NAME'),
			dataIndex : 'lastName',
			flex : .1,
			hidden : true
		}, {
			header : getCommonTranslation('ENROLLMENT_DATE'),
			dataIndex : 'enrollmentDate',
			sortable : true,
			flex : .1,
			renderer : function(date) {
				return dateRender(date);
			}
		} ]
	});