/**
 * @author Rajkumar.Patidar
 */


Ext.define('Academia.view.coursetransaction.studymaterialdistribution.ApprovalFormWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.approvalformwin',
	title:getCourseTxCommonTranslation('APPROVAL'),
	frame: true,
	modal:true,
	maxHeight: 600,
	items: [{
		xtype: 'form',
        method: 'POST',
        itemId:'approvalform',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
		items: [{
				xtype: 'hidden',
				name: 'id'
			},{
				xtype: 'textfield',
				name: 'approvedByName',
				readOnly:true,
				value:'System Admin',
				itemId:'approvedByName',
				fieldLabel: getCourseTxCommonTranslation('APPROVED_BY')
		    },{
      	    	xtype: 'datefield',
    		    name: 'approveDate',
    		    itemId:'approveDate',
    		    fieldLabel: getCourseTxCommonTranslation('APPROVED_DATE'),
    		  //--submitFormat: CONSTANTS.DATE_FORMAT,
                allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
	    	},{
      	    	xtype: 'textfield',
				name: 'approvedReason',
				itemId:'approvedReason',
				fieldLabel: getCourseTxCommonTranslation('APPROVED_REASON'),
				allowBlank:false
      	    /* },{
      	    	xtype: 'radiogroup',
      			itemId:'approvedStatus',
      			fieldLabel: getCourseTxCommonTranslation('APPROVED_STATUS'),
      			items:[
      			       { boxLabel:getCourseTxCommonTranslation('YES'), name: 'approvedStatus', inputValue: true ,checked:true },
      			       { boxLabel:getCourseTxCommonTranslation('NO'), name: 'approvedStatus', inputValue: false}
      			       ]	
      	     },{*/
		     },{	
			  layout:'hbox',
			  style:{marginTop:'10px'},
			  items: [{
					xtype: 'button',
					action: 'Submit',
					text: getCourseTxCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
		      	 },{
					xtype: 'button',
					text: getCourseTxCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
			      }]
		   }]
	  }]     
});