/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistribution.DistributionListforCourseReading', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.distributionlistforcoursereading',
	store : 'coursetransaction.studymaterialdistribution.DistributionforCourseReadingStore',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.studymaterialdistribution.DistributionforCourseReadingStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCourseTxCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCourseTxCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCourseTxCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCourseTxCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
    	xtype : 'splitbutton',
  	    itemId:'spBtnMoreActions',
  	    text : getCourseTxCommonTranslation('MOREACTIONS'),
  	    menu:[{
  		    text:getCourseTxCommonTranslation('ASSIGN_READING_STUDENT'),
  		    itemId:'assignReadingLinked'
  	        },{
  	    	text:getCourseTxCommonTranslation('COPY'),
  	  		itemId:'copyLinked'
  	    }]
    }],
	columns: [{
		hidden : true,
		dataIndex : 'id'
	},{
		header : getCourseTxCommonTranslation('LIST_NAME'),
		dataIndex : 'listName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('CREATED_DATE'),
		dataIndex : 'createdDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getCourseTxCommonTranslation('CREATED_BY_ID'),
		dataIndex : 'createdBy',
		flex:1,
		renderer : function(value){
			if(value != null){
				return value.id;
			}
		}
	},{
		header : getCourseTxCommonTranslation('CREATED_BY_NAME'),
		dataIndex : 'createdBy',
		flex:1,
		renderer : function(value){
			if(value != null){
				return value.value;
			}
		}
		
	},{
		header : getCourseTxCommonTranslation('DISTRIBUTOIN_MODE'),
		dataIndex : 'distributionMode',
		flex:1,
		renderer : function(value){
			if(value != null){
				return value.value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('DISTRIBUTOIN_LIST_TYPE'),
		dataIndex : 'distributionListType',
		flex:1
	}]
});