Ext.define('Academia.view.criteriabuilder.grid.SearchResultGrid',{
	extend:'Ext.grid.Panel',
//	store:'criteriabuilder.SearchResultStore',
	alias:'widget.searchresultgrid',
//	requires:['Academia.view.criteriabuilder.grid.MultiSortToolbar'],
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	margin:'0 0 0 0',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	cls:'mb-40',
	columns:[],
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'onlineuserreportquicksearchview': 1
        }
    },
	initialize:function(searchEndPointURL,ViewUrl,searchCriteria,extraColumns){
       var flag='def';
		// if configCode is = FINAL_ADMISSION_LIST then search btn will disabled till search is not completed;
		var searchBtn = null;
		if((searchCriteria.configCode=='APPLICATION_LIST' || searchCriteria.configCode=='PROGRAM_LIST' ||searchCriteria.configCode=='STUDENT_LIST' || searchCriteria.configCode=='USER_LIST' || searchCriteria.configCode=='TRACK_ENQUIRY_ADMISSION' || searchCriteria.configCode=='CORPORATE_ENQUIRY_LIST' || searchCriteria.configCode=='TRACK_ENQUIRY_NON_ADMISSION' || searchCriteria.configCode=='FINAL_ADMISSION_LIST' || searchCriteria.configCode=='CAMPAIGN_LIST' || searchCriteria.configCode=='STUDENT_TRACK_REQUEST' || searchCriteria.configCode=='TERMINATE_STUDENT_LIST' || searchCriteria.configCode=='RPT_STUDENT_KYS_DATA_REPORT' || searchCriteria.configCode=='RPT_STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT' || searchCriteria.configCode=='RPT_STUDENT_COMMUNITY_REPORT' || searchCriteria.configCode=='RPT_STUDENT_EMPLOYEE_CHILDREN_REPORT' || searchCriteria.configCode=='COURSE_LIST' || searchCriteria.configCode=='COURSE_GROUP_LIST' || searchCriteria.configCode=='COURSE_SPECIALIZATION' || searchCriteria.configCode=='STUDY_MATERIAL_DISTRIBUTION_REPORT' || searchCriteria.configCode=='PR_BATCH_CREATED_PROGRAM_WISE' || searchCriteria.configCode=='PR_PERIOD_ASSOCIATED' || searchCriteria.configCode=='PR_ASSOCIATED_EXAM_CENTER' || searchCriteria.configCode=='PR_SECTION_ASSOCIATED' || searchCriteria.configCode=='PR_SPECIALIZATION_AVAILABLE_BATCHWISE' || searchCriteria.configCode=='CR_COURSE_COMPONENT_ASSOCIATED' || searchCriteria.configCode=='CR_READING_MATERIAL_ASSOCIATED' || searchCriteria.configCode=='CR_COURSE_VARIANTS_ASSOCIATED' || searchCriteria.configCode=='CR_TOPIC_CREATED' || searchCriteria.configCode=='COURSE_EVALUATION' || searchCriteria.configCode=='SPECIALIZATION_STUDENT_RECORD_LIST') && searchEndPointURL =='rest/cb/executeBasicSearch'){
        	searchBtn = extraColumns;
        	extraColumns = undefined;
        }
	   var searchGridCol =this;
        
		var searchResultColumns=this.getStore().proxy.reader.getFields();
		if(searchCriteria.searchResultViewColumns!=null && searchCriteria.searchResultViewColumns.length>0){
			searchResultColumns=this.loadCustomSearchResultViewDefination(searchCriteria.searchResultViewColumns);
		}

		else /*if(searchResultColumns.length < 2)*/{
			searchResultColumns = this.loadSearchResultViewDefination(ViewUrl);
		}
		var alinfomodel = Academia.model.authentication.ALInfoModel;
   	    var wheatherSchool = alinfomodel.get('wheatherSchool');
   	    store = this.createGridStore(searchResultColumns,searchEndPointURL,searchCriteria);
   	    this.addPagingToolbar(store);
   	    var totalCountDisplayField,pageSizeCombo;
   	    pageSizeCombo = grid.down('#pageSizeCombo');
   	    totalCountDisplayField = grid.down('#totalCountDisplayField');
   	    if(totalCountDisplayField){
   	    	totalCountDisplayField.setVisible(true);
   	    }
   	    var this$=this;
		//grid.config.totalCount='';
   	    if(grid.down('#totalRecordCount')){
   	    	grid.down('#totalRecordCount').reset();
   	    }
		store.load({
			callback:function(records,response,success){
			//	if (!isNullOrEmpty(response.error) && !isNullOrEmpty(response.error.status) && response.error.status ==524 && !isNullOrEmpty(searchBtn)){
				if (response.error && !isNullOrEmpty(response.error.status) && response.error.status ==524){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICATION_SEARCH_ALERT'));
					searchBtn.setDisabled(false);
					return false;
				}
				
				try{
					var countPage = this$.down('pagingtoolbar').getPageData().pageCount;
				}
				catch(e){
					var countPage = 0;
				}
				if(this$.down('toolbar')!=undefined && this$.down('toolbar').query('#exportToPdfBtn')[0]!=undefined
						&& this$.down('toolbar').query('#exportToPdfBtn')[0]!=undefined){
					if(records.length>0){
						this$.down('toolbar').query('#exportToPdfBtn')[0].setDisabled(false);
						this$.down('toolbar').query('#exportToPdfBtn')[0].setDisabled(false);
						this$.down('toolbar').setDisabled(false);

					}else{
						this$.down('toolbar').query('#exportToPdfBtn')[0].setDisabled(true);
						this$.down('toolbar').query('#exportToPdfBtn')[0].setDisabled(true);
						this$.toggleCBGridSummaryRow(this$,false);
					}
				}
				if(searchBtn!=null && (searchCriteria.configCode=='APPLICATION_LIST' || searchCriteria.configCode=='PROGRAM_LIST' ||searchCriteria.configCode=='STUDENT_LIST' || searchCriteria.configCode=='USER_LIST' || searchCriteria.configCode=='FINAL_ADMISSION_LIST' || searchCriteria.configCode=='TRACK_ENQUIRY_ADMISSION' || searchCriteria.configCode=='CORPORATE_ENQUIRY_LIST' || searchCriteria.configCode=='TRACK_ENQUIRY_NON_ADMISSION' || searchCriteria.configCode=='CAMPAIGN_LIST' || searchCriteria.configCode=='STUDENT_TRACK_REQUEST' || searchCriteria.configCode=='TERMINATE_STUDENT_LIST' || searchCriteria.configCode=='RPT_STUDENT_KYS_DATA_REPORT' || searchCriteria.configCode=='RPT_STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT' || searchCriteria.configCode=='RPT_STUDENT_COMMUNITY_REPORT' || searchCriteria.configCode=='RPT_STUDENT_EMPLOYEE_CHILDREN_REPORT' || searchCriteria.configCode=='COURSE_LIST' || searchCriteria.configCode=='COURSE_GROUP_LIST' || searchCriteria.configCode=='COURSE_SPECIALIZATION' || searchCriteria.configCode=='STUDY_MATERIAL_DISTRIBUTION_REPORT' || searchCriteria.configCode=='PR_BATCH_CREATED_PROGRAM_WISE' || searchCriteria.configCode=='PR_PERIOD_ASSOCIATED' || searchCriteria.configCode=='PR_ASSOCIATED_EXAM_CENTER' || searchCriteria.configCode=='PR_SECTION_ASSOCIATED' || searchCriteria.configCode=='PR_SPECIALIZATION_AVAILABLE_BATCHWISE' || searchCriteria.configCode=='CR_COURSE_COMPONENT_ASSOCIATED' || searchCriteria.configCode=='CR_READING_MATERIAL_ASSOCIATED' || searchCriteria.configCode=='CR_COURSE_VARIANTS_ASSOCIATED' || searchCriteria.configCode=='CR_TOPIC_CREATED' || searchCriteria.configCode=='COURSE_EVALUATION' || searchCriteria.configCode=='SPECIALIZATION_STUDENT_RECORD_LIST')){
					searchBtn.setDisabled(false);
					Ext.getBody().unmask();
				}
				if(searchCriteria.configCode=='EVALUATION_GROUP_LISTING'){
					if(flag!='APPLICATION_REQUIRED'){
						var applicationField=false;
					Ext.each(records,function(record){
					flag=record.raw.APPLICATION_FLAG
					 if(applicationField==false && flag=='APPLICATION_REQUIRED'){
					 	applicationField=true;
				   }
				   });
					if(!applicationField){
						var GridCols = searchGridCol.getView().getGridColumns();
						Ext.each(GridCols,function(col){
							if(col.dataIndex == "APPLICATION_TILL_DATE" || col.dataIndex == "APPLICATION_SUBMISSION_START_DATE" ){
								var colInfo = searchColumnInArray(col.dataIndex, searchResultColumns);
								if(colInfo && !colInfo.visibility) {
									col.hide();
								}
							}
						});
					/*	searchGridCol.getView().getGridColumns()[4].hide();
						searchGridCol.getView().getGridColumns()[5].hide()
						*/
						/* searchResultColumns[5].visibility=false;
					     searchResultColumns[6].visibility=false;
						*///this$.configureColumns(searchResultColumns,store,extraColumns);
					}
				  
					}
				
				}
				if(searchCriteria.configCode=='STUDENT_TRACK_REQUEST'){		
					var GridCols = searchGridCol.getView().getGridColumns();
					
					var applicationField=false;
					for(var i =0 ; i< searchCriteria.searchCriterias.length; i++){
						if(applicationField==false && searchCriteria.searchCriterias[i].paramCode =='SERVICE_REQUEST_GROUP' ){
							applicationField=true;
							break;
						}

					}				
					if(applicationField){
						Ext.each(GridCols,function(col){
							if(col.dataIndex == "APPLICATION_FORM" ){
								col.show();
							}
							if(col.dataIndex == "APPROVER_LETTER" ){
								col.show();
							}
						});

					}else{
						Ext.each(GridCols,function(col){
							if(col.dataIndex == "APPLICATION_FORM" ){
								col.hide();
							}
							if(col.dataIndex == "APPROVER_LETTER" ){
								col.hide();
							}
						});

					}
				}
				if(records.length==0 && countPage==1){
					this$.removePagingToolbar();
				}
				var tooltip,pageSizeCombo = grid.down('#pageSizeCombo');
				if(totalCountDisplayField && pageSizeCombo){
					//pageSizeCombo.setDisabled(true);
					if(pageSizeCombo.getValue()<= grid.store.getTotalCount()){
						totalCountDisplayField.setValue('<a href="" target="_blank" style="font-size: 15px; !important;color:#1258BB;text-decoration: none;border-bottom: 1px solid #1258BB;">many</a>)');
						
						/*tooltip code start here*/
						/*Ext.defer(function() {
							    tooltip = Ext.create('Ext.tip.ToolTip', {
							    target: totalCountDisplayField.getEl(),
							    html: 'see the total number of records', 
							    dismissDelay: 0, 
							    showDelay: 100, 
							    hideDelay: 100,
							    trackMouse: true,
							    minWidth: 220, 
							    listeners: {
							        beforeshow: function() {
							            if (totalCountDisplayField.getValue().indexOf('<a href=""') !== -1) {
							                return true; // Tooltip will be shown only if the hyperlink is present
							            } else {
							                return false; // Otherwise, don't show the tooltip
							            }
							        }
							    }
							});
				    	}, 1000, this);
						totalCountDisplayField.getEl().on('click', function() {
						    tooltip.destroy(); // Destroy the tooltip after the link is clicked
						});*/
						/*tooltip code end here*/
						
						grid.down('#nextButtonPaging') && grid.down('#nextButtonPaging').setDisabled(true);
	        			grid.down('#lastButton') && grid.down('#lastButton').setDisabled(true);
					}else{
						totalCountDisplayField.setValue(grid.store.getTotalCount()+')');
					}
				}
				
				//this$.setHeight(this$.getHeight()+16);
				if(!Ext.getCmp(grid.id+'Button') && grid.isGridConfigurable){
					var headerCt = grid.headerCt;
	                var headerEl = headerCt.el;

	                // Create a wrapper div *inside* the headerCt
	                var btnWrap = Ext.DomHelper.append(headerEl, {
	                    tag: 'div',
	                    cls: 'header-action-btn-wrap',
	                    style: 'position: absolute; top: 0; right: -3px; z-index: 5; height: 28px;'
	                }, true);
	                if(!isNullOrEmpty(grid.itemId) && (grid.itemId == 'coursemastergrid' ||grid.itemId == 'programmastergrid')){
	                	var columns = grid.columnManager.columns;

		                if (columns && columns.length > 0) {
		                    var lastColumn = columns[columns.length - 1];
		                    lastColumn.setWidth(400); // set required width
		                }
	                }
	                // Create button inside that wrapper
	                var addBtn = Ext.create('Ext.Button', {
	                    //text: '+',
	                    iconCls:'ph ph-columns-plus-right',
	                    renderTo: btnWrap,
	                    cls:'columnBtnCls',
	                    width: 36,
	                    height: 40,
	                    id:grid.id+'Button',
	                    listeners: {
	                        afterrender: function(btn) {
	                            Ext.create('Ext.tip.ToolTip', {
	                                target: btn.getEl(),
	                                title: getCommonTranslation('ADD_COLUMNS'),
	                                html: getCommonTranslation('ADD_MORE_COLUMNS'),
	                                // optional configs
	                                anchor: 'top',
	                                trackMouse: true,
	                                width:250,
	                                cls: 'column-btn-cls'
	                            });
	                        }
	                    },
	                    style: 'margin-top: 2px;',
	                    handler: function (btn) {
	                    	var btn =grid.getHeader().items.items[1];
	                    	if(btn && btn.text != "Columns"){
	                    		btn =grid.getHeader().items.items[2];
	                    	}
	                    	createColumnWindow(btn.gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,null,btn.gridNamePath);
	                    }
	                });

	                // Sync horizontal scroll so button stays in visible header zone
	                grid.view.el.on('scroll', function () {
	                    var scrollLeft = grid.view.el.dom.scrollLeft;
	                    btnWrap.setStyle('right', (-3 - scrollLeft) + 'px');
	                });
				}
				
			}
		});
		this.configureColumns(searchResultColumns,store,extraColumns);
		/*console.log(store.getRange());
		if(store.getRange().length>0){
 			var view = this$.getView();
      		view.getFeature(0).toggleSummaryRow(true);
      		view.refresh();	
 		}*/
	},
	
	configureColumns: function(columnModels, store,extraColumns) {
		var this$=this;
        this.getSelectionModel().deselectAll(true);
        var columns = [];
        /**
         * @author Akshay.Kalbhor
         * added checks for status and weatherinternal , for translation of the displayed values to internal/external and active/inactive.
         * Bug Id : [#33622 & 33621]
         */
        var alinfomodel = Academia.model.authentication.ALInfoModel;
   	    var wheatherSchool = alinfomodel.get('wheatherSchool');
        Ext.each(columnModels, function(columnModel) {
        	
        	if(columnModel.name == 'ADMISSION_COMMITMENT_FEE_STATUS' && columnModel.visibility==true){
        		columns.push(Ext.create('Ext.grid.column.Column', {
        			text:this$.getFieldLabel(columnModel),
        			dataIndex: columnModel.name,
        			data:columnModel.defaultValue,
        			tooltip : this$.getFieldLabel(columnModel),
        			sortable:columnModel.defaultValue.sortable,
        			renderer:function(value) {
        				if(!isNullOrEmpty(value)){
        					if(value == 'FULLY_PENDING'){
        						return getCommonTranslation('FULLY_PENDING');
        					}else if(value =='SETTLED'){
        						return getCommonTranslation('SETTLED');
        					}else{
        						return value
        					}
        				}
        			},
        			flex:0.4
        		}));
			}else if(columnModel.name == 'APPLICATION_IDENTIFIER' && columnModel.visibility==true){
        		columns.push(Ext.create('Ext.grid.column.Column', {
        			text:this$.getFieldLabel(columnModel),
        			dataIndex: columnModel.name,
        			data:columnModel.defaultValue,
        			tooltip : this$.getFieldLabel(columnModel),
        			sortable:columnModel.defaultValue.sortable,
        			renderer:function(value) {
        				if(!isNullOrEmpty(value)){
        					if(value == 'SIGNUP'){
        						return getCommonTranslation('SIGNUP');
        					}else{
        						return value
        					}
        				}
        			},
        			flex:0.4
        		}));
			}else if (columnModel.name == 'DOCUMENT_TYPE') {
				columns.push(Ext.create('Ext.grid.column.Column', {
					text: this$.getFieldLabel(columnModel),
					dataIndex: columnModel.name,
					data: columnModel.defaultValue,
					tooltip: this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
					// menuDisabled : true,
					sortable: columnModel.defaultValue.sortable,
					renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
						if (record.data.DOCUMENT_TYPE != null) {
							return record.data.DOCUMENT_TYPE;
						} else {
							return record.data.DOCUMENT_NAME;
						}
					},
					flex: 0.4
				}));
			} else if (columnModel.name == 'DOCUMENT_NAME') {
				columns.push(Ext.create('Ext.grid.column.Column', {
					text: this$.getFieldLabel(columnModel),
					dataIndex: columnModel.name,
					data: columnModel.defaultValue,
					tooltip: this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
					// menuDisabled : true,
					sortable: columnModel.defaultValue.sortable,
					renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
						if (record.data.DOCUMENT_NAME != null) {
							return record.data.DOCUMENT_NAME;
						} else {
							return record.data.DOCUMENT_TYPE;
						}
					},
					flex: 0.4
				}));
			}
        	else if(columnModel.name == 'DISCOUNT_AMOUNT' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                	if(!isNullOrEmpty(val)){
	                		return Ext.util.Format.number(val,'0,0.00');
	                	}
	                },
	                flex:0.4
	            }));
	        }
			else if(columnModel.name == 'BALANCE_AMOUNT' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                	if(!isNullOrEmpty(val)){
	                		return Ext.util.Format.number(val,'0,0.00');
	                	}
	                },
	                flex:0.4
	            }));
	        }
			else if(columnModel.name == 'BILLABLE_AMOUNT' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                	if(!isNullOrEmpty(val)){
	                		return Ext.util.Format.number(val,'0,0.00');
	                	}
	                },
	                flex:0.4
	            }));
	        }
        	 else if(columnModel.name == 'PERSON_IMAGE') {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                //menuDisabled : true,
     				hidden:true,
 	                sortable:columnModel.defaultValue.sortable,
 	                flex:0.4,
 	                width:200,
 	                renderer: function(value, metaData) {
 	                	metaData.tdAttr = 'type="gridImageCell"';
	                	 if(!isNullOrEmpty(value) && value !=0){
	                		 var extensionArr = value.split(".");
	                		 var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
	                		 value='<img src="'+imageUrl+'?'+ Date.now()+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px;">';
	                		 return value;
	                	 }else{
	                		 var imageUrl=generateInitialsImage(
		 	 	                		metaData.record.raw.FIRST_NAME,
		 	 	                		metaData.record.raw.MIDDLE_NAME,
		 	 	                		metaData.record.raw.LAST_NAME
		 	 	                	);
	                		 value = '<div class="containerBox">'
	 	                			+ '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
	 	                			+'<img style="border-radius: 100px;" src="'+imageUrl+'?'+ Date.now()+'" height="40" width="40" alt="Round Image">'
	 	                			+'</div>'
	 	                			+ '</div>'
	                		 return value;
	                	}
 	                	
 	                }
 	            }));
 	          }else if(columnModel.name == 'STUDENT_NAME' && this$.cbViewCode == 'STUDENT_LIST') {
 	 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	 	            	text:this$.getFieldLabel(columnModel),
 	 	                dataIndex: columnModel.name,
 	 	                data:columnModel.defaultValue,
 	 	                tooltip : this$.getFieldLabel(columnModel),
 	 	                //menuDisabled : true,
 	 	                width:200,
 	     				sortable:columnModel.defaultValue.sortable,
 	 	                renderer: function(value, metaData) {
 	 	                	 metaData.tdAttr = 'type="gridImageCell"';
 	 	                	var img = metaData.record.get('PERSON_IMAGE');
 	 	                	if(!isNullOrEmpty(img) && img){
 	 	                		if(img.indexOf('https:') !== -1){
 	 	                			value = '<div class="containerBox avtar-hoverAnimation">'
 	 	                				+ '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
 	 	                				+'<img style="border-radius: 100px;" src="' + img + '?' + Date.now() + '" ' +
 	 	                				'onerror="this.onerror=null; this.src=generateInitialsImage(\'' +
 	 	                				metaData.record.raw.FIRST_NAME + '\', \'' +
 	 	                				metaData.record.raw.MIDDLE_NAME + '\', \'' +
 	 	                				metaData.record.raw.LAST_NAME + '\');" ' +
 	 	                				'height="40" width="40" alt="Round Image">'
 	 	                				+'</div>'
 	 	                				+'<div class="student-name" style="display: inline-block; vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	                				+ '</div>'
 	 	                				return value;
 	 	                		}else{
 	 	                			var extensionArr = img.split(".");
 	 	                			var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"."+extensionArr[extensionArr.length - 1];
 	 	                			value = '<div class="containerBox avtar-hoverAnimation">'
 	 	                				+ '<div class="avtar-containerBox" style="vertical-align: middle;">'
 	 	                				+'<img style="border-radius: 100px;" src="' + imageUrl + '?' + Date.now() + '" ' +
 	 	                				'onerror="this.onerror=null; this.src=generateInitialsImage(\'' +
 	 	                				metaData.record.raw.FIRST_NAME + '\', \'' +
 	 	                				metaData.record.raw.MIDDLE_NAME + '\', \'' +
 	 	                				metaData.record.raw.LAST_NAME + '\');" ' +
 	 	                				'height="40" width="40" alt="Round Image">'
 	 	                				+'</div>'
 	 	                				+'<div class="student-name" style="vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	                				+ '</div>'	
 	 	                				return value;
 	 	                		}

 	 	                	}else{
 	 	                		var imageUrl = generateInitialsImage(
	 	 	                		metaData.record.raw.FIRST_NAME,
	 	 	                		metaData.record.raw.MIDDLE_NAME,
	 	 	                		metaData.record.raw.LAST_NAME
	 	 	                	);

 	 	                		value = '<div class="containerBox avtar-hoverAnimation">'
 	 	                			+ '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
 	 	                			+'<img style="border-radius: 100px;" src="'+imageUrl+'" height="40" width="40" alt="Round Image">'
 	 	                			+'</div>'
 	 	                			+'<div class="student-name" style="display: inline-block; vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	                			+ '</div>'
 	 	                			return value;
 	 	                	}

 	 	                }
 	 	            }));
 	 	          }else if(columnModel.name == 'FULL_NAME' && (this$.cbViewCode == 'UserList' || this$.cbViewCode == 'FACULTY_LIST' || this$.cbViewCode == 'APPLICATION_LIST')) {
 	 	 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	 	 	            	text:this$.getFieldLabel(columnModel),
 	 	 	                dataIndex: columnModel.name,
 	 	 	                data:columnModel.defaultValue,
 	 	 	                tooltip : this$.getFieldLabel(columnModel),
 	 	 	                //menuDisabled : true,
 	 	 	                width:200,
 	 	     				sortable:columnModel.defaultValue.sortable,
 	 	 	                renderer: function(value, metaData) {
 	 	 	                	 metaData.tdAttr = 'type="gridImageCell"';
 	 	 	                	var img = metaData.record.raw.PERSON_IMAGE;
 	 	 	                	if(!isNullOrEmpty(img) && img){
 	 	 	                		if(img.indexOf('https:') !== -1){
 	 	 	                			value = '<div class="containerBox avtar-hoverAnimation">'
 	 	 	                				+ '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
 	 	 	                				+'<img style="border-radius: 100px;" src="' + img + '?' + Date.now() + '" ' +
 	 	 	                				'onerror="this.onerror=null; this.src=generateInitialsImage(\'' +
 	 	 	                				metaData.record.raw.FIRST_NAME + '\', \'' +
 	 	 	                				metaData.record.raw.MIDDLE_NAME + '\', \'' +
 	 	 	                				metaData.record.raw.LAST_NAME + '\');" ' +
 	 	 	                				'height="40" width="40" alt="Round Image">'
 	 	 	                				+'</div>'
 	 	 	                				+'<div class="student-name" style="display: inline-block; vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	 	                				+ '</div>'
 	 	 	                				return value;
 	 	 	                		}else{
 	 	 	                			var extensionArr = img.split(".");
 	 	 	                			var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"."+extensionArr[extensionArr.length - 1];
 	 	 	                			value = '<div class="containerBox avtar-hoverAnimation">'
 	 	 	                				+ '<div class="avtar-containerBox" style="vertical-align: middle;">'
 	 	 	                				+'<img style="border-radius: 100px;" src="' + imageUrl + '?' + Date.now() + '" ' +
 	 	 	                				'onerror="this.onerror=null; this.src=generateInitialsImage(\'' +
 	 	 	                				metaData.record.raw.FIRST_NAME + '\', \'' +
 	 	 	                				metaData.record.raw.MIDDLE_NAME + '\', \'' +
 	 	 	                				metaData.record.raw.LAST_NAME + '\');" ' +
 	 	 	                				'height="40" width="40" alt="Round Image">'
 	 	 	                				+'</div>'
 	 	 	                				+'<div class="student-name" style="vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	 	                				+ '</div>'	
 	 	 	                				return value;
 	 	 	                		}

 	 	 	                	}else{
 	 	 	                		
// 	 	 	                		var parts = metaData.record.data.FULL_NAME.trim().split(/\s+/); // Split by spaces
 	 	 	                	    var firstName = metaData.record.raw.FIRST_NAME;
 	 	 	                	    var middleName = metaData.record.raw.MIDDLE_NAME;
 	 	 	                	    var lastName = metaData.record.raw.LAST_NAME; // Join remaining parts as last name
 	 	 	                	    
 	 	 	                		var imageUrl = generateInitialsImage(
 	 	 	                				firstName,
 	 	 	                				middleName,
 	 	 	                				lastName
 	 		 	 	                	);
 	 	 	                		//var imageUrl="resources/images/Avatar_place_holder.svg";

 	 	 	                		value = '<div class="containerBox avtar-hoverAnimation">'
 	 	 	                			+ '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
 	 	 	                			+'<img style="border-radius: 100px;" src="'+imageUrl+'" height="40" width="40" alt="Round Image">'
 	 	 	                			+'</div>'
 	 	 	                			+'<div class="student-name" style="display: inline-block; vertical-align: middle; width: 150px;"> '+value+'</div>'
 	 	 	                			+ '</div>'
 	 	 	                			return value;
 	 	 	                	}

 	 	 	                }
 	 	 	            }));
 	 	 	          }else if(columnModel.name == 'EMPLOYEE_TYPE' && (this$.cbViewCode == 'FACULTY_LIST')) {
	 	        	columns.push(Ext.create('Ext.grid.column.Column', {
	 	          			text:this$.getFieldLabel(columnModel),
	 	          			dataIndex: columnModel.name,
	 	          			data:columnModel.defaultValue,
	 	          			tooltip : this$.getFieldLabel(columnModel),
	 	          			sortable:columnModel.defaultValue.sortable,
	 	          			renderer:function(value) {
	 	          				if(!isNullOrEmpty(value)){
	 	          					if(value.toUpperCase() == 'FULL_TIME'){
	 	          						return getCommonTranslation('FULL_TIME');
	 	          					}else if(value.toUpperCase() == 'PART_TIME'){
	 	          						return getCommonTranslation('PART_TIME');
	 	          					}else if(value.toUpperCase() =='PROBATION'){
	 	          						return getCommonTranslation('PROBATION');
	 	          					}else{
	 	          						return value
	 	          					}
	 	          				}
	 	          			},
	 	          			flex:0.4
	 	          		}));
	 	 	    }else if(columnModel.name == 'FOLLOW_UP_REMARKS' && columnModel.visibility==true) {
 	        		        	columns.push(Ext.create('Ext.grid.column.Column', {
 	        			            	text:this$.getFieldLabel(columnModel),
 	        			                dataIndex: columnModel.name,
 	        			                data:columnModel.defaultValue,
 	        			                tooltip : this$.getFieldLabel(columnModel),
 	        			                sortable:columnModel.defaultValue.sortable,
 	        			         	    renderer:function(val,rec){
 	        			        	    	if(!isNullOrEmpty(val)){
 	        			        	    		rec.tdAttr = 'data-qtip="' + val + '"';
 	        			        	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 55px;min-width: 16ch;max-width: 17ch;';
 	        			        	    		return val;
 	        			        	    	}
 	        			        	    },
 	        			                flex:0.4
 	        			            }));
 	        			        }
 	 	          	else if(columnModel.name == 'REQUEST_BY' && columnModel.visibility==true ){
 	 	          		
 	 	          		columns.push(Ext.create('Ext.grid.column.Column', {
 	 	          			text:this$.getFieldLabel(columnModel),
 	 	          			dataIndex: columnModel.name,
 	 	          			data:columnModel.defaultValue,
 	 	          			tooltip : this$.getFieldLabel(columnModel),
 	 	          			sortable:columnModel.defaultValue.sortable,
 	 	          			renderer:function(value) {
 	 	          				if(!isNullOrEmpty(value)){
 	 	          					if(value.toUpperCase() == 'STUDENT'){
 	 	          						return getServiceRequestTranslation('STUDENT');
 	 	          					}else if(value.toUpperCase() == 'FACULTY'){
 	 	          						return getServiceRequestTranslation('FACULTY');
 	 	          					}else if(value.toUpperCase() =='PARENTS'){
 	 	          						return getServiceRequestTranslation('PARENT');
 	 	          					}
 	 	          					else if(value.toUpperCase() =='STAFF'){
 	 	          						return getServiceRequestTranslation('STAFF');
 	 	          					}
 	 	          					else if(value.toUpperCase() == 'ACADEMIC_ADMINISTRATOR'){
 	 	          						return getServiceRequestTranslation('ACADEMIC_ADMINISTRATOR');
 	 	          					}else{
 	 	          						return value
 	 	          					}
 	 	          				}
 	 	          			},
 	 	          			flex:0.4
 	 	          		}));

 	 	          	} 
             else if(columnModel.name == 'REASON_FOR_REQUEST' && columnModel.visibility==true) {
            	 columns.push(Ext.create('Ext.grid.column.Column', {
            		 text:this$.getFieldLabel(columnModel),
            		 dataIndex: columnModel.name,
            		 data:columnModel.defaultValue,
            		 tooltip : this$.getFieldLabel(columnModel),
            		 renderer: function(value) {
            			 if (value && value.length > 100) { 
            				 return '<div style="height: 3em; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" data-qtip="' + value + '">' + value.substring(0, 100) + '...</div>';
            			 }
            			 return value;
            		 }

            	 }));
             } 
	        else if(columnModel.name == 'REQUEST_ASSIGNED_TO' && columnModel.visibility==true){
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer:function(value) {
	                	if(!isNullOrEmpty(value)){
	                		return value;
	                	}else{
	                		return 'Auto';
	                	}
	        		},
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'COMMENT' && columnModel.visibility==true) {
	        
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	         	    renderer:function(val,rec){
	        	    	if(!isNullOrEmpty(val)){
	        	    		rec.tdAttr = 'data-qtip="' + val + '"';
	        	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 30px;max-height: 103px;';
	        	    		return val;
	        	    	}
	        	    },
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'USER_GROUP_NAME'){
 	        	if(columnModel.visibility==true) {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		if(value.toUpperCase() == 'FACULTY'){
 		        				return getCommonTranslation('FACULTY');
 		        			}else if(value.toUpperCase() =='OTHER_EMPLOYEE'){
 		        				return getCommonTranslation('OTHER_EMPLOYEE');
 		        			}else{
 		        				return value
 		        			}
 	                	}
 	        		},
 	                flex:0.4
 	            }));
 	        	} else {
 	 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	 	            	text:this$.getFieldLabel(columnModel),
 	 	                dataIndex: columnModel.name,
 	 	                data:columnModel.defaultValue,
 	 	                tooltip : this$.getFieldLabel(columnModel),
 	 	                sortable:columnModel.defaultValue.sortable,
 	 	                hidden:true,
 	 	                renderer:function(value) {
 	 	                	if(!isNullOrEmpty(value)){
 	 	                		if(value.toUpperCase() == 'FACULTY'){
 	 		        				return getCommonTranslation('FACULTY');
 	 		        			}else if(value.toUpperCase() =='OTHER_EMPLOYEE'){
 	 		        				return getCommonTranslation('OTHER_EMPLOYEE');
 	 		        			}else{
 	 		        				return value
 	 		        			}
 	 	                	}
 	 	        		},
 	 	                flex:0.4
 	 	            } 
 	            ));}
 	        	
 	        }else if(columnModel.name == 'RELATIVE_BLOOD_GROUP'){
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		     if(value == 'O_PLUS'){
		        				return getCommonTranslation('O_PLUS');
		        			}else if(value =='O_MINUS'){
		        				return getCommonTranslation('O_MINUS');
		        			}else if(value =='A_PLUS'){
		        				return getCommonTranslation('A_PLUS');
		        			}else if(value =='A_MINUS'){
		        				return getCommonTranslation('A_MINUS');
		        			}else if(value =='B_PLUS'){
		        				return getCommonTranslation('B_PLUS');
		        			}else if(value =='B_MINUS'){
		        				return getCommonTranslation('B_MINUS');
		        			}else if(value =='AB_PLUS'){
		        				return getCommonTranslation('AB_PLUS');
		        			}else if(value =='AB_MINUS'){
		        				return getCommonTranslation('AB_MINUS');
		        			}else{
		        				return value
		        			}
 	                	}
 	        		},
 	                flex:0.4
 	            }));
 	        }else if(columnModel.name == 'RELATIONSHIP'){
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		     if(value == 'FATHER'){
		        				return getPersonModuleTranslation('FATHER');
		        			}else if(value =='MOTHER'){
		        				return getPersonModuleTranslation('MOTHER');
		        			}else if(value =='SPOUSE'){
		        				return getPersonModuleTranslation('SPOUSE');
		        			}else if(value =='CHILD'){
		        				return getPersonModuleTranslation('CHILD');
		        			}else{
		        				return value
		        			}
 	                	}
 	        		},
 	                flex:0.4
 	            }));
 	        }else if(columnModel.name == 'STATUS_URAR'){
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	        		header:  getCommonTranslation("STATUS"),
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                /*renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		     if(value == true){
		        				return "Active";
		        			}else if(value == false){
		        				return "Inactive";
		        			}
 	        }else if(columnModel.name == 'STATUS_URAR'){
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	        		header:  getCommonTranslation("STATUS"),
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                /*renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		     if(value == true){
		        				return "Active";
		        			}else if(value == false){
		        				return "Inactive";
		        			}
 	                	}
 	        		},
 	                flex:0.4
 	            }));
 	        }else if(columnModel.name == 'PRIMARY_EMAIL_ID'){
 	        	if(columnModel.visibility==true) {
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}else{
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			hidden:true,
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}
 	                	}
 	        		},*/
 	                flex:0.4
 	            })); 
 	            
 	        }else if(columnModel.name == 'PRIMARY_EMAIL_ID'){
 	        	if(columnModel.visibility==true) {
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}else{
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			hidden:true,
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}}else if(columnModel.name == 'STATUS_URAR'){
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	        		header:  getCommonTranslation("STATUS"),
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
 	                sortable:columnModel.defaultValue.sortable,
 	                /*renderer:function(value) {
 	                	if(!isNullOrEmpty(value)){
 	                		     if(value == true){
		        				return "Active";
		        			}else if(value == false){
		        				return "Inactive";
		        			}
 	                	}
 	        		},*/
 	                flex:0.4
 	            }));
 	        }else if(columnModel.name == 'PRIMARY_EMAIL_ID'){
 	        	if(columnModel.visibility==true) {
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}else{
 	        		columns.push(Ext.create('Ext.grid.column.Column', {
 	        			header:  getCommonTranslation('EMAIL'),
 	        			hidden:true,
 	        			text:this$.getFieldLabel(columnModel),
 	        			dataIndex: columnModel.name,
 	        			data:columnModel.defaultValue,
 	        			tooltip : this$.getFieldLabel(columnModel),
 	        			sortable:columnModel.defaultValue.sortable,
 	        			flex:0.4
 	        		}));
 	        	}
 	        	 
 	        }
        	else if(columnModel.name == 'EVENT_BANNER_URL') {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
 	            	text:this$.getFieldLabel(columnModel),
 	                dataIndex: columnModel.name,
 	                data:columnModel.defaultValue,
 	                tooltip : this$.getFieldLabel(columnModel),
     				hidden:true,
 	                sortable:columnModel.defaultValue.sortable,
 	                flex:0.4,
 	                renderer: function(value, metaData) {
 	                	 metaData.tdAttr = 'type="gridImageCell"';
 	                	if(!isNullOrEmpty(value) && value !=0){
	 	                	var imageUrl="resources/images/uploads/"+value;
	 	                	value='<img src="'+imageUrl+'" height="32" width="32" style="margin-top:-10px; margin-bottom:-10px;">';
	 	                    return value;
 	                	}else{
 	                		var imageUrl="resources/images/Event_Banner.png";
 	                		value='<img src="'+imageUrl+'" height="32" width="32" style="margin-top:-10px; margin-bottom:-10px">';
 	                		 return value;
 	                	}
 	                	
 	                }
 	            }));
 	        } else if(columnModel.name == 'MODE_OF_EMPLOYMENT' && columnModel.visibility==true) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                //hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer : function(value){
	                	var msg = "";
	                	if(value == 'FULL_TIME'){
	                		msg = getPersonModuleTranslation('FULL_TIME');
	                	}else if(value == 'PART_TIME'){
	                		msg = getPersonModuleTranslation('PART_TIME');
	                	}else if(value == 'PROJECT_WORK'){
	                		msg = getPersonModuleTranslation('PROJECT_WORK');
	                	}else if(value == 'ON_CONTRACT'){
	                        msg = getPersonModuleTranslation('ON_CONTRACT');
	                    }
	                	
	                	return msg;
	                },
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'APPLICANT_TYPE' && columnModel.visibility==true) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                //hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer : function(value){
	                	var msg = "";
	                	if(value == null){
	                		msg = "New Student Application";
	                	}
	                	else
	                		{
	                		msg=value;
	                		}
	                	return msg;
	                },
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'EXISTING_STUDENT_NUMBER' && columnModel.visibility==true) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                //hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer : function(value){
	                	var msg = "";
	                	if(value == null){
	                		msg = "-";
	                	}else
	                		{
	                		msg=value;
	                		}
	                	return msg;
	                },
	                flex:0.4
	            }));
	        }else if(wheatherSchool && columnModel.whetherSchool && columnModel.name != 'WHETHER_INTERNAL' && columnModel.name != 'WHETHER_ATTENDANCE_MARKED' &&/*columnModel.name != 'STATUS' &&*/ columnModel.name != 'id' 
	        	&& columnModel.name != 'ID' && columnModel.name != 'LOCKED_REASON' &&  columnModel.visibility!=false && columnModel.name!='APPLICATION_SUBMISSION_START_DATE'&& columnModel.name!='APPLICATION_TILL_DATE'){
 	        	if(columnModel.whetherTotalAmount) {

 	        		if(columnModel.originalIndex != 0) {
 	        			columns.push(Ext.create('Ext.grid.column.Column', {
 	        				text:this$.getFieldLabel(columnModel),
 	        				dataIndex: columnModel.name,
 	        				data:columnModel.defaultValue,
 	        				hidden:true,
 	        				tooltip : this$.getFieldLabel(columnModel),
 	        				sortable:columnModel.defaultValue.sortable,
 	        				flex:0.4,
 	        				summaryType: 'sum',
 	        				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
 	        					return  value;
 	        				}
 	        			}));
 	        		}else {
 	        			columns.push(Ext.create('Ext.grid.column.Column', {
 	        				text:this$.getFieldLabel(columnModel),
 	        				dataIndex: columnModel.name,
 	        				data:columnModel.defaultValue,
 	        				hidden:true,
 	        				tooltip : this$.getFieldLabel(columnModel),
 	        				sortable:columnModel.defaultValue.sortable,
 	        				flex:0.4,
 	        				summaryRenderer: function(value, summaryData, dataIndex) {
 	        					return getFeeAndPaymentCommonTranslation('TOTAL');
 	        				}
 	        			}));
 	        		}
 	        	} else {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel), //+ getCommonTranslation('DRAGANDDROPTEXT'),
	                //menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                flex:0.4,
	                renderer: function(value) {
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0) {
		                	   value="<a href='#'>"+value+"</a>";
	                	} else if(columnModel.whetherColorFormat) {
		                	value = this.getValueInColor(value);
	                	}
	                    return value;
	                }
	            }));
	        } 
 	        } else if(columnModel.name != 'WHETHER_INTERNAL' && columnModel.name != 'WHETHER_ATTENDANCE_MARKED' &&/*columnModel.name != 'STATUS' &&*/ columnModel.name != 'id' 
	        	&& columnModel.name != 'ID' && columnModel.name != 'LOCKED_REASON' &&  columnModel.visibility!=false && columnModel.name != 'OFFER_LETTER_ACCEPTANCE_DATE' && columnModel.name!='APPLICATION_SUBMISSION_START_DATE'&& columnModel.name!='APPLICATION_TILL_DATE') {
 	        	if(columnModel.whetherTotalAmount) {

 	        		if(columnModel.originalIndex != 0) {
 	        			columns.push(Ext.create('Ext.grid.column.Column', {
 	        				text:this$.getFieldLabel(columnModel),
 	        				dataIndex: columnModel.name,
 	        				data:columnModel.defaultValue,
 	        				tooltip : this$.getFieldLabel(columnModel),
 	        				sortable:columnModel.defaultValue.sortable,
 	        				flex:0.4,
 	        				summaryType: 'sum',
 	        				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
 	        					return  value;
 	        				}
 	        			}));
 	        		}else {
 	        			columns.push(Ext.create('Ext.grid.column.Column', {
 	        				text:this$.getFieldLabel(columnModel),
 	        				dataIndex: columnModel.name,
 	        				data:columnModel.defaultValue,
 	        				tooltip : this$.getFieldLabel(columnModel),
 	        				sortable:columnModel.defaultValue.sortable,
 	        				flex:0.4,
 	        				summaryRenderer: function(value, summaryData, dataIndex) {
 	        					return getFeeAndPaymentCommonTranslation('TOTAL');
 	        				}
 	        			}));
 	        		}
 	        	} else {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel), //+ getCommonTranslation('DRAGANDDROPTEXT'),
	                //menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                flex:0.4,
	                renderer: function(value) {
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0) {
		                	   value="<a href='#'>"+value+"</a>";
	                	} else if(columnModel.name=="STATUS" && (value == Ext.util.Format.capitalize('RE - I + E') || value == Ext.util.Format.capitalize('RE - E') || value == Ext.util.Format.capitalize('RE - I'))){
	                		return value.toUpperCase();
	                	} else if(columnModel.whetherColorFormat) {
		                	value = this.getValueInColor(value);
	                	}
	                    return value;
	                }
	            }));
	        } } /*else if(columnModel.name == 'STATUS' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel) + getCommonTranslation('DRAGANDDROPTEXT'),
	                //menuDisabled : true,
	                sortable:true,
	                  renderer:activeInactiveRenderer,
	                renderer:function(value) {
	                	if(columnModel.whetherHyperlink)
	                	   value="<a href='#'>"+value+"</a>";
	                    return value;
	                },
	                flex:0.4
	            }));
	            
	        }*/ else if(columnModel.name == 'WHETHER_ATTENDANCE_MARKED' && columnModel.name != 'LOCKED_REASON' && columnModel.visibility!=false && wheatherSchool && columnModel.whetherSchool) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(value == 'Yes'){
	        				return "<span style=\'color:green\'>Yes</span>";
	        			} else {
	        				return "<span style=\'color:red\'>No</span>";
	        			}
	                },
	                flex:0.4
	            }));
	        } else if(columnModel.name == 'WHETHER_ATTENDANCE_MARKED' && columnModel.visibility!=false && columnModel.name != 'LOCKED_REASON') {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(value == 'Yes'){
	        				return "<span style=\'color:green\'>Yes</span>";
	        			} else {
	        				return "<span style=\'color:red\'>No</span>";
	        			}
	                },
	                flex:0.4
	            }));
	        } else if(columnModel.visibility==false && columnModel.name!='APPLICATION_TILL_DATE' && columnModel.name!='APPLICATION_SUBMISSION_START_DATE'&& columnModel.defaultValue.dataType!='IDENTITY'&& columnModel.defaultValue.dataType!='REF_IDENTITY' && wheatherSchool && columnModel.whetherSchool && columnModel.name != 'LOCKED_REASON' && columnModel.name!='APPLICATION_GRID_COMMENTS' && columnModel.name!='OFFER_LETTER_ACCEPTANCE_DATE') {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0) {
		                	   value="<a href='#'>"+value+"</a>";
	                	} 
	                	if(columnModel.whetherColorFormat) {
		                	value = this.getValueInColor(value);
	                	}
	                	return value;
	                },
	                flex:0.4
	            }));
	        }
	        else if( columnModel.defaultValue.dataType!='IDENTITY'&& columnModel.name!='APPLICATION_SUBMISSION_START_DATE' && columnModel.name!='APPLICATION_TILL_DATE' && columnModel.defaultValue.dataType!='REF_IDENTITY' && columnModel.name != 'LOCKED_REASON'&& columnModel.name!='APPLICATION_GRID_COMMENTS' && columnModel.name!='OFFER_LETTER_ACCEPTANCE_DATE') {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0) {
		                	   value="<a href='#'>"+value+"</a>";
	                	} 
	                	if(columnModel.whetherColorFormat) {
		                	value = this.getValueInColor(value);
	                	}
	                	return value;
	                },
	                flex:0.4
	            }));
	        }else if(columnModel.name=='APPLICATION_SUBMISSION_START_DATE' || columnModel.name=='APPLICATION_TILL_DATE'){
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),	               
	                sortable:columnModel.defaultValue.sortable,	               
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'WHETHER_INTERNAL' && columnModel.visibility!=false && wheatherSchool && columnModel.whetherSchool && columnModel.name != 'LOCKED_REASON') {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0)
		                	   value="<a href='#'>"+value+"</a>";
	                	if(value) {
	                		return getCommonTranslation('INTERNAL');
	                	} else {
	                		return getCommonTranslation('EXTERNAL');
	                	}
	                },
	                flex:0.4
	            }));
	        } else if(columnModel.name == 'WHETHER_INTERNAL' && columnModel.name != 'LOCKED_REASON' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0)
		                	   value="<a href='#'>"+value+"</a>";
	                	if(value) {
	                		return getCommonTranslation('INTERNAL');
	                	} else {
	                		return getCommonTranslation('EXTERNAL');
	                	}
	                },
	                flex:0.4
	            }));
	        } else if(columnModel.name == 'LOCKED_REASON' && columnModel.visibility!=false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                tooltip : this$.getFieldLabel(columnModel),// + getCommonTranslation('DRAGANDDROPTEXT'),
	               // menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                renderer: function(value) { 
	                	if(value == 'locked_for_wrong_password_attempt') {
	                		return "Locked for wrong password attempt";
	                	} else {
	                		return value;
	                	}
	                },
	                flex:0.4
	            }));
			} else if(columnModel.name == 'APPLICATION_GRID_COMMENTS' && columnModel.visibility==false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	         	    renderer:function(val,rec){
	        	    	if(!isNullOrEmpty(val)){
	        	    		rec.tdAttr = 'data-qtip="' + val + '"';
	        	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 5;-webkit-box-orient: vertical;line-height: 18px;max-height: 103px;';
	        	    		return val;
	        	    	}
	        	    },
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'MODE_OF_ENQUIRY' && columnModel.visibility==false) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                	if(!isNullOrEmpty(val)){
	                		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	                		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 70px;min-width: 8ch;max-width: 16ch;';
	                		return val;	
	                	}
	                },
	                flex:0.4
	            }));
	        }else if(columnModel.name == 'OFFER_LETTER_ACCEPTANCE_DATE') {
	        	if(columnModel.visibility==true) {
	        		columns.push(Ext.create('Ext.grid.column.Column', {
		            	text:this$.getFieldLabel(columnModel),
		                dataIndex: columnModel.name,
		                data:columnModel.defaultValue,
		                tooltip : this$.getFieldLabel(columnModel),
		                sortable:columnModel.defaultValue.sortable,
		                flex:0.4
		            }));
	        	}
	        	else {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel),
	                sortable:columnModel.defaultValue.sortable,
	                /*renderer:function(date) {
	        			return dateRender(date);
	        		},*/
	                flex:0.4
	            }));
	        	}
	        } else {
 	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnModel),
	                dataIndex: columnModel.name,
	                data:columnModel.defaultValue,
	                hidden:true,
	                tooltip : this$.getFieldLabel(columnModel), //+ getCommonTranslation('DRAGANDDROPTEXT'),
	                //menuDisabled : true,
	                sortable:columnModel.defaultValue.sortable,
	                flex:0.4,
	                renderer: function(value) {
	                	if(columnModel.whetherHyperlink && !isNullOrEmpty(value) && value !=0) {
		                	   value="<a href='#'>"+value+"</a>";
	                	} else if(columnModel.whetherColorFormat) {
		                	value = this.getValueInColor(value);
	                	}
	                    return value;
	                }
	            }));
	        }
        });
        
        Ext.each(extraColumns, function(columnName) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
	            	text:this$.getFieldLabel(columnName),
	                dataIndex: columnName,
	                data:columnName,
	                tooltip : this$.getFieldLabel(columnName) ,
	                //menuDisabled : true,
	                sortable:false,
	                whetherExtra: true,
	                flex:0.4,
	                renderer: function(value) {
	                	if(!isNullOrEmpty(value) && value !=0)
	                		value="<a href='#'>"+columnName+"</a>";
	                    return value;
	                },
	            }));
	        });
 
        Ext.suspendLayouts();
        this.reconfigure(store, columns);
        Ext.resumeLayouts(true);
        //Rebind store to grid
        this.down('custompagingtoolbar').bindStore(store);
        //this.down('pagingtoolbar').down('customcombobox').setValue(CONSTANTS.DEFAULT_PAGESIZE);
        
    },
    
    /**
     * Load Custom Search Result View Defination
     * 
     */
	loadCustomSearchResultViewDefination: function(resultViewColumns) {
    	var searchResultColumns = [];
    	Ext.each(resultViewColumns, function(resultViewColumn) {
			    		var columnNameTest = resultViewColumn.resultKey;
						/*if( resultViewColumn.resultKey.includes("cf") ){
							columnNameTest = resultViewColumn.displayCode;
						}*/
			        	searchResultColumns.push(new Ext.data.Field({
			                name: columnNameTest,
			                defaultValue :resultViewColumn,
			                visibility:resultViewColumn.visibility,
			                whetherHyperlink:resultViewColumn.whetherHyperlink,
			                formatter:resultViewColumn.formatter,
			                whetherColorFormat:resultViewColumn.whetherColorFormat,
			                whetherTotalAmount:resultViewColumn.whetherTotalAmount,
			                whetherSchool:resultViewColumn.whetherSchool
			            }));
			        	
			        });
    	return searchResultColumns;
    },
    
    /**
     * Load Search Result View Defination
     * 
     */
	loadSearchResultViewDefination: function(ViewUrl) {
		var baseController = Academia.app.getController('Academia.controller.base.BaseController');
		var currentUserId = baseController.getCurrentlyLoggedInUser().id;
		var currentPortalId = baseController.getCurrentLoggedPortalId();
    	var searchResultColumns = [];
    	Ext.Ajax.request({
			 type: 'rest',
			 async:false,
			// url : SERVERURL.SEARCHRESULTVIEWURL,	
			 url : ViewUrl+'&userId='+currentUserId+'&portalId='+currentPortalId,
			 method:'GET',
				success:function(response, action){
					//Ext.Msg.alert("COLUMN REQ SUCCESS!",response.responseText);
					var jsonData = JSON.parse(response.responseText);
					var resultViewColumns=jsonData.searchResultViewColumns;
			        Ext.each(resultViewColumns, function(resultViewColumn) {
			        	searchResultColumns.push(new Ext.data.Field({
			                name: resultViewColumn.resultKey,
			                defaultValue :resultViewColumn,
			                visibility:resultViewColumn.visibility,
			                whetherHyperlink:resultViewColumn.whetherHyperlink,
			                formatter:resultViewColumn.formatter,
			                whetherColorFormat:resultViewColumn.whetherColorFormat,
			                whetherTotalAmount:resultViewColumn.whetherTotalAmount,
			                whetherSchool:resultViewColumn.whetherSchool
			            }));
			        	
			        });
					
				},
				failure: function(response, form, action){ 	     
	            	if(response.status!=401) {
	            		Ext.Msg.alert("Search Failure!");
	            	}
				}
			});
    	return searchResultColumns;
    },
    
    listeners:{
    	beforeselect:function(selModel,record,index){
    		// not select the row on basis of some condition
    		if(!isNullOrEmpty(selModel.view.up())){
    			var gridItemId = selModel.view.up().getItemId();
        		if(gridItemId == 'courseCoverageCBSGridId' || gridItemId == 'courseCoveragePBSGridId'){
        			if(record.get('WHETHER_ATTENDANCE_MARKED') == "Yes"){
        				return false;
        			}
        		}
    		}
    	},
    	beforerender:function(grid,record){
    		if(grid.selType == 'checkboxmodel'){
    			grid.addCls('grid-hidecls');
    		}
    	},
    	afterrender: function(grid) {
    	   /* var store = grid.getStore();
    	    if (store.getCount() === 0) {
    	        var staticText = '<div id="no-record-id">'+getCommonTranslation('NORESULTSNMESSAGE')+'</div>';
    	        var headerEl = grid.headerCt.el;
    	        headerEl.insertSibling({
    	            tag: 'div',
    	            html:  staticText,
    	            cls: 'empty-records-message' // Optional class for styling
    	        });
    	    }*/
    	}
    },
    
    /**
     * Define Grid Store
     * 
     * 
     */
    createGridStore: function(resultModelFields, searchEndPointURL, searchCriteria) {
    	var me = this;
    	grid = this;
    	var pageSize = CONSTANTS.DEFAULT_PAGESIZE;
    	var custompagingtoolbar = grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		pageSize = custompagingtoolbar.store.pageSize;
    	}
    	
    	// set pageSize=5 for window 
    	var win = me.up('window');
		if(win && !win.isDashlet) {
			pageSize = CONSTANTS.DEFAULT_WINDOW_GRID_PAGESIZE;
		} else if(win){
			this.defaultStorePageSize = 25; //maximized dashlet grid pageSize
		} 
    	
        var store = Ext.create('Ext.data.Store', {
            pageSize: pageSize,       
            remoteSort : true,
            fields: resultModelFields,
            autoLoad: false,
            proxy: {
                type: 'rest',
                actionMethods: {
                    create : 'POST',
                    read   : 'POST',
                    update : 'POST',
                    destroy: 'POST'
                },
                doRequest: function(operation, callback, scope) {
                    var writer  = this.getWriter(),
                        request = this.buildRequest(operation, callback, scope);
                       
                    if (operation.allowWrite()) {
                        request = writer.write(request);
                    }
                    Ext.apply(request, {
                        headers       : this.headers,
                        timeout       : this.timeout,
                        scope         : this,
                        callback      : this.createRequestCallback(request, operation, callback, scope),
                        method        : this.getMethod(request),
                        jsonData        : this.jsonData,
                        disableCaching: false // explicitly set it to false, ServerProxy handles caching
                    });

                    try {
                    	Ext.Ajax.request(request);
                    } catch(ex) {
                    	showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('UNABLETORETRIEVEDATAFROMTHESERVER'));
                    	Ext.Error.notify = false;
                		Ext.Error.ignore = true;
                        Ext.Error.raise(getErrorTranslation('UNABLETORETRIEVEDATAFROMTHESERVER'));
                        return false;
                    }
                    	               
                    return request;
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                url: searchEndPointURL,
        		reader : {
        			type : 'json',
        			root : 'rows',
        			totalProperty : 'records',
        			successProperty : 'success'
        		},
                writer: {
                  type: 'json',
                  encode: true
                  },
            },
            listeners: {
                  beforeload: function(store, operation,eOpts) {
                         store.proxy.jsonData = Ext.encode(searchCriteria);  
                         me.setLoading(true, false);
                         setInterval(function(){
 							me.setLoading(false, false);
 							}, 2000);
                         },
                         load: function(){
                        	 me.setLoading(false, false);
                        	 resetGridHeaderFix(me);
                        	 if(!isNullOrEmpty(me.getEl().down('.empty-records-message'))){
                    			 me.getEl().down('.empty-records-message').removeCls('empty-records-message');
                    			 me.getEl().down('#no-record-id').addCls('No-Result-CSS');
                    		 }
                        	 if(me.getStore().getCount()){
                        		 me.removeCls('grid-hidecls');
                        	 }

                        	 /*==============code start for "Many" hyperlink=======================*/
                        	 var tooltip,pageSizeCombo = grid.down('#pageSizeCombo'),
                        	 totalRecordCount = grid.down('#totalRecordCount'),
                        	 totalCountDisplayField = grid.down('#totalCountDisplayField');
                        	 if(totalCountDisplayField && pageSizeCombo && totalRecordCount){
                        		 if(pageSizeCombo.getValue()<= grid.store.getTotalCount() && isNullOrEmpty(totalRecordCount.getValue())){
                        			 totalCountDisplayField.setValue('<a href="" target="_blank" style="font-size: 15px; !important;color:#1258BB;text-decoration: none;border-bottom: 1px solid #1258BB;">many</a>)');

                        			 /*tooltip code start here*/
                        			 /*Ext.defer(function() {
                        				 tooltip = Ext.create('Ext.tip.ToolTip', {
                        					 target: totalCountDisplayField.getEl(),
                        					 html: 'see the total number of records', 
                        					 dismissDelay: 0, 
                        					 showDelay: 100, 
                        					 hideDelay: 100,
                        					 trackMouse: true,
                        					 minWidth: 220, 
                        					 listeners: {
                        						 beforeshow: function() {
                        							 if (totalCountDisplayField.getValue().indexOf('<a href=""') !== -1) {
                        								 return true; // Tooltip will be shown only if the hyperlink is present
                        							 } else {
                        								 return false; // Otherwise, don't show the tooltip
                        							 }
                        						 }
                        					 }
                        				 });
                        			 }, 1000, this);
                        			 totalCountDisplayField.getEl().on('click', function() {
                        				 tooltip.destroy(); // Destroy the tooltip after the link is clicked
                        			 });*/
                        			 /*tooltip code end here*/

                        			 grid.down('#nextButtonPaging') && grid.down('#nextButtonPaging').setDisabled(true);
                        			 grid.down('#lastButton') && grid.down('#lastButton').setDisabled(true);
                        		 }else{
                        			 if(!isNullOrEmpty(totalRecordCount.getValue())){
                        				 totalCountDisplayField.setValue(totalRecordCount.getValue()+')'); 
                        			 }
                            	 }
                        	 }
                        	 /*==============code end for "Many" hyperlink=======================*/
                           }
                         },
            columns:resultModelFields,
            currentSortCriteria:{},
            preSortOrder: null,
            preColumnId:null,
            sort: function(sorter, direction){
              	var sortCriteria=new Array();
            	var this$=this;
            	Ext.each(arguments, function(argument) {
            		columnId=this$.findColumnId(argument.property);
            		/* for sorting order*/
            		if(!isNullOrEmpty(Ext.app.preColumnId)){
            			if(Ext.app.preColumnId!=columnId){
            				Ext.app.preSortOrder=null;
            				Ext.app.preColumnId=columnId;
            			}
            			
            		}else{
            			Ext.app.preColumnId=columnId;
            		}
            		if(!isNullOrEmpty(Ext.app.preSortOrder)){
	            		if(Ext.app.preSortOrder == "ASC"){
	            			argument.direction = "DESC";
	            			Ext.app.preSortOrder  = "DESC";
	                	} else {
	                		argument.direction = "ASC";
	                		Ext.app.preSortOrder  = "ASC";
	                	}
            		} else {
            			Ext.app.preSortOrder = argument.direction;
            		}
            		
            		var criteria={
            				searchResultViewColumnId:columnId,
            				sortOrder:argument.direction
            		}
            		sortCriteria.push(criteria);
                });
            	searchCriteria.sortCriterias=sortCriteria;
            	this.setCurrentSortCriteria(sortCriteria);
            	var formData = Ext.encode(searchCriteria);
            	store.proxy.jsonData = formData;
            	this.load();
              },
              
              findColumnId:function(resultKey){
            	  for(var i=0; i<resultModelFields.length;i++){
              	  	if(resultModelFields[i].defaultValue.resultKey==resultKey){
              			  return resultModelFields[i].defaultValue.id;
              		  }
              	  }
              },
              getCurrentSortCriteria:function(){
              	return this.currentSortCriteria;
              },
              setCurrentSortCriteria:function(sortCriteria){
              	this.currentSortCriteria=sortCriteria;
              }
        });
        return store;
    },
    getFieldLabel: function(column) {
    	if(!Ext.isDefined(getCommonTranslation(column.name)) || column.name.includes("cf") ){
			return	column.defaultValue.displayCode;
		}
        return getCommonTranslation(column.name);
    },

    /**
     * method to disable/hide the buttons in the toolbar according to the passed privilege level 
     * @param {String} the max privilege level for the particular row, the values can be VIEW, EDIT, DELETE  
     *  here VIEW is the least whereas delete is the greatest privilege.
     */
    disableButtonsByPivileges: function(privilegeList) {
    	/*TODO: remove the console after understanding, This prints only those permissions
     	 * which the user has.
     	 * accordingly the buttons will be hidden/shown 
    	 */
    	buttonsToolBar = this.query('#functionButtonsToolbar')[0];
    	try{
    		var gridItemId = buttonsToolBar.up('grid').itemId;
    	}
    	catch(e){
    		var gridItemId = '';
    	}
    	/**
    	 * querying the buttons and unhiding them if any.
    	 */
    	var buttons = buttonsToolBar.query('button');
    	Ext.each(buttons, function(button) {
    		button.setVisible(false);
    	});
    	
    	Ext.each(privilegeList, function(privilege) {
    		if(privilege === 'DELETE') {
    			var button = buttonsToolBar.query('#searchResultGridBtnDelete')[0];
    			if(button != undefined) {
    				button.setVisible(true);
    			}
        	} else if (privilege === 'UPDATE') {
        		var button = buttonsToolBar.query('#searchResultGridBtnEdit')[0];
        		if(button != undefined) {
    				button.setVisible(true);
    			}
        	} else if (privilege === 'CREATE'){
        		var button = buttonsToolBar.query('#searchResultGridBtnAdd')[0];
        		if(button != undefined) {
    				button.setVisible(true);
    			}
        	} else if (privilege === 'VIEW') {
        		var button = buttonsToolBar.query('#searchResultGridBtnView')[0];
        		if(button != undefined && gridItemId!="programBathcReportGrid" && gridItemId!="delayedCourseSearchGrIdCBS") {
    				button.setVisible(true);
    			}
        	} else if (privilege == 'MOREACTIONS') {
        		var button = buttonsToolBar.query('#searchResultGridMoreOperations')[0];
        		if(button != undefined) {
        			button.setVisible(true);	
        		}
        	} else if (privilege === 'EXPORT') {
        		var buttonsArray = new Array();
        		buttonsArray.push(buttonsToolBar.query('#exportToPdfBtn')[0]);
        		buttonsArray.push(buttonsToolBar.query('#exportToPdfBtn')[0]);
        		Ext.each(buttonsArray, function(button) {
        			button.setVisible(true);	
        		});
        	} else if (privilege === 'EDIT') {
        		var button = buttonsToolBar.query('#searchResultGridBtnEdit')[0];
        		if(button != undefined) {
    				button.setVisible(true);
    			}
        	}else if (privilege === 'EXPORTREPORTS') {
        		var button = buttonsToolBar.query('#exportReportsId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'CHANGEFEERULE') {
        		var button = buttonsToolBar.query('#btnChangeFeeRule')[0];
        		if (!isNullOrEmpty(button)) {
        			button.setVisible(true);
        		}
        		}
        	else if (privilege === 'CANCEL_ADHOC_MESSAGE') {
        		var button = buttonsToolBar.query('#btnCancelAdhocMsg')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
    	});
    },
    
    addButtonToolbar: function() {
    	var grid = this;
    	if(!Ext.isDefined(grid.down('#functionButtonsToolbar')) || isNullOrEmpty(grid.down('#functionButtonsToolbar'))){
    		grid.addDocked(
    				{
    					xtype: 'toolbar',
    					itemId: 'functionButtonsToolbar',
    					dock:'top',
    					items:['->',{
    						xtype: 'button',
    						itemId: 'searchResultGridBtnAdd',
    						tooltip : getCommonTranslation('ADD'),
    						 iconCls:'icon-addbutton',
    						 cls:'addbutton'
    					}, {
    						xtype: 'button',
    						itemId: 'searchResultGridBtnEdit',
    						tooltip : getCommonTranslation('EDIT'),
    						iconCls:'icon-editbutton',
    						cls:'editbutton'
    					}, {
    						xtype: 'button',
    						itemId: 'searchResultGridBtnView',
    						tooltip : getCommonTranslation('VIEW'),
    						iconCls: 'icon-View',
    						cls:'iconView'	
    					},{
    						xtype: 'button',
    						itemId: 'searchResultGridBtnDelete',
    						cls: 'CustomToolbarBtnReject',
    						tooltip : getCommonTranslation('DELETE'),
    						iconCls: 'icon-Delete',
    						cls:'iconDelete'
    					},{
						xtype: 'button',
						text:getCommonTranslation('EXPORTREPORTS'),
						itemId:'exportReportsId',
						tooltip :getCommonTranslation('EXPORTREPORTS'),
						disabled:true,
    					},{
    				        xtype: 'button',
    				        itemId: 'exportToPdfBtn',
    				        text: getCommonTranslation('PRINT_EXPORT_BTN'),
    				        //iconCls: 'export-combo-icon', // Optional icon
    				        cls: 'print_export_btn_cls',
    				        menu: {
    				        	cls: 'print_export_btn_menu_cls',
    				        	items:  [{
        				            text: 'Export to PDF',
        				            //itemId: 'btnExportToPDF',
        				            menu: {
        				            	cls: 'print_export_btn_menu_cls',
        				            	items: [{
                							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
                							itemId: 'exportCurrentPagePdf'
                						}, {
                							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
                							itemId: 'exportPdfAll'
                						}]
        				            }
        				        },{
        				        	text: 'Export to Excel',
        				            itemId: 'exportToPdfBtn',
        				            menu: {
        				            	cls: 'print_export_btn_menu_cls',
        				            	items: [{
                							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
                							itemId: 'exportCurrentExcelPage'
                						},{
                							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
                							itemId: 'exportExcelAll'
                						}]
        				            }
        				        }]
    				        }
    					}/*,{
    						xtype: 'splitbutton',
    						itemId: 'exportToPdfBtn',
    						cls: 'CustomToolbarBtnExport export-cls',
    						iconCls:'export-pdf-icon',
    						//text: 'Export To Pdf',      
    						menu: [{
    							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
    							itemId: 'exportCurrentPagePdf'
    						}, {
    							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
    							itemId: 'exportPdfAll'
    						} ],
    						listeners: { click: function() { this.showMenu(); } }
    					},{
    						xtype: 'splitbutton',
    						itemId: 'exportToPdfBtn',
    						cls: 'CustomToolbarBtnExport export-cls',
    						iconCls:'export-excel-icon',
    						//text: 'Export To Xcel',      
    						menu: [{
    							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
    							itemId: 'exportCurrentExcelPage'
    						}, {
    							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
    							itemId: 'exportExcelAll'
    						} ],
    						listeners: { click: function() { this.showMenu(); } }
    					}*/]
    				});
    	}
    },
    removePagingToolbar: function() {
    	grid = this;
    	var custompagingtoolbar = grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		custompagingtoolbar.hide();
    	}
    },
    addPagingToolbar: function(store) {
    	grid = this;
    	var custompagingtoolbar = grid.down('custompagingtoolbar');
    	if(!custompagingtoolbar){
    		grid.addDocked({
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                	xtype: 'custompagingtoolbar',
                    plugins:['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                    displayInfo: true
                }]
        	});
    	}else if(!custompagingtoolbar.isVisible()){
    		custompagingtoolbar.show();
    		custompagingtoolbar.bindStore(store);
    	}else{
    		custompagingtoolbar.bindStore(store);
    	}
    	
    },
    addExportButtonToolbar: function() {
    	grid = this;
    	grid.addDocked(
    			{
    				xtype: 'toolbar',
    				itemId: 'functionButtonsToolbar',
    				dock:'top',
    				items:[/*{
    			        xtype: 'splitbutton',
    			        itemId: 'exportToPdfBtn',
    			        cls: 'CustomToolbarBtnExport export-cls',
    			        iconCls:'export-pdf-icon',
    			        //text: 'Export To Pdf',      
    			        menu: [{
    			            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
    			            itemId: 'exportCurrentPagePdf'
    			        }, {
    			            text: getCommonTranslation('EXPORT_ALL_COMMON'),
    			            itemId: 'exportPdfAll'
    			        } ],listeners: { click: function() { this.showMenu(); } }
    			    },{
    			        xtype: 'splitbutton',
    			        itemId: 'exportToPdfBtn',
    			        cls: 'CustomToolbarBtnExport export-cls',
    			        iconCls:'export-excel-icon',
    			        //text: 'Export To Xcel',      
    			        menu: [{
    			            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
    			            itemId: 'exportCurrentExcelPage'
    			        }, {
    			            text: getCommonTranslation('EXPORT_ALL_COMMON'),
    			            itemId: 'exportExcelAll'
    			        } ],listeners: { click: function() { this.showMenu(); } }
    			    }*/{
				        xtype: 'button',
				        itemId: 'exportToPdfBtn',
				        text: getCommonTranslation('PRINT_EXPORT_BTN'),
				        //iconCls: 'export-combo-icon', // Optional icon
				        cls: 'print_export_btn_cls',
				        menu: [{
				            text: 'Export to PDF',
				            //itemId: 'btnExportToPDF',
				            menu: [{
    							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
    							itemId: 'exportCurrentPagePdf'
    						}, {
    							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
    							itemId: 'exportPdfAll'
    						}]
				        },{
				        	text: 'Export to Excel',
				            itemId: 'exportToPdfBtn',
				            menu: [{
    							text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
    							itemId: 'exportCurrentExcelPage'
    						},{
    							text: getCommonTranslation('EXPORT_ALL_COMMON'), 
    							itemId: 'exportExcelAll'
    						}]
				        }]
					}]
    			});
    },
    exportData:function(exportUrl,filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,advancedSearchRequest,pageNumber,limitMax){
    	filetype="application/"+filetype;
    	
    	var pageNo=parseInt(pagingtoolbaroptions.page);
    	var limit=parseInt(pagingtoolbaroptions.limit);
    	if(whetherAll){
    		pageNo=1;
    		limit=-1;
    	}
    	if(!isNullOrEmpty(pageNumber) && !isNullOrEmpty(limitMax)){
    		pageNo=pageNumber;
    		limit=limitMax;
		}
    	/*
    	 *  This code is for GET request that open new tab 
    	 *  to download file
    	 */
    	baseController = Academia.app.getController('Academia.controller.base.BaseController');
    	user=baseController.getCurrentlyLoggedInUser();
    	

    	var userId=user.code;
    	/*
    	var csvForm = Ext.create('Ext.form.Panel',{
    		items:[{
    			xtype : 'textfield',
    			itemId : 'basicSearchDTO',
    			name : 'basicSearchDTO'
    		}]
    	}); 
    	csvForm.down('#basicSearchDTO').setValue(Ext.encode(jsonFormatFormData));
    	csvForm.getForm().submit({
			target: '_blank',
		    method:'POST',
		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		    headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    url : exportUrl +'?page='+pageNo+'&limit='+limit+'&user='+userId,
		    standardSubmit :true
    	});*/
    	
    	var exportListDTO =new Object();
    	exportListDTO.basicSearchDTO=jsonFormatFormData;
    	exportListDTO.userId=user.code;
    	exportListDTO.searchCriteriaString=searchCriteriaString;//AcademyName : JSPM ,Location Name: Pune, Program : BE Computer, Batch: 2011, Course: ES";
    	exportListDTO.whetherRTL=false;
    	exportListDTO.academyLocationId=baseController.getCurrentAcademyLocation();
    	exportListDTO.searchResultViewColumns=visibleColumns;
    	exportListDTO.reportTitle=reportTitle;
    	exportListDTO.advancedSearchDTO=advancedSearchRequest;
    	
    	var csvForm = Ext.create('Ext.form.Panel',{
    		items:[{
    			xtype : 'textfield',
    			maxLength : 50896000,
    			itemId : 'exportListDTO',
    			name : 'exportListDTO',
    			vtype : 'spaceAsInput'
    		}]
    	}); 
    	csvForm.down('#exportListDTO').setValue(Ext.encode(exportListDTO));
    	csvForm.getForm().submit({
			target: '_blank',
		    method:'POST',
		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		    headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    url : exportUrl +'?page='+pageNo+'&limit='+limit,
		    standardSubmit :true
    	});
	},
	
	getValueInColor:function(value) {
		
		var greenColor = "<font color='green'>";
		var redColor = "<font color='red'>";
		var blueColor = "<font color='blue'>";
		var lightBlueColor = "<font color='#1B7BFE'>";
		var darkOrangeColor = "<font color='#D2691E'>";
		// For OPEN_CLOSE_FORMATTER
		
		/*if(value=='Close') {
    		value=redColor+value+"</font>";
    	} else if(value=='Open') {
    		value=greenColor+value+"</font>";
    	}*/
		
		// For BOOLEAN_TO_YES_NO_FORMATTER
		
		if(value=='Yes') {
    		value=greenColor+value+"</font>";
    	} else if(value=='No') {
    		value=redColor+value+"</font>";
    	}
		
		// ENQUIRY_OPEN_CLOSE_FORMATTER
		
		if(value=='Closed') {
    		value=greenColor+value+"</font>";
    	} else if(value=='Open') {
    		value=redColor+value+"</font>";
    	}
		
		// For BOOLEAN_TO_ACTIVE_INACTIVE_FORMATTER
		
		if(value=='Active') {
    		value=greenColor+value+"</font>";
    	} else if(value=='Inactive') {
    		value=redColor+value+"</font>";
    	}
		
		// For PNC_TIME_TABLE_BOOLEAN_OPTIONAL_SESSION_FORMATTER
		
		if(value=='Mandatory') {
    		value=darkOrangeColor+value+"</font>";
    	} else if(value=='Optional') {
    		value=lightBlueColor+value+"</font>";
    	}
		
		if(value=='Present') {
    		value=greenColor+value+"</font>";
    	} else if(value=='Absent') {
    		value=redColor+value+"</font>";
    	} else if(value=='Absent but not compulsory') {
    		value=redColor+value+"</font>";
    	} else if(value=='Excuse') {
    		value=blueColor+value+"</font>";
    	} else if(value=='Sick Leave') {
    		value=blueColor+value+"</font>";
    	} else if(value=='Partially Present') {
    		value=greenColor+value+"</font>";
    	} else if(value=='Leave') {
    		value=blueColor+value+"</font>";
    	}
		
		if(value=='Fail') {
    		value=redColor+getExaminationTranslation(value)+"</font>";
    	} else if(value=='Pass') {
    		value=greenColor+getExaminationTranslation(value)+"</font>";
    	}
		
		return value;
	},
	/**
	 * toggle grid summary row
	 * @param: pass grid & boolean
 	 * @author Rajkumar.Patidar
	 */
	toggleCBGridSummaryRow : function(grid,isVisible){
		var view = grid.getView();
		view.getFeature(0).toggleSummaryRow(isVisible);
		view.refresh();
	},
});


