/*
 * @author Ashok Wagh
 */
Ext.define('Academia.view.criteriabuilder.simpleadvancesearch.SimpleAdvancedSearchQueryBuilderView', {
	extend : 'Ext.form.Panel',
	alias : 'widget.simpleadvancedsearchquerybuilder',
	autoScroll: true,
	cls:'horizontalScrollingFixed',
	title: getCommonTranslation('ADVANCED_SEARCH'),
	config : {
		searchConfigCode : null,
		searchResultViewCode: null,
		searchConfigDataSource :null,
		exportedReportTitle:null,
		permissionMapKey:null,
		gridTitle:null,
		moduleName:null
	},
	moduleName:'PROGRAMS_AND_COURSES',
	initComponent: function() {
		/*
		 * Commented the call, Called the method explicitly from CBController.
		 */
		this.moduleName = 'PROGRAMS_AND_COURSES';
		this.items = [{
			xtype: 'panel',
			//collapsible:true,
			//collapsed:false,
			border: true,
			//title:getCommonTranslation('SEARCH_CRITERIA'),
			style:{marginTop:'15px !important',marginLeft:'15px !important',marginRight:'15px !important'},
			cls:'customSearchPanel searchforpncCls',
			height:'auto',
			items: [{
				xtype: 'simplesearchcriteriagroup',
//				cls:'customSearchPanel',
				itemId: 'defaultGroup',
				config: {
					searchConfigDataSource: this.searchConfigDataSource
				}
			},{
				xtype: 'fieldcontainer',
				width: '100%',
	    		layout : 'hbox',
	    		cls: 'customSearchPanelBtnsFieldContainerCls simpleAdvanceViewBtnCls',
				items: [{
					xtype: 'button',
					formBind: true,
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchButton',
					//buttonAlign: 'right',
					ui: 'CustomBtnSubmit',
					//ui : 'CustomBtnThird',
					scale : CONSTANTS.BUTTONSIZE,
					handler: function() {
						var advancedSearchRequest = this.up('panel').up('panel').prepareSearchCriteria();
						if(advancedSearchRequest.cbSearchCriteria!=false)
						{
							this.up('panel').up('panel').fireSearchAndPopulateGrid(advancedSearchRequest);
							var gridTitle=this.up('simpleadvancedsearchquerybuilder').down('#loadSavedSearchComboId').getRawValue();
							if(isNullOrEmpty(gridTitle))
								gridTitle=getCommonTranslation('SEARCHRESULTSGRIDHEADER');
							this.up('simpleadvancedsearchquerybuilder').down('searchresultgrid').setTitle(gridTitle);
						}

					}
				},{
					xtype: 'button',
					text: getMessagingModuleTranslation('CLEAR_SEARCH'),
					itemId: 'ClearCriteriaButton',
					//buttonAlign: 'right',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					handler: function() {
						var simpleadvancedsearchquerybuilder = this.up('simpleadvancedsearchquerybuilder');
						simpleadvancedsearchquerybuilder.clearSearchCriteria(simpleadvancedsearchquerybuilder);
						simpleadvancedsearchquerybuilder.clearDependentFields(this.up('panel'));
						simpleadvancedsearchquerybuilder.down('#verticalPanel').nextChildIndex=0;
						simpleadvancedsearchquerybuilder.down('#verticalPanel').down('#tableSearchFilter').reset();
					}
				},{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SaveSearchButton',
					ui : 'CustomBtnThird',
					scale : CONSTANTS.BUTTONSIZE,
					handler: function() {
						this.up('panel').up('panel').saveSearchCriteria();
					}
				}]
			}]
		},{
			xtype: 'searchresultgrid',
			padding: '0 15 0 15',
			itemId: 'userAdvSearchResultGrid',
			listeners:{
				'render': function(grid){
					grid.setTitle(getCommonTranslation('SEARCHRESULTSGRIDHEADER'));
					this.up('simpleadvancedsearchquerybuilder').addAdvSearchExportButtonToolbar(grid);
					var permissionMap=Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap(this.up('simpleadvancedsearchquerybuilder').permissionMapKey);
					if(permissionMap!=undefined)
					{
						baseController = Academia.app.getController('Academia.controller.base.BaseController');
						baseController.genericCBGridAccessControlValidation(grid, permissionMap);
					}
				}
			}
		}];

		this.callParent(arguments);

	},



	/*
	 * this is called from the initcomponent of the same file
	 */
	loadConfiguration: function() {
		var this$= this;
		var advancedSearchConfigStore = Ext.create('Academia.store.criteriabuilder.AdvancedSearchConfigs');
		var searchConfigDataUrl =SERVERURL.ADVANCEDSEARCHCONFIGSTOREURL;
		searchConfigDataUrl = searchConfigDataUrl.concat(this.searchConfigCode+'&viewCode='+this.searchResultViewCode);
		advancedSearchConfigStore.getProxy().api.read=searchConfigDataUrl;

		/*
		 * Use the config's and assign it to the store to load the respective search
		 */
		advancedSearchConfigStore.load({
			callback: function(records, operation, success) {
				this$.buildSearchConfigDataSource(advancedSearchConfigStore);
			}
		});
	},

	/*
	 * @method buildSearchConfigDataSource
	 * method to populate all the required/dependent stores for populating the dropdowns
	 * @param {object} advancedSearchConfigStore : the store object which will contain the server response
	 * which will bring the basic configuration of the criteria builder.
	 */
	buildSearchConfigDataSource:function(advancedSearchConfigStore){
		wsAdvancedSearchConfig = advancedSearchConfigStore.getAt(0);
		var columnMap = new Ext.util.HashMap();
		var defaultColumnMap = new Ext.util.HashMap();
		var allColumns=[];
		var defaultColumns=[];
		if(wsAdvancedSearchConfig.data.allColumnSearchResultView!=null){
			allColumns=wsAdvancedSearchConfig.data.allColumnSearchResultView.searchResultViewColumns;
			var this$=this;
			Ext.each(allColumns,function(column){
				column.displayCode=this$.getColumnTranslation(column);
				columnMap.add(column.resultKey, column);
			});
			defaultColumns=wsAdvancedSearchConfig.data.wsSearchResultView.searchResultViewColumns;
			Ext.each(defaultColumns,function(column){
				column.displayCode=this$.getColumnTranslation(column);
				defaultColumnMap.add(column.resultKey, column);
			});
		}
		var searchConfigDataSource =Ext.create('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchConfigDataSource', {
			wsSearchConfigTables : wsAdvancedSearchConfig.data.wsSearchConfigTables,
			/*
			 * did not initialize the columns, They will be initialized on selection of tables dropdown.
			 */
			dateOperators:wsAdvancedSearchConfig.data.searchCriteriaOperators.DATE,
			booleanOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.BOOLEAN,
			stringOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.STRING,
			integerOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.NUMBER,

			identityOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.IDENTITY,
			referenceIdentifyOperators :wsAdvancedSearchConfig.data.searchCriteriaOperators.REF_IDENTITY,
			enumOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.ENUM,
			characterOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.CHAR,
			columnMap:columnMap,
			defaultColumnMap:defaultColumnMap,
			allColumnViewsearchSQLGroups:wsAdvancedSearchConfig.data.allColumnSearchResultView.searchSQLGroups
		});
		this.searchConfigDataSource = searchConfigDataSource;
		this.down('simplesearchcriteriagroup').searchConfigDataSource = searchConfigDataSource;

		//tableSearchFilter multiselect combo store add data
		var tableSearchFilter = this.down('simplesearchcriteriagroup').down('#tableSearchFilter');
		tableSearchFilter.getStore().add(searchConfigDataSource.getWsSearchConfigTables());

		//ItemSelector add data
		var selectorStore = Ext.create('Academia.store.criteriabuilder.AllColumnSearchResultViewStore',{
			data: allColumns
		});
		this.down('itemselector').bindStore(selectorStore);
		var defaultViewColumns=this.buildSelectedColumns(defaultColumns);
		if(defaultViewColumns.length>0){
			this.down('itemselector').setValue(defaultViewColumns);
		}
	},
	getColumnTranslation: function(column) {
		var translation = getCommonTranslation(column.resultKey);  
		if(translation == null || translation == undefined || translation == '') {
			translation = column.displayCode;
		}
		return translation;
	},
	/*
	 * @method
	 * method to prepare the search criteria json object from the selected values.
	 */
	prepareSearchCriteria: function() {

		var advancedSearchRequest = new Object();
		var sortCriterias = new Array();

		advancedSearchRequest.configCode= this.searchConfigCode;

		var sortCriteria = new Object();
		sortCriteria.sortOrder = "ASC";
		sortCriteria.searchResultViewColumnId = 5;
		sortCriterias.push(sortCriteria);

		//TODO: remove hardcoding
		var sortCriteria1 = new Object();
		sortCriteria1.sortOrder = "DESC";
		sortCriteria1.searchResultViewColumnId = 6;
		sortCriterias.push(sortCriteria1);
		var request = null;
		try {
			request = this.down('panel#defaultGroup').getSearchCriteriaValue();
		}
		catch (ex) {
			showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
			Ext.Error.notify = false;
			Ext.Error.ignore = true;
			Ext.Error.raise(getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
			return false;
		}

		var length = request.searchCriterias.length;
		var counter = 0;
		while (length > counter){
			if(request.searchCriterias[counter].advancedSearchCriteria != undefined) {
			var operands = request.searchCriterias[counter].advancedSearchCriteria.operands;
			if(!isNullOrEmpty(operands) && operands.length == 1) {
				if(isNullOrEmpty(operands[0])) {
					request.searchCriterias[counter].advancedSearchCriteria.operands[0]='DoNotUse';
				}
			}
		  }
			counter = counter + 1;
		}

		var searchResultViewColumns=[];
		var colMap=this.getSearchConfigDataSource().columnMap;
		var defaultColumnMap=this.getSearchConfigDataSource().defaultColumnMap;
		var columnIds=this.down('itemselector').getValue();
		var order=1;
		Ext.each(columnIds,function(columnId){
			if(colMap.get(columnId)!=undefined){
				var tempColumn=colMap.get(columnId);
				tempColumn.displayOrder=order;
				tempColumn.visibility=true;
				searchResultViewColumns.push(tempColumn);
			}
			order=order+1;
		});
		this.addGroupByColumns(searchResultViewColumns,this.getSearchConfigDataSource().allColumnViewsearchSQLGroups);
		advancedSearchRequest.searchResultViewColumns=searchResultViewColumns;
		advancedSearchRequest.searchSQLGroups=this.getSearchConfigDataSource().allColumnViewsearchSQLGroups;
		advancedSearchRequest.cbSearchCriteria = request;
		return advancedSearchRequest;
	},

	addGroupByColumns:function(searchResultViewColumns,allColumnViewsearchSQLGroups){
		var colMap=this.getSearchConfigDataSource().columnMap;
		var this$=this;
		Ext.each(allColumnViewsearchSQLGroups,function(SQLGroup){
			//if(SQLGroup.order==1){
			Ext.each(SQLGroup.searchSQLGroupBies,function(SQLGroupBy){
				var searchResultViewColumn=colMap.get(SQLGroupBy.searchResultViewColumn.resultKey);
				if(!this$.isColumnExistInArray(searchResultViewColumns,searchResultViewColumn)){
					searchResultViewColumns.push(searchResultViewColumn);
				}
			});
			//}
		});
	},
	isColumnExistInArray : function(searchResultViewColumns,searchResultViewColumn){
		var isExist= false;
		Ext.each(searchResultViewColumns,function(selectedColumn){
			if(selectedColumn.resultKey==searchResultViewColumn.resultKey){
				isExist= true;
			}
		});
		return isExist;
	},
	/*
	 * @method
	 * method for populating the grid with result after the click of search button.
	 * @param {object} which is the json that is prepared by prepareSearchCriteria method.  
	 */
	fireSearchAndPopulateGrid: function(AdvancedSearchRequest){
		submitUrl = SERVERURL.SEARCHREQUESTURL;
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		resultViewUrl = resultViewUrl.concat(this.searchResultViewCode);
		//Add grid to the view
		var resultGrid = this.down("#userAdvSearchResultGrid");
		resultGrid.initialize(submitUrl, resultViewUrl, AdvancedSearchRequest);

	},
	addAdvSearchExportButtonToolbar: function(grid) {
		grid.addDocked(
				{
					xtype: 'toolbar',
					itemId: 'functionButtonsToolbar',
					disabled:false,
					dock:'top',
					items:['->', {
					    xtype: 'button',
					    itemId: 'exportToPdfBtn',
					    text: getCommonTranslation('PRINT_EXPORT_BTN'),
					    //iconCls: 'export-combo-icon', // Optional icon
					    cls: 'print_export_btn_cls',
					    menu: [{
					        text: 'Export to PDF',
					        //itemId: 'btnExportToPDF',
					        menu: [{
					            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
					            itemId: 'exportCurrentPagePdf',
					            listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVPDFEXPORT,'pdf',false); }}
					        }, {
					            text: getCommonTranslation('EXPORT_ALL_COMMON'),
					            itemId: 'exportPdfAll',
					            listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVPDFEXPORT,'pdf',true); }}
					        }]
					    }, {
					        text: 'Export to Excel',
					        itemId: 'exportToPdfBtn',
					        menu: [{
					            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
					            itemId: 'exportCurrentExcelPage',
					            listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVEXCELEXPORT,'vnd.ms-excel',false); }}
					        }, {
					            text: getCommonTranslation('EXPORT_ALL_COMMON'),
					            itemId: 'exportExcelAll',
					            listeners: { click: function() {  this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVEXCELEXPORT,'vnd.ms-excel',true);}}
					        }]
					    }]
					}/*{
						xtype: 'splitbutton',
						itemId: 'exportToPdfBtn',
						cls: 'CustomToolbarBtnExport',
						iconCls:'export-pdf-icon',
						//text: 'Export To Pdf',      
						menu: [{
							text: 'Export Current Page',
							itemId: 'exportCurrentPagePdf',
							listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVPDFEXPORT,'pdf',false); }}
						}, {
							text: 'Export All',
							itemId: 'exportPdfAll',
							listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVPDFEXPORT,'pdf',true); }}
						} ],listeners: { click: function() { this.showMenu(); } }
					},{
						xtype: 'splitbutton',
						itemId: 'exportToPdfBtn',
						cls: 'CustomToolbarBtnExport',
						iconCls:'export-excel-icon',
						//text: 'Export To Xcel',      
						menu: [{
							text: 'Export Current Page',
							itemId: 'exportCurrentExcelPage',
							listeners: { click: function() { this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVEXCELEXPORT,'vnd.ms-excel',false); }}
						}, {
							text: 'Export All',
							itemId: 'exportExcelAll',
							listeners: { click: function() {  this.up('simpleadvancedsearchquerybuilder').exportList(SERVERURL.ADVEXCELEXPORT,'vnd.ms-excel',true);}}
						} ],listeners: { click: function() { this.showMenu(); } }
					}*/]
				});
	},
	exportList : function(exportUrl,filetype,whetherAll) {

		var searchResultGrid = this.down("#userAdvSearchResultGrid");
		var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		var searchCriteriaString=null;
		var jsonFormatFormData=null;
		var advancedSearchRequest = this.prepareSearchCriteria();
		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			advancedSearchRequest.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,this.gridTitle,advancedSearchRequest);
	}, 
	/**
	 * This method is use to get the visible columns in any CB grid
	 */
	getVisibleColumns:function(grid){
		var visibleColumns=new Array();
		var columns=new Array();
		columns=grid.columnManager.columns;
		Ext.each(columns,function (column){
			if(column.whetherExtra != true){
				var visibleColumn=new Object();
				visibleColumn.resultKey=column.data.resultKey;
				visibleColumn.displayCode=column.text;
				visibleColumn.displayOrder=column.data.displayOrder;
				visibleColumns.push(visibleColumn);
			}
		});

		return visibleColumns;
	},

	/*
	 * @method method for clearing the existing components in the search criteria panel.
	 * 
	 */
	clearSearchCriteria: function(simpleadvancedsearchquerybuilder) {
		var containerPanel = simpleadvancedsearchquerybuilder.down('panel#verticalPanel').items.items;
		var i = 0;
		if(containerPanel.length > 1) {
			Ext.each(containerPanel, function(item) {
				if(item != undefined && item.itemId!='tableSearchFilterContainer') {
					item.close();	
				}
			});
			if(containerPanel[1] != undefined)
				containerPanel[1].close();

			simpleadvancedsearchquerybuilder.clearSearchCriteria(simpleadvancedsearchquerybuilder);
		}





		/*if(containerPanel.items.length > 0) {
    		Ext.each(containerPanel.items, function(obj) {
        		if(obj != undefined && obj.itemId!='tableSearchFilterContainer') {
        			obj.close();	
        		}
    		});
    		if(containerPanel.items[1] != undefined)
        	containerPanel.items[1].close();
    	}*/

		/*
		 * var tableSearchFilterCombo=containerPanel.items[0];
    		containerPanel.removeAll();
    		containerPanel.insert(0,tableSearchFilterCombo);
		 */
	},

	/*
	 * @method 
	 * method for loading the previously saved search criteria onto the screen.
	 * @param {object} advancedSearchQueryBuilderView : is the reference of the view.
	 * @param {integer} savedCriteriaId : is the id of the selected search.
	 */
	loadSavedSearchCriteria: function(advancedSearchQueryBuilderView, savedCriteriaId,fireSearch) {

		/*
		 * called the method for deleting the previously added components.
		 */ 
		var this$=this;
		this.clearSearchCriteria(advancedSearchQueryBuilderView);

		var qyeryBuilderView = advancedSearchQueryBuilderView;
		var submitUrl = SERVERURL.LOADSAVEDSEARCHURL;
		submitUrl= submitUrl.concat(savedCriteriaId);
		Ext.Ajax.request({
			url: submitUrl,
			method: 'GET',
			success: function(response) {
				var responceData = JSON.parse(response.responseText);
				var advancedSearchCriteria = Ext.create('Academia.model.criteriabuilder.AdvancedSearchCriteria', responceData.cbSearchCriteria); 

				var defaultGroup = qyeryBuilderView.down('panel').items.items[0];
				//var defaultGroup = advancedSearchQueryBuilderView.down('searchcriteriagroup');
				defaultGroup.initializeByModel(advancedSearchCriteria);
				var selectedColumns=this$.buildSelectedColumns(responceData.searchResultViewColumns);
				if(selectedColumns.length>0){
					advancedSearchQueryBuilderView.down('itemselector').setValue(selectedColumns);
					//advancedSearchQueryBuilderView.down('itemselector').setVisible(true);
					//advancedSearchQueryBuilderView.down('radiogroup').setValue({selectedView:"CUSTOM_VIEW"});
				}else{
					//advancedSearchQueryBuilderView.down('itemselector').setVisible(false);
					//advancedSearchQueryBuilderView.down('radiogroup').setValue({selectedView:"DEFAULT_VIEW"});
				}
				advancedSearchQueryBuilderView.down('button#searchButton').setVisible(true);
				advancedSearchQueryBuilderView.down('button#searchButton').enable();

				if(fireSearch!=undefined && fireSearch==true){
					var advancedSearchRequest = advancedSearchQueryBuilderView.prepareSearchCriteria();
					if(advancedSearchRequest.cbSearchCriteria!=false)
					{
						advancedSearchQueryBuilderView.fireSearchAndPopulateGrid(advancedSearchRequest);
					}
				}
			}
		});

	},
	buildSelectedColumns:function(searchResultViewColumns){
		var columnArray=[];
		Ext.each(searchResultViewColumns,function(searchResultViewColumn){
			if(searchResultViewColumn.visibility!=false)
				columnArray.push(searchResultViewColumn.resultKey);
		});
		return columnArray;
	},
	/**
	 * @method
	 * method to save the search criteria on click of the save button.
	 */
	saveSearchCriteria: function(){
		var formWindow = Ext.create('Academia.view.criteriabuilder.SaveCriteriaOfAdvanceSearch', {
			criteriaSearch : this
		});
		formWindow.show();
	},
	/**
	 * @author Ashok.wagh
	 * This is to save the search criteria
	 */
	saveSearchCriteriaFunction: function(window){
		var queryBuilderViewRef = this;
		var textFieldValue = window.down('textfield[name=nameCriteria]').getValue();
		if(textFieldValue != "" && textFieldValue != null && textFieldValue != undefined){
			var advancedSearchRequest = queryBuilderViewRef.prepareSearchCriteria();
			var submitUrl =SERVERURL.SAVESEARCHCRITERIAURL;
			var sortCriterias = new Array();
			// TODO remove hardcoded userid Use from context
			baseController = Academia.app.getController('Academia.controller.base.BaseController');
			user=baseController.getCurrentlyLoggedInUser();
			var userid=user.id;
			submitUrl = submitUrl.concat('?name='+textFieldValue+'&viewCode='+queryBuilderViewRef.searchResultViewCode+'&userid='+userid+'&moduleName='+this.moduleName);
			/*var sortingToolbar =queryBuilderViewRef.down('grid').query('multiSortToolbar')[0];
	    	var toolbarItems = sortingToolbar.getSorters();
	    	Ext.each(toolbarItems, function(key, value, myself) {
	    		sortCriterias.push(key);
	    	});*/
			advancedSearchRequest.sortCriterias = sortCriterias;
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: advancedSearchRequest,
				method: 'POST',
				success: function(form, action) {
					showSuccessMessage(getCommonTranslation('ADVANCEDSEARCHSAVEOPPUP') , getCommonTranslation('SUCCESS'));
					queryBuilderViewRef.loadSavedSearchCombo(form);
					window.close();
				}
			});
			queryBuilderViewRef.loadSavedSearchCombo();
		}else {
			showWarningMessage(getCommonTranslation('ADVANCEDSEARCHSAVEOPPUP'), getCommonTranslation('SEARCH_CRITERIA_REQUIRED'));
		}
	},

	loadSavedSearchCombo: function() {
		this.down('combo#loadSavedSearchComboId').getStore().load();
	},

	clearDependentFields: function(queryBuilderViewRef) {
		queryBuilderViewRef.down('#loadSavedSearchComboId').clearValue();
		queryBuilderViewRef.down('button#searchButton').disable();
	},
	updateComboURL:function(comboReference){
		var savedSearchStore=comboReference.getStore();
		var savedSearchUrl=SERVERURL.FIND_ALL_SAVED_REPORTS_BY_MODULE;
		baseController = Academia.app.getController('Academia.controller.base.BaseController');
		user=baseController.getCurrentlyLoggedInUser();
		var userid=user.id;
		savedSearchUrl=savedSearchUrl.concat("?userid="+userid+"&moduleName="+this.moduleName);
		savedSearchStore.getProxy().api.read=savedSearchUrl;
	},

	/**
	 * This method is to show hide custom result columns
	 */
	loadResultViewColumns : function(radio,newValue, oldValue){
		var resultViewColumnForm = radio.up('form');
		var itemselector = resultViewColumnForm.down('itemselector');
		var selectedView = radio.getValue().selectedView;

		if(selectedView=='DEFAULT_VIEW'){
			itemselector.setVisible(false);
		}
		else if(selectedView=='CUSTOM_VIEW'){
			itemselector.setVisible(true);
		}
	}


});