Ext.define('Academia.view.criteriabuilder.userquicksearch.QuickSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.quicksearch',
    cls:'customSearchPanel',
    autoScroll: false,
    itemId: 'QuickSearchPanel',
    frame: false,
    defaults: {
        xtype: 'textfield',
        width: 256,
        labelAlign: 'top'
    },
    items: [{
		xtype: 'form',
		cls: 'customSearchInnerPanel userFilterQuickSearchCls',
		itemId:'userQuickSearchForm',
	    method : 'POST',
	    margin:0,
	    padding:0,
	  //  bodyPadding:'10 10 10 10',
	    width: '100%',
		defaults:{
			labelAlign:'top'
		},
	    standardSubmit : false,
        items : [{
		        xtype: 'fieldcontainer',
		        width: '100%',
		        layout: {
		            type: 'hbox'
		        },
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
		        items: [{
					xtype: 'customcombobox',
					fieldLabel: 'User ID',
					name:'USER_ID',
					itemId:'user_id',
					store: 'criteriabuilder.userquicksearch.QuickSearchCode',
					msgTarget: 'qtip',
					valueField: 'value',
					displayField: 'value',
					queryParam:'code',
					minChars:3,
//					allowBlank: false,
					typeAhead:false,
		            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		            enableKeyEvents  : 'true',
		            hideTrigger:false,
		            //cls:'gridInputCustomStyle',
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            triggerAction: '',
		            forceSelection:true,
					  listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{value}' +
			                    '</div>';
			                }
			            }
				},
		        {
					xtype: 'customcombobox',
					fieldLabel: 'User Name',
					name:'USER_NAME',
					itemId:'user_name',
					store: 'criteriabuilder.userquicksearch.QuickSearchName',
					msgTarget: 'qtip',
					valueField: 'id',
					displayField: 'value',
					queryParam:'name',
					minChars:3,
//					allowBlank: false,
					typeAhead:false,
		            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		            enableKeyEvents  : 'true',
		            hideTrigger:false,
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            triggerAction: '',
		            forceSelection:true,
					  listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{value}' +
			                    '</div>';
			                }
			            }
		        },{
			            xtype: 'customcombobox',
			            fieldLabel: 'User Belongs To',
			            name: 'WHETHER_INTERNAL',
			            itemId:'user_type',
			            editable: false,
			            store: 'user.UserTypeStore',
			            displayField: 'id',
			            valueField: 'value',
			            queryMode:'local'		
			        },{
			            xtype: 'customcombobox',
			            name: 'USER_GROUP',
			            itemId: 'userType',
			            store: 'userGroup.UserGroupStore',
			            fieldLabel: getCommonTranslation('USER_TYPE'),
			            valueField: 'id',
			            displayField: 'userGroupName',
			            typeAhead: false,
			            queryMode : 'local'
			        }]
		    },{xtype: 'fieldcontainer',
			        width: '100%',
			        defaults: {
			            width: 256,
			            labelAlign: 'top'
			        },
			        layout: 'hbox',
			        items: [{
			            xtype: 'nestedJsonCombo',
			            fieldLabel: getCommonTranslation('ROLE'),
			            name: 'USER_ROLE',
			            itemId: 'userRole',
			            store: 'securitysetup.ActiveRolesStore',
			            valueField: 'id',
			            displayField: 'value',
			            forceSelection: true,
			            minChars: 3,
			            //queryParam: 'roleName',
			            hideTrigger:false,
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						triggerAction: '',
			            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			            //	triggerAcation: 'all',
			            listConfig: {
			                listeners: {
			                    beforeshow: function(picker) {
			                        picker.minWidth = picker.up('combobox').getSize().width;
			                    }
			                },
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{value}' +
			                        '</div>';
			                }
			            },
			        },{
			            xtype: 'customcombobox',
			            itemId: 'cmbDepartment',
			            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
			            valueField: 'id',
			            displayField: 'name',
			            name: 'DEPARTMENT',
			            editable: false,
			            triggerAcation: 'all',
			            fourceSelection: true,
			            store:'department.ParentDepartmentByAccesibleStore'
			            /*listeners: {
			                render: function(combo) {
			                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.departmentFilterStore');
			                    combo.bindStore(store);
			                }
			            }*/

			        },{
						xtype:'customcombobox',
						overrideSetValue:false,
						fieldLabel:getCommonTranslation('SUB_DEPARTMENT'),
						name:'SUB_DEPARTMENT',
						itemId : 'getSubDepartmentId',	
						//store: 'department.ChildDepartmentStore',
						valueField: 'id',
						displayField: 'name',
						editable: false,
						disabled:true,
						fourceSelection: true,	
						listeners: {
					            render: function(combo) {
					                var store = Ext.create('Academia.store.department.ChildDepartmentStore');
					                combo.bindStore(store);
					            }
					        }
					},{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('GENDER'), //Gender
						name: 'GENDER',
						itemId: 'gender',
						valueField: 'id',
						displayField: 'value',
						store: 'Academia.store.common.GenderTypeStore',
						//queryMode: 'local',
						editable: false,
					}]
			        },
		    {
		        xtype: 'fieldcontainer',
		        width: '100%',
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
		        layout : 'hbox',
		        items: [{
		            xtype: 'customcombobox',
		            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
		            name: 'ACADEMY_LOCATION_ID',
		            itemId:'academyLocationCombo',
		            editable: false,
		            store: 'user.UserAcademyLocationStore',
		            displayField: 'value',
		            valueField: 'id'
//		            queryMode:'local'		
		        },
		        {
		            xtype: 'checkboxfield',
		            width: 'auto',
		            style: 'margin-top: 25px',
		            labelAlign: 'right',
		            itemId:'users_without_AL',
		            boxLabel: getCommonTranslation('USER_WITHOUT_ACADEMY_LOCATION'),
		            name: 'USER_WITHOUT_AL',
		            inputValue : true
		        },{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            style: 'margin-top: 25px',
		            labelAlign: 'right',
		            itemId:'whether_deleted',
		            boxLabel: 'Deleted Users Only',
		            name: 'WHETHER_DELETED',
		            inputValue : true
		
		        }]
		    }
		    ,{
		    	xtype:'fieldcontainer',
		    	width:'100%',
				cls: 'customSearchPanelBtnsFieldContainerCls',
	    		layout : {
	    			type : 'hbox'
	    		},
		        items: [{
		            xtype: 'button',
		            text: 'Search',
		            itemId: 'searchButtonId',
		            buttonAlign: 'right',
		            ui: 'CustomBtnSubmit',
		            scale: CONSTANTS.BUTTONSIZE,
		            margin: '0 24 0 0'
		            //formBind : true
		        }/*,{
		            xtype: 'button',
		            text: 'Export JRXML',
		            itemId: 'exportJRXMLButtonId',
		            buttonAlign: 'right',
		            ui: 'CustomBtnSubmit',
		            scale: CONSTANTS.BUTTONSIZE
		            //formBind : true
		        }]*//**
		        *Apply reset button for bug 0010070
		        **/
		        , {
		            xtype: 'button',
		            text: getCommonTranslation('CLEAR_SEARCH'),
		            ui: 'CustomBtnCancel', 
		            itemId: 'cancelButtonId',
		            scale: CONSTANTS.BUTTONSIZE,
//		            handler: function() {
//		                this.up('form').getForm().reset();
//		            }
		
		        }]
		    }]
    	}]
    
});