Ext.define('Academia.view.dashboard.RoleMappingForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.rolemappingform',
    requires: ['Ext.ux.form.ItemSelector'],
    autoScroll: true,
    cls:'x-form-fixed-footer-parent',
    items: [{
        xtype: 'form',
        isRemoveToggleButton : true,
        cls: 'customCourseSearchPanelShareFolder',
        layout: {
            type: 'hbox',
            padding:'20px !important',
            marginTop:'20px !important'
        },
        defaults: {
            labelAlign: 'top',
            xtype: 'nestedJsonCombo',
            valueField: 'id',
            displayField: 'value',
            width: 256
        },
        items: [/*{
            fieldLabel: getCommonTranslation('ROLE'),
            name: 'role',
            itemId: 'role',
            //store: 'securitysetup.ActiveRolesStore',
            store : Ext.create('Academia.store.securitysetup.ActiveRolesStore'),
            forceSelection: true,
            allowBlank: false,
            editable: false,
        }*/
        	{  xtype: 'customcombobox',
        		name: 'role',
        		fieldLabel: getCommonTranslation('ROLE'),
        		itemId: 'role',
        		//store : Ext.create('Academia.store.securitysetup.ActiveRolesStore'),
        		store: 'securitysetup.ActiveRolesStore',
        		labelWidth: 80,
        		//queryParam:'roleName',
        		style:{
        			'margin-left':'20px !important'
        		},
        		minChars:3,
        		typeAhead:false,
        		forceSelection:true,
        	    allowBlank: false,
        	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	    enableKeyEvents  : 'true',
        	    hideTrigger:false,
        	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	    triggerAction: '',
        	    listConfig: {
        	    	listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        	        loadingText: getCommonTranslation('SEARCHING'),
        	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	        getInnerTpl: function() {
        	            return '<div class="search-item">' +
        	                '{value}' +
        	            '</div>';
        	        }
        	    }
        	}, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('PORTAL'),
            store: 'securitysetup.PortalStore',
            editable: false,
            queryMode: 'local',
            itemId: 'comboPortal',
            name:'portal'
        }]
    }, {
        xtype: 'fieldcontainer',
        cls: 'roleDashletInnerBorderCls',
        items: [{
    	labelAlign: 'top',
        xtype: 'itemselector',
        cls: 'itemSelectorCls roleDashletInnerBorderCls itemSelectorBorderRoleDashlet',
        itemId: 'dashletsSelector',
        delimiter: null,
        buttons: ['top', 'add', 'remove', 'bottom'],
        fieldLabel: getCommonTranslation('APPLICABLE_DASHLETS')+' : '+'<span style="color:strong;font-weight:bold">'+'Sequencing given in the applicable dashlet will be the sequence of display on dashboard'+'</span>',
        style : {
        	'margin': '20px 10px !important',
	    },
        name: 'dashletsIds',
        store: 'dashboard.DashletStore',
        displayField: 'value',
        disabled: true,
        valueField: 'id',
        msgTarget: 'side',
        width: 650,
        minHeight: 250,
        maxHeight: 450,
        fromTitle: getCommonTranslation('DASHLETS'),
        toTitle: getCommonTranslation('APPLICABLE_DASHLETS'),
        getSubmitData: function() {
            var me = this,
                data = null,
                val;
            if (!me.disabled && me.submitValue && !me.isFileUpload()) {
                val = me.getSubmitValue();
                val = '[' + val + ']';
                val = Ext.decode(val);
                if (val !== null) {
                    data = {};
                    data[me.getName()] = val;
                }
            }
            return data;
        }

    },{
		xtype: 'checkbox',
		name: 'showRemoveHold',
		itemId:'showRemoveHoldId',
		style: 'margin-top: 25px; margin-left: 9px',
		labelAlign: 'left',
		boxLabel: getCommonTranslation('SHOW_DEFAULT'),
		hidden:true,
	}]}, {
        xtype: 'fieldcontainer',
        width:'100%',
        cls:'form-fixed-footer rolemappingformBtnCls',
        items: [{
            xtype: 'button',
            //formBind: true,
            text: getCommonTranslation('SAVE'),
            itemId: 'submitBtn',
            ui: 'CustomBtnSubmit',
            disabled: true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});