Ext.define('Academia.view.dashboard.UserRoleAssociationSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.userroleassociationsearch',
	autoScroll: false,
	cls:'customSearchPanel',
	itemId: 'SearchForm',
	// items: [{
	/* xtype: 'form',
    	cls: 'panelNoSpace',*/

	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 200,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('USER_ID'),
			name:'userId',
			itemId:'userId',
			store: 'criteriabuilder.userquicksearch.QuickSearchCode',
			msgTarget: 'qtip',
			valueField: 'value',
			displayField: 'value',
			queryParam:'code',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            //cls:'gridInputCustomStyle',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},
        {
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('USER_NAME'),
			name:'userName',
			itemId:'userName',
			store: 'criteriabuilder.userquicksearch.QuickSearchName',
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                name: 'academyLocationId',
                itemId:'academyLocationId',
                store: 'common.AcademyLocationNameSeparated',
                displayField: 'value',
                valueField: 'id',
                typeAhead : true,
                forceSelection:true,
                hideTrigger:false,
                triggerAction: 'all',
                queryParam:'qry',
                minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{value}'  +
    	                    '</div>';
    	                }
    	            }
        	}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 200,
				labelAlign: 'top'
			},
			items: [{
				xtype:'nestedJsonCombo',
				fieldLabel:getCommonTranslation('ROLE'),
				name:'userRole',
				itemId:'userRole',
				//store : 'securitysetup.ActiveRolesStore',
				store : Ext.create('Academia.store.securitysetup.ActiveRolesStore'),
				valueField : 'id',
				displayField : 'value',
				editable:false,
				forceSelection :true,
			},{
				xtype:'nestedJsonCombo',
				fieldLabel:getCommonTranslation('DEPARTMENT'),
				name:'userDepartment',
				itemId : 'userDepartmentId',		
				store: 'department.ParentDepartmentStore',
				valueField: 'id',
				displayField: 'name',
				editable: false
			},{
				xtype:'nestedJsonCombo',
				fieldLabel:getCommonTranslation('USER_GROUP'),
				name:'userGroup',
				itemId : 'userGroupId',
				store: 'userGroup.UserGroupStore',
				valueField: 'id',
				displayField: 'userGroupName',
				editable: false,
				queryMode : 'local'
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 200,
				labelAlign: 'top'
			},
			items: [{
                xtype: 'customcombobox',
                name: 'userRoleAssociationStatus',
                itemId: 'userRoleAssociationStatus',
                fieldLabel: getCommonTranslation('STATUS'),
                editable: false,
                queryMode: 'local',
                store:Ext.create('Academia.store.common.StatusComboStore'),
                displayField: 'name',
                valueField: 'value',
//                value:'Active',
			}]
},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getAdmissionTranslation('SEARCH'), //Search
			itemId: 'searchBtnId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CLEAR_SEARCH'),
			itemId: 'resetBtn',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
		//  }]
	}]  
});