/**
 * @author Swapnil.patil
 */

Ext.define('Academia.view.dashboard.dashlets.ApplicationCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.applicationcountdashlet',

	graphView:true,
	layout:'card',
	activeItem: 0, 
	autoScroll:false,
	cls:'AdmissionApplicationCountDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(paramObj){
		var this$=this;
		var view= this.layout.getActiveItem();
		var toolbar;
		var dates;
		if(this.up('dashboardhomepage') == undefined){
			dates={
					startDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].startDate,
					endDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].endDate
			};
			var tempStartDate=new Date(dates.startDate);
			var tempEndDate=new Date(dates.endDate);
			dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}else{
			toolbar = this$.up('dashboardhomepage').down('toolbar');
			//dates=toolbar.down('#dateRangePicker').getValues();
			dates={
					startDate:toolbar.down('#dateRangePicker').startDate,
					endDate:toolbar.down('#dateRangePicker').endDate
			};
			var tempStartDate=new Date(dates.startDate);
			var tempEndDate=new Date(dates.endDate);
			dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}
		if(view.xtype=='griddashlet' || view.xtype=='stackbarchartdashlet'){
			var store= view.getStore();
			var extraparams;
			if(paramObj !=undefined){
				extraparams=paramObj;
			}else{
				extraparams=this$.getParams();
			}
			
			if(this$.getParams()!=undefined){
				extraparams['intakeYearId']=this$.getParams().intakeYearId;
				extraparams['locationId']=this$.getParams().locationId;
				extraparams['academyId']=this$.getParams().academyId;
				extraparams['programId']=this$.getParams().programId;
				extraparams['batchId']=this$.getParams().batchId;
				extraparams['seatTypeId']=this$.getParams().seatTypeId;
			}
			switch (view.itemId) {
			case 'programCategoryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramCategoryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					programCategoryId:extraparams.programCategoryId,
			};
				break;
			case 'programBatchViaCategoryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					allCurrentStatus:extraparams.allCurrentStatus,
					programCategoryId:extraparams.programCategoryId,
			};
				break;
			case 'viaProgramCategoryApplicationList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					programCategoryId:extraparams.programCategoryId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programGroupItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramGroupItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					programGroupId:extraparams.programGroupId,
			};
				break;
			case 'programBatchViaGroupItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					allCurrentStatus:extraparams.allCurrentStatus,
					acadmyLocationId:extraparams.acadmyLocationId,
					programGroupId:extraparams.programGroupId,
			};
				break;
			case 'viaProgramGroupApplicationList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					programGroupId:extraparams.programGroupId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programBatchItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramBatchItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programCategoryItemGender':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramCategoryItemGender':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					programCategoryId:extraparams.programCategoryId,
			};
				break;
			case 'programBatchGenderViaCategoryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					allCurrentStatus:extraparams.allCurrentStatus,
					programCategoryId:extraparams.programCategoryId,
			};
				break;
			case 'viaProgramCategoryGenderApplicationList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					programCategoryId:extraparams.programCategoryId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programGroupGenderItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramGroupGenderItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					programGroupId:extraparams.programGroupId,
			};
				break;
			case 'programBatchGenderViaGroupItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					allCurrentStatus:extraparams.allCurrentStatus,
					acadmyLocationId:extraparams.acadmyLocationId,
					programGroupId:extraparams.programGroupId,
			};
				break;
			case 'viaProgramGroupGenderApplicationList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					programGroupId:extraparams.programGroupId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programBatchGenderItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'byProgramBatchGenderItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					genderCSM:extraparams.genderCSM,
					genderId:extraparams.genderId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			}
			this$.resetPageSetting(store);
			store.getProxy().extraParams = {
				intakeYearId: this$.getParams().intakeYearId,
				startDate:dates.startDate,
				endDate:dates.endDate,
				sort : ''
				};	
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(30);
					}
				}
			});
		}else{
			if(view.xtype=='image'){
				this.layout.setActiveItem(0);
				var view1=this.layout.getActiveItem();
				var store= view1.getStore();
				var extraparams=this$.getParams();
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(30);
						}
					}
				});
			}
		}

	},
	defaults: {
		cls:'panelNoSpace'
	},
	items:[{
		xtype:'griddashlet',
		itemId:'programCategoryItem',
		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_CATEGORY,
		addPagingToolbar : true,
		columns : [/*{
		hidden: true,
		dataIndex: 'id'
	},*/{
		text : getCommonTranslation('PROGRAM_CATEGORY'),
		dataIndex : 'programCategoryName',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('SUBMITTED'),
		dataIndex : 'submittedCount',
		sortable : true,
		//tpl: '<a>{count}</a>',
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('APROVED'),
		dataIndex : 'approvedCount',
		sortable : true,
		//tpl: '<a>{count}</a>',
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('REJECTED'),
		dataIndex : 'rejectedCount',
		sortable : true,
		//tpl: '<a>{count}</a>',
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('DIRECT_ADMISSION'),
		dataIndex : 'directAdmissionCount',
		sortable : true,
		//tpl: '<a>{count}</a>',
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('TOTAL_APPLICATION'),
		dataIndex : 'totalApplications',
		sortable : true,		
		flex:0.1
	}],
	listeners:{
		activate:function(portlet){
			var applicationcountdashlet=portlet.up('applicationcountdashlet');
			applicationcountdashlet.activeTab = 1;
			applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
			applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
			applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
		},
		deactivate:function(portlet){
			var applicationcountdashlet=portlet.up('applicationcountdashlet');
			applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
			applicationcountdashlet.removeProgramGroup();
			applicationcountdashlet.removeProgramBatch();
			applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.removeExportToPdf();
			applicationcountdashlet.removeExportToExcel();
		},
		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
			if(e.target.tagName == 'A'){
				var applicationCountGrid = cell.up('grid');
				var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
				if(columnName == 'programCategoryName'){
					var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
					var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
					applicationcountdashlet.getLayout().setActiveItem(18);
					applicationcountdashlet.params={
							programCategoryId:selectedRecord.data.programCategoryId,
							allCurrentStatus:true
					};
					var paramsObj={
							programCategoryId:selectedRecord.data.programCategoryId,
							allCurrentStatus:true
					};
					applicationcountdashlet.loadDashlet(paramsObj);
				}else{
					if(columnName == 'submittedCount') {
						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
						applicationcountdashlet.getLayout().setActiveItem(12);
						applicationcountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'SUBMITTED'
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'SUBMITTED'
						};
						applicationcountdashlet.down('#emailIdItem').setVisible(true);
						applicationcountdashlet.down('#programStatusItemId').setVisible(false);
						applicationcountdashlet.down('#reasonItemId').setVisible(false);
						applicationcountdashlet.down('#admissionStatusItemId').setVisible(false);
						applicationcountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'approvedCount'){
							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
							applicationcountdashlet.getLayout().setActiveItem(12);
							applicationcountdashlet.params={
									programCategoryId:selectedRecord.data.programCategoryId,
									status:'APPROVED'
							};
							var paramsObj={
									programCategoryId:selectedRecord.data.programCategoryId,
									status:'APPROVED'
							};
							applicationcountdashlet.down('#emailIdItem').setVisible(false);
							applicationcountdashlet.down('#programStatusItemId').setVisible(true);
							applicationcountdashlet.down('#reasonItemId').setVisible(false);
							applicationcountdashlet.down('#admissionStatusItemId').setVisible(false);
							applicationcountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'rejectedCount'){
								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
								applicationcountdashlet.getLayout().setActiveItem(12);
								applicationcountdashlet.params={
										programCategoryId:selectedRecord.data.programCategoryId,
										status:'REJECTED'
								};
								var paramsObj={
										programCategoryId:selectedRecord.data.programCategoryId,
										status:'REJECTED'
								};
								applicationcountdashlet.down('#emailIdItem').setVisible(false);
								applicationcountdashlet.down('#programStatusItemId').setVisible(false);
								applicationcountdashlet.down('#reasonItemId').setVisible(true);
								applicationcountdashlet.down('#admissionStatusItemId').setVisible(false);
								applicationcountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'directAdmissionCount'){
									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
									applicationcountdashlet.getLayout().setActiveItem(12);
									applicationcountdashlet.params={
											programCategoryId:selectedRecord.data.programCategoryId,
											status:'DIRECT_ADMISSION'
									};
									var paramsObj={
											programCategoryId:selectedRecord.data.programCategoryId,
											status:'DIRECT_ADMISSION'
									};	
									applicationcountdashlet.down('#emailIdItem').setVisible(false);
									applicationcountdashlet.down('#programStatusItemId').setVisible(false);
									applicationcountdashlet.down('#reasonItemId').setVisible(false);
									applicationcountdashlet.down('#admissionStatusItemId').setVisible(true);
									applicationcountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
				}
				applicationCountGrid.getSelectionModel().deselectAll();
			}
		}
	}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
		yAxesCategoryField : ['programCategoryName'],
		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
		yAxesCategoryTitle :getCommonTranslation('PROGRAM_CATEGORY'),
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_CATEGORY,
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 0;
				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramGroup();
				applicationcountdashlet.removeProgramBatch();
				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPng();
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programGroupItem',
		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_GROUP,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'programGroupId'
		},*/{
			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('PROGRAM_GROUP'),
			dataIndex : 'programGroupName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SUBMITTED'),
			dataIndex : 'submittedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('APROVED'),
			dataIndex : 'approvedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('REJECTED'),
			dataIndex : 'rejectedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('DIRECT_ADMISSION'),
			dataIndex : 'directAdmissionCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_APPLICATION'),
			dataIndex : 'totalApplications',
			sortable : true,		
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 3;
				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramCategory();
				applicationcountdashlet.removeProgramBatch();
				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPdf();
				applicationcountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var applicationCountGrid = cell.up('grid');
					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
					if(columnName == 'programGroupName'){
						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
						applicationcountdashlet.getLayout().setActiveItem(21);
						applicationcountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								programGroupId:selectedRecord.data.programGroupId,
								allCurrentStatus:true
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								programGroupId:selectedRecord.data.programGroupId,
								allCurrentStatus:true	
						};
						applicationcountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'submittedCount') {
							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
							applicationcountdashlet.getLayout().setActiveItem(13);
							applicationcountdashlet.params={
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									programGroupId:selectedRecord.data.programGroupId,
									status:'SUBMITTED'
							};
							var paramsObj={
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									programGroupId:selectedRecord.data.programGroupId,
									status:'SUBMITTED'
							};
							applicationcountdashlet.down('#emailIdItem2').setVisible(true);
							applicationcountdashlet.down('#programStatusItemId2').setVisible(false);
							applicationcountdashlet.down('#reasonItemId2').setVisible(false);
							applicationcountdashlet.down('#admissionStatusItemId2').setVisible(false);
							applicationcountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'approvedCount'){
								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
								applicationcountdashlet.getLayout().setActiveItem(13);
								applicationcountdashlet.params={
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										programGroupId:selectedRecord.data.programGroupId,
										status:'APPROVED'
								};
								var paramsObj={
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										programGroupId:selectedRecord.data.programGroupId,
										status:'APPROVED'
								};
								applicationcountdashlet.down('#emailIdItem2').setVisible(false);
								applicationcountdashlet.down('#programStatusItemId2').setVisible(true);
								applicationcountdashlet.down('#reasonItemId2').setVisible(false);
								applicationcountdashlet.down('#admissionStatusItemId2').setVisible(false);
								applicationcountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'rejectedCount'){
									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
									applicationcountdashlet.getLayout().setActiveItem(13);
									applicationcountdashlet.params={
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											programGroupId:selectedRecord.data.programGroupId,
											status:'REJECTED'
									};
									var paramsObj={
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											programGroupId:selectedRecord.data.programGroupId,
											status:'REJECTED'
									};
									applicationcountdashlet.down('#emailIdItem2').setVisible(false);
									applicationcountdashlet.down('#programStatusItemId2').setVisible(false);
									applicationcountdashlet.down('#reasonItemId2').setVisible(true);
									applicationcountdashlet.down('#admissionStatusItemId2').setVisible(false);
									applicationcountdashlet.loadDashlet(paramsObj);
								}else{
									if(columnName == 'directAdmissionCount'){
										var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
										var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
										applicationcountdashlet.getLayout().setActiveItem(13);
										applicationcountdashlet.params={
												acadmyLocationId:selectedRecord.data.acadmyLocationId,
												programGroupId:selectedRecord.data.programGroupId,
												status:'DIRECT_ADMISSION'
										};
										var paramsObj={
												acadmyLocationId:selectedRecord.data.acadmyLocationId,
												programGroupId:selectedRecord.data.programGroupId,
												status:'DIRECT_ADMISSION'
										};		
										applicationcountdashlet.down('#emailIdItem2').setVisible(false);
										applicationcountdashlet.down('#programStatusItemId2').setVisible(false);
										applicationcountdashlet.down('#reasonItemId2').setVisible(false);
										applicationcountdashlet.down('#admissionStatusItemId2').setVisible(true);
										applicationcountdashlet.loadDashlet(paramsObj);

									}
								}
							}
						}
					}
					applicationCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
		yAxesCategoryField : ['acadmyProgramGroupkey'],
		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
		yAxesCategoryTitle :'',
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_GROUP,
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 2;
				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramCategory();
				applicationcountdashlet.removeProgramBatch();
				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programBatchItem',
		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'programId'
		},*/{
			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('SUBMITTED'),
			dataIndex : 'submittedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('APROVED'),
			dataIndex : 'approvedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('REJECTED'),
			dataIndex : 'rejectedCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('DIRECT_ADMISSION'),
			dataIndex : 'directAdmissionCount',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_APPLICATION'),
			dataIndex : 'totalApplications',
			sortable : true,		
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 5;
				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramCategory();
				applicationcountdashlet.removeProgramGroup();
				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPdf();
				applicationcountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var applicationCountGrid = cell.up('grid');
					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
					if(columnName == 'submittedCount') {
						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
						applicationcountdashlet.getLayout().setActiveItem(14);
						applicationcountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								status:'SUBMITTED'
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								status:'SUBMITTED'
						};
						applicationcountdashlet.down('#emailIdItem3').setVisible(true);
						applicationcountdashlet.down('#programStatusItemId3').setVisible(false);
						applicationcountdashlet.down('#reasonItemId3').setVisible(false);
						applicationcountdashlet.down('#admissionStatusItemId3').setVisible(false);
						applicationCountGrid.getSelectionModel().deselectAll();
						applicationcountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'approvedCount'){
							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
							applicationcountdashlet.getLayout().setActiveItem(14);
							applicationcountdashlet.params={
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									status:'APPROVED'
							};
							var paramsObj={
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									status:'APPROVED'
							};
							applicationcountdashlet.down('#emailIdItem3').setVisible(false);
							applicationcountdashlet.down('#programStatusItemId3').setVisible(true);
							applicationcountdashlet.down('#reasonItemId3').setVisible(false);
							applicationcountdashlet.down('#admissionStatusItemId3').setVisible(false);
							applicationCountGrid.getSelectionModel().deselectAll();
							applicationcountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'rejectedCount'){
								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
								applicationcountdashlet.getLayout().setActiveItem(14);
								applicationcountdashlet.params={
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										status:'REJECTED'
								};
								var paramsObj={
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										status:'REJECTED'
								};
								applicationcountdashlet.down('#emailIdItem3').setVisible(false);
								applicationcountdashlet.down('#programStatusItemId3').setVisible(false);
								applicationcountdashlet.down('#reasonItemId3').setVisible(true);
								applicationcountdashlet.down('#admissionStatusItemId3').setVisible(false);
								applicationCountGrid.getSelectionModel().deselectAll();
								applicationcountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'directAdmissionCount'){
									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
									applicationcountdashlet.getLayout().setActiveItem(14);
									applicationcountdashlet.params={
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											program1Id:selectedRecord.data.programId,
											batch1Id:selectedRecord.data.batchId,
											status:'DIRECT_ADMISSION'
									};
									var paramsObj={
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											program1Id:selectedRecord.data.programId,
											batch1Id:selectedRecord.data.batchId,
											status:'DIRECT_ADMISSION'
									};		
									applicationcountdashlet.down('#emailIdItem3').setVisible(false);
									applicationcountdashlet.down('#programStatusItemId3').setVisible(false);
									applicationcountdashlet.down('#reasonItemId3').setVisible(false);
									applicationcountdashlet.down('#admissionStatusItemId3').setVisible(true);
									applicationCountGrid.getSelectionModel().deselectAll();
									applicationcountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
		yAxesCategoryField : ['acadmyProgramBatchKey'],
		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
		yAxesCategoryTitle :'',
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 4;
				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramCategory();
				applicationcountdashlet.removeProgramGroup();
				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programCategoryItemGender',
		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_CATEGORY_GENDER_WISE,
		addPagingToolbar : true,
		columns : [/*{
		hidden: true,
		dataIndex: 'id'
	},*/ {
		text : getCommonTranslation('PROGRAM_CATEGORY'),
		dataIndex : 'programCategoryName',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('GENDER'),
		dataIndex : 'genderCSM',
		sortable : true,
		flex:0.1,
		renderer: function(value) {
			return value=getCommonTranslation(value);
		}
	},{
		text : getCommonTranslation('SUBMITTED'),
		dataIndex : 'submittedCount',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('APROVED'),
		dataIndex : 'approvedCount',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('REJECTED'),
		dataIndex : 'rejectedCount',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('DIRECT_ADMISSION'),
		dataIndex : 'directAdmissionCount',
		sortable : true,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value="<a href='#'>"+value+"</a>";
			}else{
				return "-";
			}
		},
		flex:0.1
	},{
		text : getCommonTranslation('TOTAL_APPLICATION'),
		dataIndex : 'totalApplications',
		sortable : true,		
		flex:0.1
	}],
	listeners:{
		activate:function(portlet){
			var applicationcountdashlet=portlet.up('applicationcountdashlet');
			applicationcountdashlet.activeTab = 7;
			applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
			applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
			applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
		},
		deactivate:function(portlet){
			var applicationcountdashlet=portlet.up('applicationcountdashlet');
			applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
			applicationcountdashlet.removeProgramCategory(applicationcountdashlet,portlet);
			applicationcountdashlet.removeProgramGroup();
			applicationcountdashlet.removeProgramBatch();
			applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
			applicationcountdashlet.removeExportToPdf();
			applicationcountdashlet.removeExportToExcel();
		},
		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
			if(e.target.tagName == 'A'){
				var applicationCountGrid = cell.up('grid');
				var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
				if(columnName == 'programCategoryName'){
					var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
					var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
					applicationcountdashlet.getLayout().setActiveItem(24);
					applicationcountdashlet.params={
							programCategoryId:selectedRecord.data.programCategoryId,
							genderCSM:selectedRecord.data.genderCSM,
							genderId:selectedRecord.data.genderId,
							allCurrentStatus:true
					};
					var paramsObj={
							programCategoryId:selectedRecord.data.programCategoryId,
							genderCSM:selectedRecord.data.genderCSM,
							genderId:selectedRecord.data.genderId,
							allCurrentStatus:true
					};
					applicationCountGrid.getSelectionModel().deselectAll();
					applicationcountdashlet.loadDashlet(paramsObj);
				}else{
					if(columnName == 'submittedCount') {
						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
						applicationcountdashlet.getLayout().setActiveItem(15);
						applicationcountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM:selectedRecord.data.genderCSM,
								genderId:selectedRecord.data.genderId,
								status:'SUBMITTED'
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM:selectedRecord.data.genderCSM,
								genderId:selectedRecord.data.genderId,
								status:'SUBMITTED'
						};
						applicationcountdashlet.down('#emailIdItem4').setVisible(true);
						applicationcountdashlet.down('#programStatusItemId4').setVisible(false);
						applicationcountdashlet.down('#reasonItemId4').setVisible(false);
						applicationcountdashlet.down('#admissionStatusItemId4').setVisible(false);
						applicationCountGrid.getSelectionModel().deselectAll();
						applicationcountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'approvedCount'){
							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
							applicationcountdashlet.getLayout().setActiveItem(15);
							applicationcountdashlet.params={
									programCategoryId:selectedRecord.data.programCategoryId,
									genderCSM:selectedRecord.data.genderCSM,
									genderId:selectedRecord.data.genderId,
									status:'APPROVED'
							};
							var paramsObj={
									programCategoryId:selectedRecord.data.programCategoryId,
									genderCSM:selectedRecord.data.genderCSM,
									genderId:selectedRecord.data.genderId,
									status:'APPROVED'
							};
							applicationcountdashlet.down('#emailIdItem4').setVisible(false);
							applicationcountdashlet.down('#programStatusItemId4').setVisible(true);
							applicationcountdashlet.down('#reasonItemId4').setVisible(false);
							applicationcountdashlet.down('#admissionStatusItemId4').setVisible(false);
							applicationCountGrid.getSelectionModel().deselectAll();
							applicationcountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'rejectedCount'){
								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
								applicationcountdashlet.getLayout().setActiveItem(15);
								applicationcountdashlet.params={
										programCategoryId:selectedRecord.data.programCategoryId,
										genderCSM:selectedRecord.data.genderCSM,
										genderId:selectedRecord.data.genderId,
										status:'REJECTED'
								};
								var paramsObj={
										programCategoryId:selectedRecord.data.programCategoryId,
										genderCSM:selectedRecord.data.genderCSM,
										genderId:selectedRecord.data.genderId,
										status:'REJECTED'
								};
								applicationcountdashlet.down('#emailIdItem4').setVisible(false);
								applicationcountdashlet.down('#programStatusItemId4').setVisible(false);
								applicationcountdashlet.down('#reasonItemId4').setVisible(true);
								applicationcountdashlet.down('#admissionStatusItemId4').setVisible(false);
								applicationCountGrid.getSelectionModel().deselectAll();
								applicationcountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'directAdmissionCount'){
									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
									applicationcountdashlet.getLayout().setActiveItem(15);
									applicationcountdashlet.params={
											programCategoryId:selectedRecord.data.programCategoryId,
											genderCSM:selectedRecord.data.genderCSM,
											genderId:selectedRecord.data.genderId,
											status:'DIRECT_ADMISSION'
									};
									var paramsObj={
											programCategoryId:selectedRecord.data.programCategoryId,
											genderCSM:selectedRecord.data.genderCSM,
											genderId:selectedRecord.data.genderId,
											status:'DIRECT_ADMISSION'
									};	
									applicationcountdashlet.down('#emailIdItem4').setVisible(false);
									applicationcountdashlet.down('#programStatusItemId4').setVisible(false);
									applicationcountdashlet.down('#reasonItemId4').setVisible(false);
									applicationcountdashlet.down('#admissionStatusItemId4').setVisible(true);
									applicationCountGrid.getSelectionModel().deselectAll();
									applicationcountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
				}
			}
		}
	}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
		yAxesCategoryField : ['programCategoryGenderKey'],
		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
		yAxesCategoryTitle :'',
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_CATEGORY_GENDER_WISE,
		listeners:{
			activate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.activeTab = 6;
				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
			},
			deactivate:function(portlet){
				var applicationcountdashlet=portlet.up('applicationcountdashlet');
				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
				applicationcountdashlet.removeProgramCategory(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramGroup();
				applicationcountdashlet.removeProgramBatch();
				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
				applicationcountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programGroupGenderItem',
		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
		url : SERVERURL.COUNT_APPLICATION_PROGRAM_GROUP_GENDER_WISE,
		addPagingToolbar : true,
		columns : [/*{
    		hidden: true,
    		dataIndex: 'id'
    	},*/ {
    		text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    		dataIndex : 'academyLocationName',
    		sortable : true,
    		flex:0.1
    	},{
    		text : getCommonTranslation('PROGRAM_GROUP'),
    		dataIndex : 'programGroupName',
    		sortable : true,
    		renderer: function(value) {
    			if(!isNullOrEmpty(value)){
    				return value="<a href='#'>"+value+"</a>";
    			}else{
    				return "-";
    			}
    		},
    		flex:0.1
    	},{
    		text : getCommonTranslation('GENDER'),
    		dataIndex : 'genderCSM',
    		sortable : true,
    		flex:0.1,
    		renderer: function(value) {
    			return value=getCommonTranslation(value);
    		}
    	},{
    		text : getCommonTranslation('SUBMITTED'),
    		dataIndex : 'submittedCount',
    		sortable : true,
    		renderer: function(value) {
    			if(!isNullOrEmpty(value)){
    				return value="<a href='#'>"+value+"</a>";
    			}else{
    				return "-";
    			}
    		},
    		flex:0.1
    	},{
    		text : getCommonTranslation('APROVED'),
    		dataIndex : 'approvedCount',
    		sortable : true,
    		renderer: function(value) {
    			if(!isNullOrEmpty(value)){
    				return value="<a href='#'>"+value+"</a>";
    			}else{
    				return "-";
    			}
    		},
    		flex:0.1
    	},{
    		text : getCommonTranslation('REJECTED'),
    		dataIndex : 'rejectedCount',
    		sortable : true,
    		renderer: function(value) {
    			if(!isNullOrEmpty(value)){
    				return value="<a href='#'>"+value+"</a>";
    			}else{
    				return "-";
    			}
    		},
    		flex:0.1
    	},{
    		text : getCommonTranslation('DIRECT_ADMISSION'),
    		dataIndex : 'directAdmissionCount',
    		sortable : true,
    		renderer: function(value) {
    			if(!isNullOrEmpty(value)){
    				return value="<a href='#'>"+value+"</a>";
    			}else{
    				return "-";
    			}
    		},
    		flex:0.1
    	},{
    		text : getCommonTranslation('TOTAL_APPLICATION'),
    		dataIndex : 'totalApplications',
    		sortable : true,		
    		flex:0.1
    	}],
    	listeners:{
    		activate:function(portlet){
    			var applicationcountdashlet=portlet.up('applicationcountdashlet');
    			applicationcountdashlet.activeTab = 9;
    			applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    			applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
    			applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
    			applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
    			applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
    			applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
    			applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    			applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    		},
    		deactivate:function(portlet){
    			var applicationcountdashlet=portlet.up('applicationcountdashlet');
    			applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    			applicationcountdashlet.removeProgramCategory();
    			applicationcountdashlet.removeProgramGroup(applicationcountdashlet,portlet);
    			applicationcountdashlet.removeProgramBatch();
    			applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    			applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    			applicationcountdashlet.removeExportToPdf();
    			applicationcountdashlet.removeExportToExcel();
    		},
    		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    			if(e.target.tagName == 'A'){
    				var applicationCountGrid = cell.up('grid');
    				var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    				if(columnName == 'programGroupName'){
    					var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    					var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    					applicationcountdashlet.getLayout().setActiveItem(27);
    					applicationcountdashlet.params={
    							acadmyLocationId:selectedRecord.data.acadmyLocationId,
    							programGroupId:selectedRecord.data.programGroupId,
    							genderCSM:selectedRecord.data.genderCSM,
    							genderId:selectedRecord.data.genderId,
    							allCurrentStatus:true
    					};
    					var paramsObj={
    							acadmyLocationId:selectedRecord.data.acadmyLocationId,
    							programGroupId:selectedRecord.data.programGroupId,
    							genderCSM:selectedRecord.data.genderCSM,
    							genderId:selectedRecord.data.genderId,
    							allCurrentStatus:true
    					};
    					applicationCountGrid.getSelectionModel().deselectAll();
    					applicationcountdashlet.loadDashlet(paramsObj);
    				}else{
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(16);
    						applicationcountdashlet.params={
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								programGroupId:selectedRecord.data.programGroupId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								programGroupId:selectedRecord.data.programGroupId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem5').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId5').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId5').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId5').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(16);
    							applicationcountdashlet.params={
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									programGroupId:selectedRecord.data.programGroupId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									programGroupId:selectedRecord.data.programGroupId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem5').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId5').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId5').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId5').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(16);
    								applicationcountdashlet.params={
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										programGroupId:selectedRecord.data.programGroupId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										programGroupId:selectedRecord.data.programGroupId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem5').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId5').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId5').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId5').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(16);
    									applicationcountdashlet.params={
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											programGroupId:selectedRecord.data.programGroupId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											programGroupId:selectedRecord.data.programGroupId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
    									};	
    									applicationcountdashlet.down('#emailIdItem5').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId5').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId5').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId5').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}
    	}},
    	{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
    		yAxesCategoryField : ['acadmyProgramGroupGenderkey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_GROUP_GENDER_WISE,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 8;
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}
    	},{
    		xtype:'griddashlet',
    		itemId:'programBatchGenderItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'programId'
    		},*/{
    			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('SUBMITTED'),
    			dataIndex : 'submittedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('APROVED'),
    			dataIndex : 'approvedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('REJECTED'),
    			dataIndex : 'rejectedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('DIRECT_ADMISSION'),
    			dataIndex : 'directAdmissionCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('TOTAL_APPLICATION'),
    			dataIndex : 'totalApplications',
    			sortable : true,		
    			flex:0.1
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 11;
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				if(e.target.tagName == 'A'){
    					var applicationCountGrid = cell.up('grid');
    					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(17);
    						applicationcountdashlet.params={
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem6').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId6').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId6').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId6').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(17);
    							applicationcountdashlet.params={
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem6').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId6').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId6').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId6').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(17);
    								applicationcountdashlet.params={
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem6').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId6').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId6').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId6').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(17);
    									applicationcountdashlet.params={
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
    									};	
    									applicationcountdashlet.down('#emailIdItem6').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId6').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId6').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId6').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}
    	},{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount','totalApplications'],
    		yAxesCategoryField : ['acadmyProgramBatchGenderKey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 10;
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}
    	},{
    		xtype:'griddashlet',
    		itemId:'byProgramCategoryItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		},*/ {
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 12;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(0);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'byProgramGroupItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		},*/ {
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem2',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId2',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId2',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId2',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 13;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(2);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'byProgramBatchItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem3',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId3',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId3',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId3',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 14;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(4);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'byProgramCategoryItemGender',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem4',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId4',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId4',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId4',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 15;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(6);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		item:'byProgramGroupGenderItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		},*/ {
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem5',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId5',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId5',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId5',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 16;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(8);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'byProgramBatchGenderItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem6',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId6',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId6',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId6',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 17;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    					type: 'prev',
    					handler: function(btn, target, header, tool){
    						header.ownerCt.getLayout().setActiveItem(10);
    						header.remove(tool);
    						applicationcountdashlet.params={};
    						// reset the page param after going previous page
    						var itemStore = applicationcountdashlet.items.get(2).getStore();
    						itemStore.currentPage = 1;
    						applicationcountdashlet.loadDashlet();
    					}
    				}));
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'programBatchViaCategoryItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'programId'
    		},*/{
    			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SUBMITTED'),
    			dataIndex : 'submittedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('APROVED'),
    			dataIndex : 'approvedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('REJECTED'),
    			dataIndex : 'rejectedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('DIRECT_ADMISSION'),
    			dataIndex : 'directAdmissionCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('TOTAL_APPLICATION'),
    			dataIndex : 'totalApplications',
    			sortable : true,		
    			flex:0.1
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var tabCheck=applicationcountdashlet.activeTab;
    				applicationcountdashlet.activeTab = 19;
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				if(tabCheck !=18){
    					applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    						type: 'prev',
    						itemId:'proCategoryLevel',
    						handler: function(btn, target, header, tool){
    							header.remove(tool);
    							if(applicationcountdashlet.activeTab==20){
    								var cgId=applicationcountdashlet.params.programCategoryId;
    								header.ownerCt.getLayout().setActiveItem(18);
    								applicationcountdashlet.params={
    										programCategoryId:cgId,
    										allCurrentStatus:true
    								}
    							}else{
    								header.ownerCt.getLayout().setActiveItem(0);
    								header.remove(tool);
    								//applicationcountdashlet.doLayout();
    							}
    							// reset the page param after going previous page
    							var itemStore = applicationcountdashlet.items.get(2).getStore();
    							itemStore.currentPage = 1;
    							applicationcountdashlet.loadDashlet();
    						}
    					}));}
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				if(e.target.tagName == 'A'){
    					var applicationCountGrid = cell.up('grid');
    					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(20);
    						applicationcountdashlet.params={
    								programCategoryId:selectedRecord.data.programCategoryId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								programCategoryId:selectedRecord.data.programCategoryId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem7').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId7').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId7').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId7').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(20);
    							applicationcountdashlet.params={
    									programCategoryId:selectedRecord.data.programCategoryId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									programCategoryId:selectedRecord.data.programCategoryId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem7').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId7').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId7').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId7').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(20);
    								applicationcountdashlet.params={
    										programCategoryId:selectedRecord.data.programCategoryId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										programCategoryId:selectedRecord.data.programCategoryId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem7').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId7').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId7').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId7').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(20);
    									applicationcountdashlet.params={
    											programCategoryId:selectedRecord.data.programCategoryId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											programCategoryId:selectedRecord.data.programCategoryId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											status:'DIRECT_ADMISSION'
    									};		
    									applicationcountdashlet.down('#emailIdItem7').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId7').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId7').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId7').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}

    	},{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount'],
    		yAxesCategoryField : ['acadmyProgramBatchKey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var id=applicationcountdashlet.params.programCategoryId;
    				var status=applicationcountdashlet.params.allCurrentStatus;
    				applicationcountdashlet.activeTab = 18;
    				var store=applicationcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					programCategoryId:id,
    					allCurrentStatus:status
    				};
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'viaProgramCategoryApplicationList',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem7',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId7',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId7',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId7',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 20;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}
    	},
    	{
    		xtype:'griddashlet',
    		itemId:'programBatchViaGroupItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'programId'
    		},*/{
    			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SUBMITTED'),
    			dataIndex : 'submittedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('APROVED'),
    			dataIndex : 'approvedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('REJECTED'),
    			dataIndex : 'rejectedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('DIRECT_ADMISSION'),
    			dataIndex : 'directAdmissionCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('TOTAL_APPLICATION'),
    			dataIndex : 'totalApplications',
    			sortable : true,		
    			flex:0.1
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var tabCheck=applicationcountdashlet.activeTab;
    				applicationcountdashlet.activeTab = 22;
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				if(tabCheck !=21){
    					applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    						type: 'prev',
    						itemId:'programGroupLevel',
    						handler: function(btn, target, header, tool){
    							header.remove(tool);
    							if(applicationcountdashlet.activeTab==23){
    								var pgId=applicationcountdashlet.params.programGroupId;
    								var acadmyId=applicationcountdashlet.params.acadmyLocationId
    								header.ownerCt.getLayout().setActiveItem(21);
    								applicationcountdashlet.params={
    										programGroupId:pgId,
    										acadmyLocationId:acadmyId,
    										allCurrentStatus:true
    								};
    							}else{
    								header.ownerCt.getLayout().setActiveItem(2);
    								header.remove(tool);
    								applicationcountdashlet.doLayout();
    							}
    							//applicationcountdashlet.params={};
    							// reset the page param after going previous page
    							var itemStore = applicationcountdashlet.items.get(2).getStore();
    							itemStore.currentPage = 1;
    							applicationcountdashlet.loadDashlet();
    						}
    					}));}
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				if(e.target.tagName == 'A'){
    					var applicationCountGrid = cell.up('grid');
    					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(23);
    						applicationcountdashlet.params={
    								programGroupId:selectedRecord.data.programGroupId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								programGroupId:selectedRecord.data.programGroupId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem8').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId8').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId8').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId8').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(23);
    							applicationcountdashlet.params={
    									programGroupId:selectedRecord.data.programGroupId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									programGroupId:selectedRecord.data.programGroupId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem8').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId8').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId8').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId8').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(23);
    								applicationcountdashlet.params={
    										programGroupId:selectedRecord.data.programGroupId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										programGroupId:selectedRecord.data.programGroupId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem8').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId8').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId8').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId8').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(23);
    									applicationcountdashlet.params={
    											programGroupId:selectedRecord.data.programGroupId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											programGroupId:selectedRecord.data.programGroupId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											status:'DIRECT_ADMISSION'
    									};		
    									applicationcountdashlet.down('#emailIdItem8').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId8').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId8').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId8').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}

    	},{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount'],
    		yAxesCategoryField : ['acadmyProgramBatchKey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var id=applicationcountdashlet.params.programGroupId;
    				var acdmyId=applicationcountdashlet.params.acadmyLocationId;
    				var status=applicationcountdashlet.params.allCurrentStatus
    				applicationcountdashlet.activeTab = 21;
    				var store=applicationcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					programGroupId:id,
    					acadmyLocationId:acdmyId,
    					allCurrentStatus:status
    				};
    				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'viaProgramGroupApplicationList',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem8',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId8',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId8',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId8',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 23;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}
    	},
    	{
    		xtype:'griddashlet',
    		itemId:'programBatchGenderViaCategoryItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'programId'
    		},*/{
    			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},
    		{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},
    		{
    			text : getCommonTranslation('SUBMITTED'),
    			dataIndex : 'submittedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('APROVED'),
    			dataIndex : 'approvedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('REJECTED'),
    			dataIndex : 'rejectedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('DIRECT_ADMISSION'),
    			dataIndex : 'directAdmissionCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('TOTAL_APPLICATION'),
    			dataIndex : 'totalApplications',
    			sortable : true,		
    			flex:0.1
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var tabCheck=applicationcountdashlet.activeTab;
    				applicationcountdashlet.activeTab = 25;
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				if(tabCheck !=24){
    					applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    						type: 'prev',
    						itemId:'categoryGenderLevel',
    						handler: function(btn, target, header, tool){
    							header.remove(tool);
    							if(applicationcountdashlet.activeTab==26){
    								var genderCSM=applicationcountdashlet.params.genderCSM;
    								var genderId=applicationcountdashlet.params.genderId;
    								var cgId=applicationcountdashlet.params.programCategoryId;
    								header.ownerCt.getLayout().setActiveItem(24);
    								applicationcountdashlet.params={
    										genderCSM:genderCSM,
    										genderId:genderId,
    										programCategoryId:cgId,
    										allCurrentStatus:true
    								}
    							}else{
    								header.ownerCt.getLayout().setActiveItem(6);
    								header.remove(tool);
    								applicationcountdashlet.doLayout();
    							}
    							//applicationcountdashlet.params={};
    							// reset the page param after going previous page
    							var itemStore = applicationcountdashlet.items.get(2).getStore();
    							itemStore.currentPage = 1;
    							applicationcountdashlet.loadDashlet();
    						}
    					}));}
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				if(e.target.tagName == 'A'){
    					var applicationCountGrid = cell.up('grid');
    					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(26);
    						applicationcountdashlet.params={
    								programCategoryId:selectedRecord.data.programCategoryId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								programCategoryId:selectedRecord.data.programCategoryId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem9').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId9').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId9').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId9').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(26);
    							applicationcountdashlet.params={
    									programCategoryId:selectedRecord.data.programCategoryId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									programCategoryId:selectedRecord.data.programCategoryId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem9').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId9').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId9').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId9').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(26);
    								applicationcountdashlet.params={
    										programCategoryId:selectedRecord.data.programCategoryId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										programCategoryId:selectedRecord.data.programCategoryId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem9').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId9').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId9').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId9').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(26);
    									applicationcountdashlet.params={
    											programCategoryId:selectedRecord.data.programCategoryId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											programCategoryId:selectedRecord.data.programCategoryId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
    									};		
    									applicationcountdashlet.down('#emailIdItem9').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId9').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId9').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId9').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}
    	},{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount'],
    		yAxesCategoryField : ['acadmyProgramBatchGenderKey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var id=applicationcountdashlet.params.programCategoryId;
    				var status=applicationcountdashlet.params.allCurrentStatus;
    				var genderCSM=applicationcountdashlet.params.genderCSM;
    				var genderId=applicationcountdashlet.params.genderId;
    				applicationcountdashlet.activeTab = 24;
    				var store=applicationcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					programCategoryId:id,
    					genderCSM:genderCSM,
    					genderId:genderId,
    					allCurrentStatus:status
    				};
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}
    	},{
    		xtype:'griddashlet',
    		itemId:'viaProgramCategoryGenderApplicationList',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem9',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId9',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId9',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId9',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 26;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}
    	},
    	{
    		xtype:'griddashlet',
    		itemId:'programBatchGenderViaGroupItem',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'programId'
    		},*/{
    			text : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},
    		{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('SUBMITTED'),
    			dataIndex : 'submittedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('APROVED'),
    			dataIndex : 'approvedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('REJECTED'),
    			dataIndex : 'rejectedCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('DIRECT_ADMISSION'),
    			dataIndex : 'directAdmissionCount',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var tabCheck=applicationcountdashlet.activeTab;
    				applicationcountdashlet.activeTab = 28;
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    				if(tabCheck !=27){
    					applicationcountdashlet.addTool(Ext.create('Ext.panel.Tool',{
    						type: 'prev',
    						itemId:'proGroupGenderLevel',
    						handler: function(btn, target, header, tool){
    							header.remove(tool);
    							if(applicationcountdashlet.activeTab==29){
    								var pgId=applicationcountdashlet.params.programGroupId;
    								var genderCSM=applicationcountdashlet.params.genderCSM;
    								var genderId=applicationcountdashlet.params.genderId;
    								var acadmyId=applicationcountdashlet.params.acadmyLocationId
    								header.ownerCt.getLayout().setActiveItem(27);
    								applicationcountdashlet.params={
    										genderCSM:genderCSM,
    										genderId:genderId,
    										programGroupId:pgId,
    										acadmyLocationId:acadmyId,
    										allCurrentStatus:true
    								};
    							}else{
    								header.ownerCt.getLayout().setActiveItem(8);
    								header.remove(tool);
    								applicationcountdashlet.doLayout();
    							}
    							// reset the page param after going previous page
    							var itemStore = applicationcountdashlet.items.get(2).getStore();
    							itemStore.currentPage = 1;
    							applicationcountdashlet.loadDashlet();
    						}
    					}));}
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				if(e.target.tagName == 'A'){
    					var applicationCountGrid = cell.up('grid');
    					var columnName = applicationCountGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName == 'submittedCount') {
    						var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    						var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    						applicationcountdashlet.getLayout().setActiveItem(29);
    						applicationcountdashlet.params={
    								programGroupId:selectedRecord.data.programGroupId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
							};
    						var paramsObj={
    								programGroupId:selectedRecord.data.programGroupId,
    								acadmyLocationId:selectedRecord.data.acadmyLocationId,
    								program1Id:selectedRecord.data.programId,
    								batch1Id:selectedRecord.data.batchId,
    								genderCSM:selectedRecord.data.genderCSM,
    								genderId:selectedRecord.data.genderId,
    								status:'SUBMITTED'
    						};
    						applicationcountdashlet.down('#emailIdItem10').setVisible(true);
    						applicationcountdashlet.down('#programStatusItemId10').setVisible(false);
    						applicationcountdashlet.down('#reasonItemId10').setVisible(false);
    						applicationcountdashlet.down('#admissionStatusItemId10').setVisible(false);
    						applicationCountGrid.getSelectionModel().deselectAll();
    						applicationcountdashlet.loadDashlet(paramsObj);
    					}else{
    						if(columnName == 'approvedCount'){
    							var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    							var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    							applicationcountdashlet.getLayout().setActiveItem(29);
    							applicationcountdashlet.params={
    									programGroupId:selectedRecord.data.programGroupId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							var paramsObj={
    									programGroupId:selectedRecord.data.programGroupId,
    									acadmyLocationId:selectedRecord.data.acadmyLocationId,
    									program1Id:selectedRecord.data.programId,
    									batch1Id:selectedRecord.data.batchId,
    									genderCSM:selectedRecord.data.genderCSM,
    									genderId:selectedRecord.data.genderId,
    									status:'APPROVED'
    							};
    							applicationcountdashlet.down('#emailIdItem10').setVisible(false);
    							applicationcountdashlet.down('#programStatusItemId10').setVisible(true);
    							applicationcountdashlet.down('#reasonItemId10').setVisible(false);
    							applicationcountdashlet.down('#admissionStatusItemId10').setVisible(false);
    							applicationCountGrid.getSelectionModel().deselectAll();
    							applicationcountdashlet.loadDashlet(paramsObj);
    						}else{
    							if(columnName == 'rejectedCount'){
    								var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    								var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    								applicationcountdashlet.getLayout().setActiveItem(29);
    								applicationcountdashlet.params={
    										programGroupId:selectedRecord.data.programGroupId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
        							};
    								var paramsObj={
    										programGroupId:selectedRecord.data.programGroupId,
    										acadmyLocationId:selectedRecord.data.acadmyLocationId,
    										program1Id:selectedRecord.data.programId,
    										batch1Id:selectedRecord.data.batchId,
    										genderCSM:selectedRecord.data.genderCSM,
    										genderId:selectedRecord.data.genderId,
    										status:'REJECTED'
    								};
    								applicationcountdashlet.down('#emailIdItem10').setVisible(false);
    								applicationcountdashlet.down('#programStatusItemId10').setVisible(false);
    								applicationcountdashlet.down('#reasonItemId10').setVisible(true);
    								applicationcountdashlet.down('#admissionStatusItemId10').setVisible(false);
    								applicationCountGrid.getSelectionModel().deselectAll();
    								applicationcountdashlet.loadDashlet(paramsObj);
    							}else{
    								if(columnName == 'directAdmissionCount'){
    									var selectedRecord = applicationCountGrid.getSelectionModel().getSelection()[0];
    									var applicationcountdashlet=applicationCountGrid.up('applicationcountdashlet');
    									applicationcountdashlet.getLayout().setActiveItem(29);
    									applicationcountdashlet.params={
    											programGroupId:selectedRecord.data.programGroupId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
            							};
    									var paramsObj={
    											programGroupId:selectedRecord.data.programGroupId,
    											acadmyLocationId:selectedRecord.data.acadmyLocationId,
    											program1Id:selectedRecord.data.programId,
    											batch1Id:selectedRecord.data.batchId,
    											genderCSM:selectedRecord.data.genderCSM,
    											genderId:selectedRecord.data.genderId,
    											status:'DIRECT_ADMISSION'
    									};		
    									applicationcountdashlet.down('#emailIdItem10').setVisible(false);
    									applicationcountdashlet.down('#programStatusItemId10').setVisible(false);
    									applicationcountdashlet.down('#reasonItemId10').setVisible(false);
    									applicationcountdashlet.down('#admissionStatusItemId10').setVisible(true);
    									applicationCountGrid.getSelectionModel().deselectAll();
    									applicationcountdashlet.loadDashlet(paramsObj);
    								}
    							}
    						}
    					}
    				}
    			}
    		}
    	},{
    		xtype:'stackbarchartdashlet',
    		xAxesNumericField :['submittedCount','approvedCount','rejectedCount','directAdmissionCount'],
    		yAxesCategoryField : ['acadmyProgramBatchGenderKey'],
    		titleLegend:[getCommonTranslation('SUBMITTED'),getCommonTranslation('APROVED'),getCommonTranslation('REJECTED'),getCommonTranslation('DIRECT_ADMISSION')],
    		xAxesNumericTitle :getCommonTranslation('TOTAL_NUMBER_OF_APPLICATION'),
    		yAxesCategoryTitle :'',
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_PROGRAM_BATCH_GENDER_WISE,
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				var id=applicationcountdashlet.params.programGroupId;
    				var acdmyId=applicationcountdashlet.params.acadmyLocationId;
    				var status=applicationcountdashlet.params.allCurrentStatus;
    				var genderCSM=applicationcountdashlet.params.genderCSM;
    				var genderId=applicationcountdashlet.params.genderId;
    				applicationcountdashlet.activeTab = 27;
    				var store=applicationcountdashlet.getLayout().getActiveItem().getStore();
    				store.getProxy().extraParams = {
    					programGroupId:id,
    					genderCSM:genderCSM,
    					genderId:genderId,
    					acadmyLocationId:acdmyId,
    					allCurrentStatus:status
    				};
    				applicationcountdashlet.addExportToPng(applicationcountdashlet,portlet);
    				applicationcountdashlet.addGridViewButton(applicationcountdashlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGridViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPng();
    			}
    		}

    	},{
    		xtype:'griddashlet',
    		itemId:'viaProgramGroupGenderApplicationList',
    		title:getCommonTranslation('APPLICATION_COUNT_DASHLET'),
    		header:false,
    		model:'Academia.model.applicationreport.ApplicationTallyDashletModel',
    		url : SERVERURL.COUNT_APPLICATION_LIST,
    		addPagingToolbar : true,
    		columns : [/*{
    			hidden: true,
    			dataIndex: 'applicantId'
    		}, */{
    			text : getCommonTranslation('APPLICATION_CODE'),
    			dataIndex : 'applicantCode',
    			sortable : true,
    			renderer: function(value) {
    				if(!isNullOrEmpty(value)){
    					return value="<a href='#'>"+value+"</a>";
    				}else{
    					return "-";
    				}
    			},
    			flex:0.1
    		},{
    			text : getCommonTranslation('STUDENT_NAME'),
    			dataIndex : 'studentName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ACADEMYLOCATION'),
    			dataIndex : 'academyLocationName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_NAME'),
    			dataIndex : 'programName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('BATCH_NAME'),
    			dataIndex : 'batchName',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('SEAT_TYPES'),
    			dataIndex : 'seatType',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('GENDER'),
    			dataIndex : 'genderCSM',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('MOBILE_NO'),
    			dataIndex : 'mobileCountryCodeContactNo',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('EMAIL_ID'),
    			dataIndex : 'emailId',
    			itemId:'emailIdItem10',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('PROGRAM_STATUS'),
    			dataIndex : 'programStatus',
    			itemId:'programStatusItemId10',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		},{
    			text : getCommonTranslation('REASON'),
    			dataIndex : 'rejectReason',
    			itemId:'reasonItemId10',
    			sortable : true,
    			flex:0.1
    		},{
    			text : getCommonTranslation('ADMISSION_STATUS'),
    			dataIndex : 'admissionStatus',
    			itemId:'admissionStatusItemId10',
    			sortable : true,
    			flex:0.1,
    			renderer: function(value) {
    				return value=getCommonTranslation(value);
    			}
    		}],
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.activeTab = 29;
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			},
    			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    				var $this=this;
    				if(e.target.tagName == 'A'){
    					var applicationGrid = cell.up('grid');
    					var selectedRecord = applicationGrid.getSelectionModel().getSelection()[0];
    					var columnName = applicationGrid.columnManager.columns[cellIndex].dataIndex;
    					if(columnName=='applicantCode'){
    						var applicantId = record.get('applicantId'); 
    						var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    						enquiryController.openApplicantProfileFromDashlet(applicantId, true,applicationGrid,record);
    					}
    					if(this.up('dashboardhomepage') == undefined){
    						applicationGrid.up().up().up().close();
    					}
    				}
    			}
    		}
    	},{
    		xtype: 'panel',
    		width: '100%',
    		height: '100%',
    		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
    		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
    		listeners:{
    			activate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet);
    				applicationcountdashlet.activeTab = 30;
    				applicationcountdashlet.addForProgramCategory(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroup(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatch(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addForProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.addGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.addExportToPdf(applicationcountdashlet,portlet);
    				applicationcountdashlet.addExportToExcel(applicationcountdashlet,portlet);
    			},
    			deactivate:function(portlet){
    				var applicationcountdashlet=portlet.up('applicationcountdashlet');
    				applicationcountdashlet.removeGraphViewButton(applicationcountdashlet);
    				applicationcountdashlet.removeProgramGroup();
    				applicationcountdashlet.removeProgramBatch();
    				applicationcountdashlet.removeProgramCategory();
    				applicationcountdashlet.removeProgramCategoryGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramGroupGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeProgramBatchGenderWise(applicationcountdashlet,portlet);
    				applicationcountdashlet.removeExportToPdf();
    				applicationcountdashlet.removeExportToExcel();
    			}
    		}
    	}]
});