Ext.define('Academia.view.dashboard.dashlets.CalendarDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.calendardashlet',
    graphView:true,
    layout:'card',
    cls:'CalendarDashletCLS dashlet',
    activeItem: 0, 
//    maxWidth: 1020,
   /* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */
    loadDashlet :function(){
    	var view = this.layout.getActiveItem();
    	if(view.itemId == 'calendarViewItemId'){
    		var userInfo=this.getCurrentlyLoggedInDashletUser();
    		var params = new Object();
    		view.eventStore.removeAll();
    		view.eventStore.getProxy().actionMethods.read = 'GET';
    		params.studentId = userInfo.id;
    		view.eventStore.getProxy().url =  SERVERURL.PATH_FIND_ALL_EVENTS_DASHLET;
    		view.eventStore.getProxy().extraParams = params;
    		view.eventStore.load();
    	}
    },
	defaults: {
		cls:'panelNoSpace'
    },
    
	items:[{
        xtype: 'calendarpanel',
        itemId: 'calendarViewItemId',
        layout: 'fit',
        toolBarDateTitleWidth: '45%',
		 border: true,
		 width: '100%',
		 height: '100%',
		 minHeight: 450,
		 padding:0,
			 margin:0,
			 flex:1,
		 region: 'center',
        activeItem: 3,
        eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
        calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
        monthViewCfg: {
            showHeader: true,
            showWeekLinks: true,
            showWeekNumbers: true
         }
     }]
});
