/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.dashboard.dashlets.EmployeeAttendanceDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.employeeattendancedashlet',
	graphView:false,
	layout:'card',
	activeItem: 0,
	autoScroll: true,
	cls:'EmployeeAttendanceDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view = this.layout.getActiveItem();
		var userInfo=this.getCurrentlyLoggedInDashletUser();	
		var extraparams = this$.getParams();
		academyLocationId = this$.getUserCurrentAcademyLocation();
		
		if(view.xtype=='calendarpanel'){
			var params = new Object();
			view.eventStore.getProxy().actionMethods.read = 'GET';
			params.employeeId = userInfo.id;
			var monthView = view.down('monthview');
			var startDate=Ext.Date.format(monthView.getViewBounds().start, CONSTANTS.MDY_DESH_DATE_FORMAT);
			var endDate=Ext.Date.format(monthView.getViewBounds().end, CONSTANTS.MDY_DESH_DATE_FORMAT);
			params.start = startDate;
			params.end = endDate;
			view.eventStore.removeAll();
			view.eventStore.getProxy().url = SERVERURL.FACULTY_ATTENDANCE_CALENDAR;
			view.eventStore.getProxy().extraParams = params;
			view.eventStore.load();
		}
		
		else if(view.xtype == 'employeeattendancepiechartreport'){
			var calMonthView= this.down('#dashletEmployeeAttendanceCalendarId').down('monthview');
			var store = view.getStore();
			//var extraparams=this$.getParams();
			var submitURL=SERVERURL.FACULTY_ATTENDANCE_COUNT;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				employeeId : userInfo.id,
				startDate : calMonthView.viewStart,
				endDate : calMonthView.viewEnd
			};
			store.load({
				callback: function(rec, operation, success) {
					if(rec != null){
						if(rec.length==0){
							this$.layout.setActiveItem(0);
						}
					}
				}
			});
			
//			var submitURL=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_PIE_CHART;
//			store.getProxy().api.read=submitURL;
//			store.getProxy().extraParams = {
//				admissionId : 334,
//				attendanceType : 'COMPLETE_DAY',
//				periodId : 66,
//				sectionId : 131
//			};
//			store.load({params:extraparams,
//				callback: function(rec, operation, success) {
//					if(rec != null){
//						if(rec.length==0){
//							this$.layout.setActiveItem(0);
//						}
//					}
//				}
//			});
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype: 'employeeattendancepiechartreport'
	},
	items:[{ 
		xtype: 'calendarpanel',
		itemId: 'dashletEmployeeAttendanceCalendarId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		toolBarDateTitleHeight: '2%',
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 400,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:false,
		showMonthView:true,
		showNavBar: true,
		/*monthViewCfg: {
			showHeader: true,
			showWeekLinks: true,
			showWeekNumbers: true
		},*/
		listeners:{
			activate:function(portlet){
				var employeeattendancedashlet=portlet.up('employeeattendancedashlet');
				employeeattendancedashlet.down('label').up().setVisible(false);
				var grid = employeeattendancedashlet.getLayout().getActiveItem();
				employeeattendancedashlet.activeTab = 0;
				employeeattendancedashlet.addEmployeeAttendanceSummaryList(employeeattendancedashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var employeeattendancedashlet=portlet.up('employeeattendancedashlet');
				employeeattendancedashlet.removeEmployeeAttendanceSummaryList();
			},
		}
	},{
		xtype: 'employeeattendancepiechartreport',
		itemId: 'employeeattandencesummeryvise',
		title: 'Attendance Summary',
		width : 450,
		minHeight : 240,
		store: 'Academia.store.attendance.EmployeeAttendancePieChartStore',
		numericField: 'totalAttendanceCount',
		categoryField: 'attendanceStatus',
		legend: {
			boxStrokeWidth: 0,
			position: 'bottom'
	    },	    
		listeners:{
			activate:function(portlet){
				var employeeattendancedashlet=portlet.up('employeeattendancedashlet');
				employeeattendancedashlet.down('label').up().setVisible(true);
				var grid = employeeattendancedashlet.getLayout().getActiveItem();
				employeeattendancedashlet.activeTab = 1;
				employeeattendancedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(0);
						header.remove(tool);
						employeeattendancedashlet.params={};
						// reset the page param after going previous page
						employeeattendancedashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var employeeattendancedashlet=portlet.up('employeeattendancedashlet');
				employeeattendancedashlet.removeEmployeeAttendanceSummaryList();
			},
		}
	}],
	tbar: {
		height : 40,
		hidden :true,
		itemId:'labelItemId',
		items: [{
			xtype: 'label',
			width : '100%',
			text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
			style: {
				color : 'black',
				'text-align': 'center',
				'font-weight': 'bold',
				'font-size': '16px',
				'margin-top':'13px'
			},
			//style:{marginLeft:'10px'},
		}]
	}
});
