/*
 * @Author priyanshi sharma
 */
Ext.define('Academia.view.dashboard.dashlets.OutstandingAmountMainDashDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.outstandingamountmaindashdashlet',
	layout:'card',
	activeItem: 0,
	autoScroll : false,
	cls:'outStandingAmountDashletCLS dashlet',
	loadDashlet :function(paramObj){
		var this$=this;
		var view= this.layout.getActiveItem();
		var store= view.down('grid').getStore();
		var extraparams=this$.getParams();
		var userId = this$.getCurrentlyLoggedInDashletUser().id;
		store.getProxy().extraParams = {
			userId: userId,
		};
		store.load({
			params: extraparams,
			callback: function(rec, operation, success) {
				if (rec != null && rec.length > 0) {
					this$.layout.setActiveItem(0);
					if(rec[0].data.debitOrCredit=='Dr'){
						this$.down('#amountForPayment').setValue(rec[0].data.totalOutstanding);
					}else{
						this$.down('#amountForPayment').reset();
					}
				}
			}
		});

	},
	defaults: {
		cls:'panelNoSpace'
	},
	items:[{
    	xtype:'panel',
    	//autoScroll : true,
    	border: true,
    	layout:'vbox',
    	margin : 0,
    	cls : 'horizontalScrollingFixed',
    	width:'100%',
    	items:[{
    		xtype:'grid',
    		width: '100%',
    		height: 'auto',
    		style:{
    			marginTop:'-20px !important'
    		},
    		store: 'dashboard.OutStandingAmountDashletStore',
    		itemId: 'outStandingAmountDashlet',
    		border:1,
    		addPagingToolbar : false,
    		columns : [{
    			text : getCommonTranslation('TOTAL_BILLS'),
    			dataIndex: 'totalBills',
    			sortable : false,
    			flex:0.2,
        		renderer:function(value, metaData, record, row, col, store, gridView){
        			if(!isNullOrEmpty(value)){
        				var currencyId;
        				if (record && record.data){
        					currencyId = record.data.currencyId
        				}
        				return currencyRenderer(value,currencyId);
        			}
        		}
    		}, {
    			text : getCommonTranslation('TOTAL_RECEIPTS'),
    			dataIndex : 'totalReceipts',
    			sortable : false,
    			flex:0.2,
    			renderer:function(value, metaData, record, row, col, store, gridView){
        			if(!isNullOrEmpty(value)){
        				var currencyId;
        				if (record && record.data){
        					currencyId = record.data.currencyId
        				}
        				return currencyRenderer(value,currencyId);
        			}
        		}
    		}, {
    			text : getCommonTranslation('TOTAL_CREDIT_NOTE'),
    			dataIndex : 'totalCreditNote',
    			sortable :false,
    			flex:0.2,
    			renderer:function(value, metaData, record, row, col, store, gridView){
        			if(!isNullOrEmpty(value)){
        				var currencyId;
        				if (record && record.data){
        					currencyId = record.data.currencyId
        				}
        				return currencyRenderer(value,currencyId);
        			}
        		}
    		},  {
    			text : getCommonTranslation('TOTAL_PAYMENTS'),
    			dataIndex: 'totalPayments',
    			sortable : false,
    			flex:0.2,
    			renderer:function(value, metaData, record, row, col, store, gridView){
        			if(!isNullOrEmpty(value)){
        				var currencyId;
        				if (record && record.data){
        					currencyId = record.data.currencyId
        				}
        				return currencyRenderer(value,currencyId);
        			}
        		}
    		},{
    			text : getCommonTranslation('TOTAL_OUTSTANDING'),
    			dataIndex: 'totalOutstanding',
    			sortable : false,
    			flex:0.2,
    			renderer:function(value, metaData, record, row, col, store, gridView){
        			if(!isNullOrEmpty(value)){
        				var amt;
        				if(record.get('debitOrCredit')=='Cr'){
        					amt = value*(-1);
        				}else{
        					amt = value;
        				}
        				var currencyId;
        				if (record && record.data){
        					currencyId = record.data.currencyId
        				}
        				var amtWithCurrency = currencyRenderer(amt,currencyId);
        				return amtWithCurrency+' '+record.get('debitOrCredit');
        			}
        		}
    		}],
    	},{
    		xtype:'form',
    		layout:'vbox',
    		cls : 'horizontalScrollingFixed',
    		width:'100%',
    		style:{
    			marginTop:'-15px !important'
    		},
    		items:[{	
    			xtype:'fieldcontainer',
    			width: '100%',
    			layout : 'hbox',
    			defaults: {
    				labelAlign:'top',
    				width: 256,
    			},
    			items:[{
    				xtype: 'displayfield',
    				name : 'viewStatementOfAcc',
    				itemId : 'viewStatementOfAcc',
    				value: '<a href=#>View Detailed Statement</a>'
    			}]	
    		},{	
    			xtype:'fieldcontainer',
    			width: '100%',
    			layout : 'hbox',
    			defaults: {
    				labelAlign:'top',
    				width: 256,
    			},
    			items:[{
    				xtype: 'numberfield',
    				name : 'amountForPayment',
    				itemId : 'amountForPayment',
    				minValue: 0,
    				maxLength:13,
    	            allowExponential: false,
    	            hideTrigger:true,
    	            style:{
            			marginTop:'5px !important'
            		}
    			},{
    				xtype: 'button',
    				itemId: 'makePaymentId',
    				text:getCommonTranslation('MAKE_PAYMENT'),
    				tooltip: getCommonTranslation('MAKE_PAYMENT'),
    				ui: 'CustomBtnCancel',
    			}]	
    		}]
    	}],
    	listeners: {
            activate: function(portlet) {
            	var outstandingamountmaindashdashlet = portlet.up('outstandingamountmaindashdashlet');
            	outstandingamountmaindashdashlet.removeMenuButtons('maximizeBtns',outstandingamountmaindashdashlet);
            }
        }
	}],
});
