/**
 * @author Amit G 
 */
Ext.define('Academia.view.dashboard.dashlets.StudentDisciplinaryActivityStudentPortalDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentdisciplinaryactivitystudentportaldashlet',
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'StudentDisciplinaryActivityStudentPortalDashletCLS dashlet spaceIssueParentPortalTextCut',
    loadDashlet :function(){
	    var this$=this;
	    var view= this$.layout.getActiveItem();
	    if(view.xtype=='panel'){ 
	    	var studentId =	this$.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
	    	Ext.Ajax.request({
			 method: "GET",
				 type: 'rest',
				 url: SERVERURL.STUDENT_DISCIPLINARY_DASHLETCOUNT,
				 params:{
					 studentId:studentId
				 },
				 success: function(f, action) {
					 var defaultcurrncyId = Ext.JSON.decode(f.responseText);
					 var disciplinaryAction = view.down('#disciplinaryAction');
					 disciplinaryAction.setValue(defaultcurrncyId.disciplinaryCount);
					 var negativeIncidents = view.down('#negativeIncidents');
					 negativeIncidents.setValue(defaultcurrncyId.negativeIncidentCount);
					 var positiveIncidents = view.down('#positiveIncidents');
					 positiveIncidents.setValue(defaultcurrncyId.positiveIncidentCount);}
			 });
	    }
	    if(view.xtype=='griddashlet' && (view.itemId == 'disciplinaryActionDashletId' || view.itemId == 'negativeIncidentDashletId' || view.itemId == 'positiveIncidentDashletId')){
	    	view.getSelectionModel().deselectAll();
	    	var store= view.getStore();
	    	this$.resetPageSetting(store);
			var personId = this$.getCurrentlyLoggedInDashletUser().personId;
	    	store.getProxy().extraParams = {
	    		personId: personId
	    	};
	    	store.load({
	    		callback: function(rec, operation, success) {
	    			/*if(rec.length==0){
	    				this$.layout.setActiveItem(4);
	    			}*/
	    		}
	    	});
	    }
	},
	defaults: {
		cls: 'horizontalScrollingFixed',
		xtype:'griddashlet'
    },
    
	items:[{
    	xtype:'panel',
    	border: true,
    	autoScroll:true,
    	layout:'hbox',
    	margin : 0,
    	cls : 'horizontalScrollingFixed',
    	width:'100%',
    	items:[{
    		xtype:'fieldcontainer',
    		layout:'hbox',
    		items:[{
        		xtype: 'panel',
        		cls:'disciplinaryActionCLS',
        		layout:'vbox',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        			xtype: 'text',
        			text : getPersonModuleTranslation('DISCIPLINARY_ACTIONS'),
        			height:15
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'disciplinaryAction',
        			name:'disciplinaryAction',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        						var studentdisciplinaryactivitystudentportaldashlet=inPanel.up('studentdisciplinaryactivitystudentportaldashlet');
        						studentdisciplinaryactivitystudentportaldashlet.getLayout().setActiveItem(1);
        							var getStudentPortal = this$.getCurrentlyLoggedInUserInfoForPortal();
        							var personId = getStudentPortal.student.person.id;
        							var store = studentdisciplinaryactivitystudentportaldashlet.getLayout().getActiveItem().getStore();
        							store.getProxy().extraParams = {
        								personId : personId
        							};
        							studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
        						}	
        						
        				});
        				}		
        			}
        		}]
        	},{
        		xtype: 'panel',
        		//hidden:true,
        		layout:'vbox',
        		cls:'disciplinaryActionCLS',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        			xtype: 'text',
        			text : getPersonModuleTranslation('NEGATIVE_INCIDENTS'),
        			height:15
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'negativeIncidents',
        			name:'negativeIncidents',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        						var studentdisciplinaryactivitystudentportaldashlet=inPanel.up('studentdisciplinaryactivitystudentportaldashlet');
        						studentdisciplinaryactivitystudentportaldashlet.getLayout().setActiveItem(2);
        						var getStudentPortal = this$.getCurrentlyLoggedInUserInfoForPortal();
        						var personId = getStudentPortal.student.person.id;
        						var store = studentdisciplinaryactivitystudentportaldashlet.getLayout().getActiveItem().getStore();
        						store.getProxy().extraParams = {
        							personId : personId
        						};
        						studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
        						}	
        					});
        				}		
        			}
        				
        		}]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		cls:'disciplinaryActionCLS',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        			xtype: 'text',
        			text : getPersonModuleTranslation('POSITIVE_INCIDENTS'),
        			height:15
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'positiveIncidents',
        			name:'positiveIncidents',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        						var studentdisciplinaryactivitystudentportaldashlet=inPanel.up('studentdisciplinaryactivitystudentportaldashlet');
        						studentdisciplinaryactivitystudentportaldashlet.getLayout().setActiveItem(3);
        						var getStudentPortal = this$.getCurrentlyLoggedInUserInfoForPortal();
        						var personId = getStudentPortal.student.person.id;
        						var store = studentdisciplinaryactivitystudentportaldashlet.getLayout().getActiveItem().getStore();
        						store.getProxy().extraParams = {
        							personId : personId
        						};
        						studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
        						}
        					});
        				}		
        			}
        				
        		}]
        	}
    ]}]
    },{
    	title: getPersonModuleTranslation('DISCIPLINARY_ACTION'),
    	cls:'disciplinaryActionDashletHeaderId',
    	itemId:'disciplinaryActionDashletId',
    	fields: ['person', 'details', 'incidentDate', 'actionTaken', 'dateOfAction', 'remarks','reportedByUser','reportedByUserName', 'documents','incidentType', 'disciplinaryActionDetails','customData'],
		url : SERVERURL.DISCIPLINARY_ACTION_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'incidentType',
	        sortable: true,
	        flex: .2,
	        renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)) {
					return value.value; 
				}                        
			}
	    },  {
	        header: getPersonModuleTranslation('DATE_OF_INCIDENT'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'details',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('REPORTER_USER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('ACTION_TAKEN'),
	        dataIndex: 'actionTaken',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('DATE_OF_ACTION'),
	        dataIndex: 'dateOfAction',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        dataIndex: 'disciplinaryActionDetails',
	        sortable: true,
	        flex: .2,
			renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)){
					if(record.data.disciplinaryActionDetails.length){
						return record.data.disciplinaryActionDetails.length;
					}
				}
			}
	    }, {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        hidden: true,
	        flex: .2
	    }, {
			header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			hidden: true,
			renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				studentdisciplinaryactivitystudentportaldashlet.activeTab = 1;
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentdisciplinaryactivitystudentportaldashlet=grid.ownerCt.up('studentdisciplinaryactivitystudentportaldashlet');
							studentdisciplinaryactivitystudentportaldashlet.getLayout().setActiveItem(7);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentdisciplinaryactivitystudentportaldashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								store.getProxy().extraParams = {
									disciplinaryActionId : id
								};
							}
							store.load();

						}
					}
				}
			}
		}
	},{
		title: getPersonModuleTranslation('NEGATIVE_INCIDENT'),
		cls:'disciplinaryActionDashletHeaderId',
		itemId:'negativeIncidentDashletId',
		fields: ['person', 'type', 'incidentDate', 'reportedByUserId', 'reportedByUserName', 'actionTaken', 'honourName', 'remarks',
	    	'dateOfAction','incidentRating','incidentDetails','documents','studentsInvolved','uniqueIdentifier','customData'],
		url : SERVERURL.NEGATIVE_INCIDENT_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'type',
	        sortable: true,
	        flex: .2,
	        renderer : function(obj){
	        	return columnObjRender(obj, 'value');
	        }
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DATE'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'incidentDetails',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_RATING'),
	        dataIndex: 'incidentRating',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
	        	if(!isNullOrEmpty(value)) {
	        		return value.value;
	        	} else {
	        		return '';
	        	}
			}
	    }, {
	        header: getPersonModuleTranslation('REPORTER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        itemId: 'studentsInvolvedItemId',
	        dataIndex: 'studentsInvolved',
	        sortable: true,
	        flex: .2,
			renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)){
					return value;
				}	
			}
	    }, {
	        header: getPersonModuleTranslation('ACTION_TAKEN'),
	        dataIndex: 'actionTaken',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('DATE_OF_ACTION'),
	        dataIndex: 'dateOfAction',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        flex: .2
	    }, {
	    	header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			//hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				studentdisciplinaryactivitystudentportaldashlet.activeTab = 1;
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentNegativeActivityDashlet=grid.ownerCt.up('studentdisciplinaryactivitystudentportaldashlet');
							studentNegativeActivityDashlet.getLayout().setActiveItem(8);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentNegativeActivityDashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								store.getProxy().extraParams = {
									incidentId : id
								};
							}
							store.load();

						}
				}
					}
			}
		}
	},{
		title: getPersonModuleTranslation('POSITIVE_INCIDENT'),
		cls:'disciplinaryActionDashletHeaderId',
		itemId:'positiveIncidentDashletId',
		fields: ['person', 'type', 'documents','incidentDate', 'reportedByUserId', 'reportedByUserName', 'actionTaken', 'honourName', 'remarks',
	    	'categoryOfIncident','incidentRating','incidentDetails','studentsInvolved','uniqueIdentifier','customData'],
		url : SERVERURL.POSITIVE_INCIDENT_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('CATEGORY_OF_INCIDENT'),
	        dataIndex: 'categoryOfIncident',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'type',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DATE'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'incidentDetails',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('HONOUR_AWARD_NAME'),
	        dataIndex: 'honourName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_RATING'),
	        dataIndex: 'incidentRating',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('REPORTER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        itemId: 'studentsInvolvedItemId',
	        dataIndex: 'studentsInvolved',
	        sortable: true,
	        flex: .2,
			renderer:function(value, meta, record){
				 if(!isNullOrEmpty(value)){
	    				return value;
				}
			}
	    },
	    {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        hidden: true,
	        flex: .2
	    }, {
	    	header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				studentdisciplinaryactivitystudentportaldashlet.activeTab = 1;
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentPositiveActivityDashlet=grid.ownerCt.up('studentdisciplinaryactivitystudentportaldashlet');
							studentPositiveActivityDashlet.getLayout().setActiveItem(9);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentPositiveActivityDashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								store.getProxy().extraParams = {
									incidentId : id
								};
							}
							store.load();

						}
					}
				}
			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','programName'],
		itemId:'disciplinaryStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'value',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(1);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(3).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));

			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','name','programName'],
		itemId:'negativeStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'name',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(2);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(4).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','name','programName'],
		itemId:'positiveStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'name',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(3);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(5).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.DISCIPLINARY_ACTION_DASHLET_DOCUMENT_FIND,
		itemId:'disciplinaryListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(1);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(3).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.POSITIVE_NEGATIVE_INCIDENT_DASHLET_DOCUMENT_FIND,
		itemId:'negativeListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(2);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(4).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.POSITIVE_NEGATIVE_INCIDENT_DASHLET_DOCUMENT_FIND,
		itemId:'positiveListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				Ext.each(studentdisciplinaryactivitystudentportaldashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitystudentportaldashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitystudentportaldashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(3);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitystudentportaldashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitystudentportaldashlet.items.get(5).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitystudentportaldashlet.loadDashlet();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitystudentportaldashlet=portlet.up('studentdisciplinaryactivitystudentportaldashlet');
				studentdisciplinaryactivitystudentportaldashlet.activeTab = 1;
			}
		}
	}]
});
