/**
 * @author Amit G 
 */
Ext.define('Academia.view.dashboard.dashlets.TimeTableActivityDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.timetableactivitydashlet',
	graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'TimeTableDashletCLS dashlet',
    loadDashlet :function(paramObj){
    	var this$=this;
    	 var view= this$.layout.getActiveItem();
	    if(view.xtype=='griddashlet' || view.xtype=='pnctimetablesearchresultgrid'){
	    	if(view.xtype=='pnctimetablesearchresultgrid'){
	    		var displayName = this$.getAcademyLocationDisplayName(this$.getUserCurrentAcademyLocation())+', '+ Ext.Date.format(new Date(), 'j F Y');
	    		this$.setTitle(displayName);
	    		var preView = Ext.ComponentQuery.query('timetableactivitydashlet')[0];
	    		preView.getLayout().setActiveItem(0);
	    		preView.doLayout();
	    	}
	    	var store= view.getStore();
	    	var sectionGroupIds;
	    	if(!isNullOrEmpty(store.getProxy().extraParams.ids)){
	    		sectionGroupIds=store.getProxy().extraParams.ids;
	    		store.getProxy().sortParam='';
	    	}
	    	var extraparams;
			if(paramObj !=undefined){
				extraparams=paramObj;
			}else{
				extraparams=this$.getParams();
			}
			if(this$.getParams()!=undefined){
				extraparams['intakeYearId']=this$.getParams().intakeYearId;
				extraparams['locationId']=this$.getParams().locationId;
				extraparams['academyId']=this$.getParams().academyId;
				extraparams['programId']=this$.getParams().programId;
				extraparams['batchId']=this$.getParams().batchId;
				extraparams['seatTypeId']=this$.getParams().seatTypeId;
				delete extraparams.startDate;
				delete extraparams.endDate;
			}			
					
			switch (view.itemId) {
			case 'SectionGroupDetailGridId':
				store.getProxy().extraParams = {
					ids:sectionGroupIds,
			};
				break;

			}
			if(view.xtype=='griddashlet'){
				store.load({
		    		callback: function(rec, operation, success) {
		    			if(rec.length==0){
		    				this$.layout.setActiveItem(2);
		    			}
		    		}
		    	});
				store.sort("SECTION_GROUP_NAME","ASC")
			}else{
				store.load({params:extraparams,
		    		callback: function(rec, operation, success) {
		    			if(rec.length==0){
		    				this$.layout.setActiveItem(2);
		    			}
		    		}
		    	});	
				store.sort("SECTION_GROUP_NAME","ASC")
			}
				
	    }
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
	items:[{
	    xtype:'pnctimetablesearchresultgrid',
	    title: false,
	    cls:'timeTableActivityDashletCLS',
	    columns : [],
		listeners:{
			activate:function(portlet){
				var timetableactivitydashlet=portlet.up('timetableactivitydashlet');
				timetableactivitydashlet.removeExportToPdf(timetableactivitydashlet,portlet);
				timetableactivitydashlet.removeExportToExcel(timetableactivitydashlet,portlet);
				portlet.doLayout();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var timetableactivityGrid = cell.up('grid');
					var columnName = timetableactivityGrid.columnManager.columns[cellIndex].dataIndex;
					var studentIdArray=[];
					for(var i in timetableactivityGrid.getStore().data.items[rowIndex].data[columnName]) {
						studentIdArray.push(timetableactivityGrid.getStore().data.items[rowIndex].data[columnName][i].id);
					}
					var studentIds = studentIdArray.join(',');
					var timetableactivityCount=timetableactivityGrid.up('timetableactivitydashlet');
					timetableactivityCount.params ={ids:studentIdArray};
					timetableactivityCount.getLayout().setActiveItem(1);
					var store = timetableactivityCount.getLayout().getActiveItem().getStore();
					store.removeAll();
					store.getProxy().extraParams = {
						ids:studentIdArray
					};
					timetableactivityCount.setTitle(getCommonTranslation('TIME_TABLE')+' '+timetableactivityGrid.getStore().data.items[rowIndex].data.SECTION_GROUP_NAME+' '+columnName)
					timetableactivityCount.loadDashlet();
				}else{
    				return false;
    			}
    		}
		}
	},{
		fields:['id','sectionGroupName','sectionName','courseName','facultyName','whetherAttendanceMarked','whetherDeleted'],
		url : SERVERURL.PATH_GET_DETAIL_TIME_TABLE_BY_IDS,
		itemId:'SectionGroupDetailGridId',
		cls:'sectionGroupTimeDashlet',
		autoScroll:false,
		addPagingToolbar : true,
		columns : [{
			header: getCourseTxCommonTranslation('SECTION_GROUP'),
			dataIndex: 'sectionGroupName',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('SECTION_NAME'),
			dataIndex: 'sectionName',
			 sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('COURSE_NAME'),
			dataIndex: 'courseName',
			 sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('FACULTY_NAME'),
			dataIndex: 'facultyName',
			 sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
			dataIndex: 'whetherAttendanceMarked',
			 sortable: true,
	        flex: .2,
			renderer: function(value){
				if(value == null) {
					return "";
				} else if(value == false){
					return '<span class="required" style="color:red">*</span>';
				}else{
					return '<span style="color:green">'+getCommonTranslation('YES')+'</span>';
				}
			}
		},{
			header: getCommonTranslation('SESSION_CANCELLED'),
			dataIndex: 'whetherDeleted',
			 sortable: true,
	        flex: .2,
			renderer: function(value){
				if(value == null) {
					return "";
				} else if(value == false){
					return '<span style="color:green">'+getCommonTranslation('NO')+'</span>';
				}else{
					return '<span class="required" style="color:red">*</span>';
				}
			}
		}],
		listeners:{
			activate:function(portlet){
				var timetableactivitydashlet=portlet.up('timetableactivitydashlet');
				Ext.each(timetableactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						timetableactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				timetableactivitydashlet.activeTab = 1;
				timetableactivitydashlet.addExportToPdf(timetableactivitydashlet,portlet);
				timetableactivitydashlet.addExportToExcel(timetableactivitydashlet,portlet);
				portlet.getView().refresh();
				portlet.doLayout();
				timetableactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(0);
						header.remove(tool);
						timetableactivitydashlet.params={};
						// reset the page param after going previous page
						var itemStore = timetableactivitydashlet.items.get(1).getStore();
						itemStore.currentPage = 1;
						timetableactivitydashlet.loadDashlet();
					}
				}));}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		listeners:{
			activate:function(portlet){
				var timetableactivitydashlet=portlet.up('timetableactivitydashlet');
				timetableactivitydashlet.activeTab = 1;
			}
		}
	}]
});
