/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Entity Level Settings Panel. 
 */
Ext.define('Academia.view.datasetting.EntityLevelSettingsPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.entitylevelsettingpanel',
    collapsible: false,
    items: [{
        xtype: 'form',        
        plugins: "formlabelrequired",
        standardSubmit: false,
        width: '100%',
        layout: {
            type: 'hbox'
        },
        items: [{
        	defaults: {
        		labelAlign: 'top',
        		width: 250
        	},
        	layout: {
        		type: 'vbox'
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name: 'entitty',
        		itemId: 'cmbEntity',
        		fieldLabel: getCommonTranslation('SELECT_ENTITY'), //Select Entity
        		store: 'datasetting.DataSettingEntityStore',
        		valueField: 'id',
        		displayField: 'tableName',
        		editable: false,
        		queryMode: 'local',
        		triggerAction: 'all',
        		forceSelection: true,
        		allowBlank: false
        	}, {
        		xtype: 'nestedJsonCombo',
        		name: 'idColumn',
        		itemId: 'idColumn',
        		store:  'datasetting.IdColumnDynamicFieldStore',
        		overrideSetValue :false,
        		valueField: 'value',                        
        		displayField: 'value',                    
        		fieldLabel: getCommonTranslation('FIELD'), //Field
        		editable: false,
        		queryMode: 'local',
        		forceSelection: true,
        		allowBlank: false
        	}]
        }, {
        	xtype: 'form',
        	itemId: 'entitySettingForm',
        	title: getCommonTranslation('ENTITY_LEVEL_SETTINGS'), //Entity Level Settings
        	collapsible: false,
        	frame: true,
        	flex: .7,
        	disabled:true,
        	layout: {
        		type: 'vbox'
        	},
        	/*defaults: {
        		padding: 10
        	},*/
        	items: [{
    			xtype : 'fieldcontainer',
    			width : 'auto',
    			layout: {
    				type: 'hbox'
    			},
    			items:[{
    				xtype: 'checkboxfield',
    				boxLabel: getCommonTranslation('ENFORCE_SHORT_CODES'), //Enforce Short codes
    				name: 'whetherEnforceShortCodes',
    				itemId: 'whetherEnforceShortCodes',
    				inputValue: 'true',
    				uncheckedValue: 'false'
    			}, {
    				xtype: 'checkboxfield',
    				boxLabel: getCommonTranslation('MANUAL_ID'), //Manual Id
    				name: 'whetherManualId',
    				itemId: 'whetherManualId',
    				inputValue: 'true',
    				uncheckedValue: 'false'
    			}, {
    				xtype:'panel',
    				margin: 7,
    				width:275,
    				layout: {
        				type: 'hbox'
        			},
    				items:[{
    					xtype: 'label',
    					html: '<div>'+getCommonTranslation('ID_FORMAT')+'-:&nbsp;</div>'  //ID Format							    
    				}, {
    					xtype: 'label',
    					name:'idFormatType',
    					itemId:'idFormatType',
    					text: getCommonTranslation('NO_IDFORMAT_ASSIGNED')   //No ID Format Assigned				
    				}]
    			}, {
					xtype: 'button',
					itemId: 'btnSave',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					text: getCommonTranslation('SAVE')  //SAVE
				}, {
					xtype: 'button',
					tooltip: getCommonTranslation('CONFIGURE_ID_FORMAT'), //Configure ID Format
					itemId: 'btnConfigureIDFormat',
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE,
					text: getCommonTranslation('CONFIGURE_ID_FORMAT'),  //Configure ID Format
					cls: 'btn-with-no-icon'
				}, {
					xtype: 'button',
					itemId: 'btnRestoreDefault',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					tooltip: getCommonTranslation('RESTORE_DEFAULT'), //Restore Default
					text: getCommonTranslation('RESTORE_DEFAULT'),  //Restore Default
					cls: 'btn-with-no-icon'
				}]
    		},{
				xtype: 'checkboxfield',
				boxLabel: getCommonTranslation('Whether Editable'), //Manual Id
				name: 'whetherEditable',
				itemId: 'whetherEditableItemId',
				hidden: true,
				inputValue: 'true',
				uncheckedValue: 'false'
			},{
				xtype: 'checkboxfield',
				boxLabel: getCommonTranslation('SYNC_COUNTER_WITH_APPLICATION'),
				name: 'isSyncWithApplication',
				itemId: 'isSyncWithApplicationItemId',
				hidden: true,
				inputValue: 'true',
				uncheckedValue: 'false'
			}]
        }]
    }]
});