/**
 * @author saket.puranik
 *  
 * This component is used for layout of Department tab
 */
Ext.define('Academia.view.department.Department', {
	extend : 'Ext.form.Panel',
	alias : 'widget.department',
	layout: {
		type: 'hbox'
	},
	style:{
		'padding':'25px 25px 0px 25px !important'
	},

	items : [{ 
		style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
		xtype : 'departmentgrid',
		itemId : 'departmentgrid',
		cls:'departmentgridCls',
		flex:.3
	},{ 
		xtype : 'subdepartmentgrid',
		itemId : 'subdepartmentgrid',
		cls:'subdepartmentgridCls',
		flex:.3
	}
	],
	// BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});
