Ext.define('Academia.view.document.StudentDocumentFormWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.studentdocumentformwindow',
	modal: true,
	autoScroll : true,
	resizable: false,
	title: getPersonModuleTranslation('DOCUMENTS_DETAILS'),
	method: 'POST',
	itemId:'studentdocumentformwindowItemId',
	items: [{
	plugins: "formlabelrequired",
	xtype: 'form',
	defaults : {
		labelAlign:'top',
		width: 256
	},
	items : [{
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'filefield',
		ui : 'CustomBtnSubmit',
		fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
		buttonText : getPersonModuleTranslation('UPLOAD'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		/*listeners:{
			change: function(field, val) { 
                var fileName = /^.*\.(exe)$/i;
                if(fileName.test(val)){
                	field.reset();
                	showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
                	return false;
                }
          }
		}*/
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE,
			handler : function(){
				if(Ext.isDefined(this.up('window'))){
					this.up('window').close();	
				}
			}

		} ]
	} ]
	}]
});