/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.documentmanagement.BulkDocumentDownloadForm',{
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.bulkdocumentdownloadform',
	 plugins: "formlabelrequired",
	 formCode:'bulkdocumentdownloadform',
	    itemId: 'bulkDownlForm',
	 standardSubmit: false,
	 items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'vbox'
			},
			defaults :{
				width: 256,
				labelAlign: 'top'
			},
			items: [{

				xtype: 'multiselectcombofield',
				name: 'dgmDocumentId',
				itemId: 'dgmDocumentId',
				fieldLabel:getCommonTranslation('DOCUMENT'),
				autoloadStore: false,
				width: 300,
				height:40,
				store : Ext.create('Academia.store.documentmanagement.BulkDocumentDownloadStore'),
				cls:'multiBrandCampusCls',
				displayField : 'value',
				valueField : 'id',
				allowBlank : false,
				queryParam:'qry',
				//minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    },
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                        '</div>';
	                }
	            }
			
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256,
				//margin:'10px'
			},
			/*style:{
				padding:'15px'
			},*/
			items: [{
				xtype: 'radiogroup',
				fieldLabel: getAdmissionTranslation('FILE_NAME_FORMAT'), //+' <span class="required" style="color:red"> *</span>',
				itemId: 'dgmFileNameFormat',
				name:'dgmFileNameFormat',
				width: 500,
				labelAlign:'top',
				vertical: false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getAdmissionTranslation('ID_FILE_NAME'),
					itemId: 'idFileName',
					name: 'dgmFileNameFormat',
					inputValue: getAdmissionTranslation('ID_FILE_NAME'),
					checked: true
				}, {
					 boxLabel: getAdmissionTranslation('FILE_NAME_ID'),
					itemId: 'fileNameId',
					name: 'dgmFileNameFormat',
					inputValue: getAdmissionTranslation('FILE_NAME_ID')
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'radiogroup',
				fieldLabel: getAdmissionTranslation('FOLDER_STRUCTURE'), //+' <span class="required" style="color:red"> *</span>',
				itemId: 'dgmFolderStructure',
				name:'dgmFolderStructure',
				width: 500,
				labelAlign:'top',
				vertical: false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getAdmissionTranslation('DOCUMENT_TYPE'),
					itemId: 'documentType',
					name: 'dgmFolderStructure',
					inputValue: getAdmissionTranslation('DOCUMENT_TYPE'),
					checked: true
				}, {
					boxLabel: getAdmissionTranslation('PERSON'),
					itemId: 'person',
					name: 'dgmFolderStructure',
					inputValue: getAdmissionTranslation('PERSON')
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			items: [{
				xtype : 'button',
				text : getAdmissionTranslation('REQUEST_DOWNLOAD'),
				itemId : 'DgmsubmitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'dgmResetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});