/**
 */
Ext.define('Academia.view.documentmanagement.DocumentGroupMasterSeachFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.documentgroupmasterseachfilter',
    frame: false,
    //autoScroll: true,
    cls:'customSearchPanel',
    //layout: 'vbox',
    plugins:"formlabelrequired",
    method: 'POST',
	standardSubmit: false,
    //title: getMessagingModuleTranslation('QUICK_SEARCH'),
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        inputHeight: '30px',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'multiselectcombofield',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			autoloadStore: false,
			width: 536,
			height:58,
			store : Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationListByUserStore'),
			cls:'multiBrandCampusCls',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			queryParam:'qry',
			//minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'customcombobox',
        	name: 'groupName',
        	itemId:'groupNameId',
        	fieldLabel: getCommonTranslation('GROUP_NAME'),
        	store: 'documentmanagement.DocumentGroupMasterStore',
        	valueField: 'id',
			displayField: 'value',
			queryParam:'groupName',
        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	enableKeyEvents  : 'true',
        	minChars:3,
        	typeAhead:false,
        	forceSelection:true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	triggerAction: '',
        	hideTrigger:false,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
        	}
        },{
        	xtype: 'customcombobox',
        	name: 'applicableOn',
        	fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_ON'),
        	itemId:'applicableOnId',
        	store: 'documentmanagement.DocumentGroupMasterApplicableOnStore',
        	displayField:'name',
        	valueField:'value',
        	editable: false,
        	width: 256
        },{
        	xtype: 'customcombobox',
        	name: 'status',
        	itemId:'statusItemId',
        	store:'common.StatusComboStore',
        	displayField:'name',
        	valueField:'id',
        	value:'ACTIVE',
        	forceSelection:true,
        	editable:false,
        	typeAhead:true,
        	fieldLabel:getCommonTranslation('STATUS')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'datefield',
			name: 'dueOnAfter',
			fieldLabel: getCommonTranslation('DUE_ON_AFTER'),
			itemId:'dueOnAfterId',
			width: 256,
			format: CONSTANTS.DATE_FORMAT,
			//startDateField : 'fromDateId',
			//vtype: 'daterange',
		},{
			xtype: 'datefield',
			name: 'dueOnBefore',
			fieldLabel: getCommonTranslation('DUE_ON_BEFORE'),
			itemId:'dueOnBeforeId',
			width: 256,
			format: CONSTANTS.DATE_FORMAT,
			//endDateField : 'toDateId',
			//vtype: 'daterange',
		}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SEARCH'),
            itemId: 'templateFindButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            margin: '0 16 0 0'
        }, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			//buttonAlign : 'left',
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]
    }]
});