/**
 * @author pritam.patil
 * this form is used for Document Listing search form 
 */
Ext.define('Academia.view.documentmanagement.DocumentListSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.documentlistingsearchform',
 //   frame: false,
    plugins: "formlabelrequired",
    cls: 'customSearchPanel',
   // padding: 10,
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'configLevel',
            fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
            itemId: 'document_category',
            editable: false,
            allowBlank: false,
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            msgTarget: 'qtip',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'textfield',
            name: 'typeName',
            fieldLabel: getDocumentTranslation('DOCUMENT_NAME'),
            itemId: 'document_name',
            msgTarget: 'qtip'
        }]
    }, {
        xtype: 'fieldcontainer',
        //width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getDocumentTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getDocumentTranslation('RESET'),
            itemId: 'resetBtnId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});