
Ext.define('Academia.view.dynamicformrendering.CopyToOtherAcademyLocation', {
    extend: 'Ext.window.Window',
    alias: 'widget.copytootheracademylocation',
    modal: true,
    autoScroll:true,
    maxHeight:600,
    title:getCommonTranslation('COPY_TO_OTHER_ACADEMY_LOCATION'),
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        layout: 'anchor',
        defaults: {
        	  labelAlign: 'top',
        	  width: 256,
            anchor: '100%'
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('FROM_ACADEMY_LOCATION'),
            	name:'academyLocation',
            	itemId: 'academyLocationId',
            	store:'dynamicformrendering.DynamicFormAcademyLocation',
            	displayField:'value',
            	valueField: 'id',
            	typeAhead:true,
            	allowBlank:false,
            	forceSelection:true
            }, {
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('SCREENNAME'),
            	name:'screenName',
            	itemId: 'screenNameId',
            	store:'dynamicformrendering.ScreenNames',
            	displayField: 'value',
            	valueField: 'id',
            	typeAhead:true,
            	allowBlank:false,
            	forceSelection:true
            },{
            	xtype: 'multiselectcombofield',
            	fieldLabel: getCommonTranslation('TO_ACADEMY_LOCATION'),
            	width: 536,
            	name:'toAcademyLocation',
            	itemId: 'toAcademyLocationId',
            	store:'dynamicformrendering.configurescreen.ConfigureScreenAcademyLocation',
            	displayField:'value',
            	valueField: 'id',
            	typeAhead:true,
            	allowBlank:false,
            	forceSelection:true
            },{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'submitBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});