/**
 * @author Amit Gupta
 * 
 */
Ext.define('Academia.view.dynamicformrendering.configurescreen.ConfigureScreenSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.configurescreensearch',  
	plugins : "formlabelrequired",
    //autoScroll: true,
	layout: 'anchor',
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items :[{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('ACADEMYLOCATION'),
                    	name:'academyLocation',
                    	itemId: 'academyLocationId',
                    	store:'dynamicformrendering.configurescreen.ConfigureScreenAcademyLocation',
                    	displayField:'value',
                    	valueField: 'id',
                    	queryParam:'name',
        				minChars:3,
        	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        				enableKeyEvents  : 'true',
        	            triggerAction: '',
        	            //typeAhead:true,
                    	allowBlank:false,
                    	forceSelection:true
                    }, {
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('SCREENNAME'),
                    	name:'screenName',
                    	itemId: 'screenNameId',
                    	//store:'dynamicformrendering.ScreenNames',
                    	displayField: 'value',
                    	valueField: 'id',
                    	queryParam:'screenName',
        				minChars:3,
        				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        				enableKeyEvents  : 'true',
        				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            triggerAction: 'all',
                    	allowBlank:false,
                    	forceSelection:true,
                        listeners: {
                            render: function(combo) {
                                var store = Ext.create('Academia.store.dynamicformrendering.ScreenNames');
                                combo.bindStore(store);
                            }
                        }
                    },{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('SCREENMODE'),
                    	name:'screenMode',
                    	itemId: 'ScreenMode',
                    	store:'dynamicformrendering.ScreenModes',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	disabled:true,
                    	allowBlank:false,
                    	forceSelection:true,
                    	editable:false
                    }]
				},{
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                width: 256,
		                labelAlign: 'top'
		            },
		            items :[{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('LANGAUGE'),
                    	name:'langauge',
                    	itemId: 'langauge',
                    	store:'dynamicformrendering.configurescreen.ConfigureScreenLanguages',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	allowBlank:false,
                    	forceSelection:true,
                    	editable:false
                    }]
				},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
		    		layout: 'hbox',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'searcBtn',
		                ui: 'CustomBtnSubmit',
		                formBind:true,
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});