/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.emailAccountStatement.SponserAccountStatementCriteriaGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sponserAccountStatementCriteriaGrid',
	store: 'emailAccountStatement.SponserAccountCriteriaGridStore',
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	title:getCommonTranslation("CRITERIA"),
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	 headerFix:{
		    headerFix: true,
		    portalIdsWithStructure: {
		    'emailAccountStatementStructure':1
		    }},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'emailAccountStatement.SponserAccountCriteriaGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'sponsorBulkEmailBtn',
		disabled:true,
		text : getCommonTranslation('BULK_EMAIL')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		disabled:true,
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation("CRITERIA_ID"),
		dataIndex:'criteriaId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("CRITERIA"),
		dataIndex:'criteria',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return '<a href="#">View</a>';
		}
	},{
		header:  getFeeAndPaymentCommonTranslation("APPLIED_BY"),
		dataIndex:'appliedBy',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("DATE_AND_TIME"),
		dataIndex:'lastDateAndTime',
		flex:.1,
		sortable:true,
		renderer:function(val){
			if(val){
				return dateTimeRender1(val);
			}
			return "";
		}
	},{
		header:  getCommonTranslation("TOTAL_RESULT"),
		dataIndex:'totalResult',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("STATUS"),
		dataIndex:'status',
		flex:.1,
		sortable:true,
		renderer:function(val){
			switch(val){
			case "PENDING":
				return "Pending"
				break
			case "PROCESSED":
				return "Processed"
				break
			}
		}
	}]
});