/**
 * 
 */
Ext.define('Academia.view.enquiry.EnquiryMulProgramForm', {
    extend: 'Ext.window.Window',
	alias: 'widget.enquirymulprogramform',
    modal: true,
    width:860,
    resizable:true,
    height:560,
    autoScroll:true,
    title: getEnquiryTranslation('ENQUIRY_STUDENT_DETAILS_GRID_HEADER'),
    items: [{
        xtype: 'idgeneratorformwin',
        itemId: 'enqMulProgFormWindow',
        plugins : "formlabelrequired",
        method: 'POST',
        width:820,
        defaults: {
            labelAlign: 'top',
            width:240
        },
        standardSubmit: false,
        items: [{
        	xtype: 'hidden',
        	name: 'admissionEnquiryDetailId',
        	itemId: 'admissionEnquiryDetailId'
        },{
        	xtype: 'hidden',
        	name: 'enquiryStudentDetailId',
        	itemId: 'enquiryStudentDetailId'
        },{
        	xtype: 'fieldcontainer',
    		width: '100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 240,
    			labelAlign:'top'
    		},
    		items:[{
		            xtype: 'nestedJsonCombo',
		            fieldLabel: getEnquiryTranslation('SALUTATION'),
		            name: 'salutation',
		            itemId: 'salutation',
		            store: 'common.SalutationStore',
		            valueField: 'id',
		            displayField: 'salutationName',
		            allowBlank: true,
		            editable: false,
		            hidden: true
		        }]
		        },{
        		xtype: 'fieldcontainer',
        		width: '100%',
        		layout: {
        			type: 'hbox'
        		},
        		defaults: {
        			width: 240,
        			labelAlign:'top'
        		},
        		items:[{
				    xtype: 'textfield',
				    name: 'studentFname',
				    itemId: 'studentFname',
				    fieldLabel: getEnquiryTranslation('STUDENT_FIRST_NAME'),
				    allowBlank:false,
				    maxLength:75,
				    //maskRe:/^[a-zA-Z ]+$/,
				    enforceMaxLength : true
				},{
				    xtype: 'textfield',
				    name: 'studentMname',
				    itemId: 'studentMname',
				    fieldLabel: getEnquiryTranslation('STUDENT_MIDDLE_NAME'),
				    maxLength:75,
				    //maskRe:/^[a-zA-Z ]+$/,
				    enforceMaxLength : true
				},{
				    xtype: 'textfield',
				    name: 'studentLname',
				    itemId: 'studentLname',
				    fieldLabel: getEnquiryTranslation('STUDENT_LAST_NAME'),
				    allowBlank:false,
				    maxLength:75,
				    //maskRe:/^[a-zA-Z .]+$/,
				    enforceMaxLength : true
				}]
    		},{
            		xtype: 'fieldcontainer',
            		width: '100%',
            		layout: {
            			type: 'hbox'
            		},
            		defaults: {
            			width: 240,
            			labelAlign:'top'
            		},
            		items:[{
    				xtype: 'textfield',
    				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
    				name: 'studentFirstNameOtherLanguage',
    				itemId:'studentFirstNameOtherLanguageItemId',
    				maxLength : 100,
    				enforceMaxLength :true,
    			},{
    				xtype: 'textfield',
    				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
    				name: 'studentMiddleNameOtherLanguage',
    				itemId:'studentMiddleNameOtherLanguageItemId',
    				maxLength : 53,
    				enforceMaxLength :true,
    			},{
    				xtype: 'textfield',
    				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
    				name: 'studentLastNameOtherLanguage',
    				itemId: 'studentLastNameOtherLanguageItemId',
    				maxLength : 100,
    				enforceMaxLength :true,
    			}]
        		},{
            		xtype: 'fieldcontainer',
            		width: '100%',
            		layout: {
            			type: 'hbox'
            		},
            		defaults: {
            			width: 240,
            			labelAlign:'top'
            		},
            		items:[{
            			xtype : 'customcombobox',
            			name : 'academyLocation',
            			itemId:'academyLocationId',
            			fieldLabel : getEnquiryTranslation('ACADEMY_LOCATION'),
            			store:'common.AcademyLocationNameSeparated',
            			valueField : 'id',
            			displayField : 'value',
            			allowBlank : false,
            			queryParam:'qry',
            			minChars:3,
            			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            			listConfig: {
            				listeners: {
            					beforeshow: function(picker) {
            						picker.minWidth = picker.up('combobox').getSize().width;
            					}
            				},
            				loadingText: getCommonTranslation('SEARCHING'),
            				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            				getInnerTpl: function() {
            					return '<div class="search-item">' +
            					'{code} / {value}' +
            					'</div>';
            				}
            			}
            		},{
        				xtype: 'customcombobox',
        				name: 'modeofDelivery',
        				itemId: 'modeDeliveryId',
        				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
        				store: 'common.ModeOfDeliveryStore',
        				valueField: 'id',
        				displayField: 'value',
        				editable: false,
        				forceSelection: true
        			},{
        				xtype: 'customcombobox',
        				name: 'registrationType',
        				itemId: 'registrationTypeId',
        				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
        				store: 'campaignnew.RegistrationTypeStore',
        				valueField: 'id',
        				displayField: 'value',
        				editable: false,
        				forceSelection: true
        			}]
            	},{
            		xtype: 'fieldcontainer',
            		width: '100%',
            		layout: {
            			type: 'hbox'
            		},
            		defaults: {
            			width: 240,
            			labelAlign:'top'
            		},
            		items:[{
    				    xtype: 'customcombobox',
    				    name: 'programId',
    				    itemId:'programId',
    				    fieldLabel: getEnquiryTranslation('PROGRAM'),
    				    store: 'program.ProgrmaBatchLevelModAndReg',
    				    displayField:'programValue',
    				    valueField:'id',
    				    allowBlank:false,
    				    forceSelection:true,
    				    queryParam:'qry',
            			minChars:3,
            			disabled:true,
            			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            			listConfig: {
            				listeners: {
            					beforeshow: function(picker) {
            						picker.minWidth = picker.up('combobox').getSize().width;
            					}
            				},
            				loadingText: getCommonTranslation('SEARCHING'),
            				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            				getInnerTpl: function() {
            					return '<div class="search-item">' +
            					'{code} / {value}' +
            					'</div>';
            				}
            			}
            		},{
            			xtype: 'customcombobox',
            			name: 'batchId',
            			itemId:'batchId',
            			fieldLabel: getEnquiryTranslation('ACADEMIC_BATCH'),
            			store: 'enquiry.AcademicBatchStore',
            			valueField: 'id',
            			displayField: 'value',
            			allowBlank:false,
            			typeAhead:true,
            			forceSelection:true,
            			disabled:true
            		},{
        				xtype: 'textfield',
        				name: 'fieldOfInterest',
        				itemId:'fieldOfInterest',
        				fieldLabel: getEnquiryTranslation('FIELD_OF_INTEREST'),
        				disabled:true
        			},]
            },{
            		xtype: 'fieldcontainer',
            		width: '100%',
            		layout: {
            			type: 'hbox'
            		},
            		defaults: {
            			width: 240,
            			labelAlign:'top'
            		},
            		items:[{
    				    xtype: 'customcombobox',
    				    name: 'seatTypeId',
    				    itemId:'seatTypeId',
    				    fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
    				    store: 'enquiry.ProgramBatchSeatTypeStore',
    				    valueField: 'id',
    				    displayField: 'value',
    				    allowBlank:false,
    				    typeAhead:true,
    				    forceSelection:true,
    				    disabled:true
    				},{
    					xtype: 'fieldcontainer',
    					itemId : 'mobileNoFldItemId',
    					fieldLabel: getCommonTranslation('MOBILE_NUMBER'),
    					allowBlank: true,
    					defaults: {
    						labelAlign: 'top',
    						width: 240
    					},
    					layout : {
    						type : 'hbox'
    					},
    					items : [{
    						xtype: 'customcombobox',
    						name: 'mobileCountryCode',
    						itemId: 'countryCodeItemId',
    						valueField: 'isdCode',
    						displayField: 'isdCode',
    						store: 'common.CountryStore',
    						triggerAction: 'all',
    						//editable: false,
    						forceSelection: true,
    						minChars: 1,
    						allowBlank: true,
    						width: 63,
    						labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
    					}, {
    						xtype: 'numberfield',
    						name: 'mobileNumber',
    						itemId: 'mobileNumberItemId',
    						minLength: 0,
    						maxLength: 15,
    						enforceMaxLength: true,
    						hideTrigger: true,
    						keyNavEnabled: false,
    						mouseWheelEnabled: false,
    						allowExponential: false,
    						allowBlank: true,
    						width: 178,
    						margin:'0 0 0 -25',
    						labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
    						emptyText:getCommonTranslation('MOBILE_NUMBER'),
    					}]
    				},{
    					xtype: 'fieldcontainer',
    					itemId : 'alternateMobileNoFldItemId',
    					fieldLabel: getEnquiryTranslation('ALTERNATE_NUMBER'),
    					allowBlank: true,
    					defaults: {
    						labelAlign: 'top',
    						width: 240
    					},
    					layout : {
    						type : 'hbox'
    					},
    					items : [{
    						xtype: 'customcombobox',
    						name: 'alternateMobileCountryCode',
    						itemId: 'alternateMobileCountryCode',
    						valueField: 'isdCode',
    						displayField: 'isdCode',
    						store: 'common.CountryStore',
    						triggerAction: 'all',
    						//editable: false,
    						forceSelection: true,
    						minChars: 1,
    						allowBlank: true,
    						width: 63,
    						labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
    					}, {
    						xtype: 'numberfield',
    						name: 'alternateMobileNo',
    						itemId: 'alternateMobileNo',
    						minLength: 0,
    						maxLength: 15,
    						enforceMaxLength: true,
    						hideTrigger: true,
    						keyNavEnabled: false,
    						mouseWheelEnabled: false,
    						allowExponential: false,
    						allowBlank: true,
    						width: 178,
    						margin:'0 0 0 -25',
    						emptyText:getEnquiryTranslation('ALTERNATE_NUMBER'),
    						labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
    					}]
    				}]
            },{
            	xtype: 'fieldcontainer',
            	width: '100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults: {
            		width: 240,
            		labelAlign:'top'
            	},
            	items:[{
            		xtype: 'textfield',
            		name: 'emailId',
            		itemId:'emailId',
            		fieldLabel: getAdmissionTranslation('EMAIL_ADDRESS'),
            		vtype:'myemail',
            		allowBlank:true,
            		maxLength:100,
            		enforceMaxLength : true
            	},{
    				xtype: 'datefield',
    				fieldLabel: getEnquiryTranslation('DATE_OF_BIRTH'),
    				name: 'studentDateOfBirth',
    				id:'studentDetails_studentDateOfBirth_multi',
    				itemId: 'studentDateOfBirth',
    				maxValue: new Date(),
    				listeners: {
    					render : function(dateField){
    						var dateField = dateFormatRender(dateField);
    						var date = new Date();
    						dateField.setMaxValue(date);
    					}
    				}
        		}]
            },{
            	xtype: 'fieldcontainer',
            	width: '100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults: {
            		width: 240,
            		labelAlign:'top'
            	},
            	items:[{
            		xtype      : 'radiogroup',
            		fieldLabel : getCommonTranslation('IS_ENQ_STUDENT_SA_CITIZEN'),
            		itemId: 'isLearnerSACitizenItemId',
            		name: 'isLearnerSACitizenItemId',
            		defaults: {
            			flex: 1
            		},
            		layout: 'hbox',
            		items:[{ 
            			boxLabel: getCommonTranslation('YES'), 
            			name: 'isLearnerSACitizen', 
            			inputValue: true,
            			checked:true
            		},{ 
            			boxLabel: getCommonTranslation('NO'), 
            			name: 'isLearnerSACitizen', 
            			inputValue: false
            		}]
            	},{
    				xtype: 'textfield',
    				name: 'nationalId',
    				itemId:'nationalId',
    				fieldLabel: getEnquiryTranslation('NATIONAL_ID_NUMBER'),
    				maxLength: 50,
    			 //   vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
    			},{
    				xtype: 'customcombobox',
    				name: 'currentGrade',
    				itemId: 'currentGradeItemId',
    				store: 'enquiry.EnquiryCurrentGradeStore',
    				fieldLabel: getEnquiryTranslation('CURRENT_GRADE'),
    				valueField: 'id',
    				displayField: 'value',
    				allowBlank: true,
    				forceSelection: true,
    				editable: false
    			}]
            }, {
            	xtype: 'fieldcontainer',
            	width: '100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults: {
            		width: 240,
            		labelAlign:'top'
            	},
            	items:[{
     				xtype: 'nestedJsonCombo',
    	            itemId: 'examBoardItemId',
    	            fieldLabel: getPersonModuleTranslation('EXAM_BOARD'),
    	            store: 'common.ExamBoardStore',
    				valueField: 'id',
    				displayField: 'value',
    	            name: 'examBoard',
    	            editable : false,
    				allowBlank: true,
    	            hideTrigger:false,
    	            triggerAction: 'all',
    	            forceSelection:true
    			},{
    				xtype: 'multiselectcombofield',
    				name: 'enquiryStudentSchoolSubject',
    				itemId:'enquiryStudentSchoolSubjectItemId',
    				store: Ext.create('Academia.store.common.EducationHistorySubjectStore'),
    				allowBlank:true,
    				fieldLabel: getEnquiryTranslation('SCHOOL_SUBJECTS'),
    				valueField: 'id',
    				displayField: 'value',
    				editable: false,
    	            disableKeyFilter: false,
    	            cls:'commonAutoHeightMultiselectField',
    				forceSelection:true
    			},{
    				xtype: 'numberfield',
    				name: 'gradeElevenAverage',
    				itemId:'gradeElevenAverageItemId',
    				fieldLabel: getEnquiryTranslation('GRADE_ELEVEN_AVERAGE'),
    				hideTrigger:true,
    				mouseWheelEnabled:false,
    				regex: /[a-zA-Z0-9]+/,
    				allowDecimals:false,
    				minValue:0,
    				maxValue:100,
    				maxLength: 3,
    			}]
            },{
            	xtype: 'fieldcontainer',
            	width: '100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults: {
            		width: 240,
            		labelAlign:'top'
            	},
            	items:[{
    				xtype: 'numberfield',
    				name: 'gradeTwelveAverage',
    				itemId:'gradeTwelveAverageItemId',
    				fieldLabel: getEnquiryTranslation('GRADE_TWELVE_AVERAGE'),
    				hideTrigger:true,
    				mouseWheelEnabled:false,
    				allowDecimals:false,
    				regex: /[a-zA-Z0-9]+/,
    				minValue:0,
    				maxValue:100,
    				maxLength:3,
        			disabled:true
    			},{
    				xtype: 'customcombobox',
    				fieldLabel: getAdmissionTranslation('COUNTRY'),
    				name: 'country',
    				autoload: false,
    				itemId: 'countryItemId',
    				store: 'common.CountryStore',
    				valueField: 'id',
    				displayField: 'countryName',
    				queryParam:'countryName',
    				minChars:3,
    				typeAhead:false,
    				hideTrigger:false,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}'  +
    						'</div>';
    					}
    				}
        		}, {
        			xtype: 'customcombobox',
        			fieldLabel: getEnquiryTranslation('NATIONALITY'),
    				itemId: 'nationalityItemId',
    				store: 'common.NationalityStore',
    				valueField: 'id',
    				displayField: 'value',
    				name: 'nationality',
    				queryMode: 'local',
    				autoload: false,
    				minChars:3,
    				typeAhead:false,
    				hideTrigger:false,
    				forceSelection:true,
    				anyMatch:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}'  +
    						'</div>';
    					}
    				}
        		}]
            },{
            	xtype: 'fieldcontainer',
            	/*layout: {
                    type: 'hbox',
                    pack: 'end' // Align items to the right side
                },*/
                width: '100%',
                cls: 'windowBtnPos',
                items: [{
            		xtype: 'button',
            		text: getCommonTranslation('SAVE'),
            		itemId: 'enquiryMulProSubmitBtnId',
            		ui: 'CustomBtnSubmit',
            		scale: CONSTANTS.BUTTONSIZE,
            		formBind: true
            	}, {
            		xtype: 'button',
            		text: getCommonTranslation('CANCEL'),
            		itemId: 'enquiryMulProCancelBtnId',
            		ui: 'CustomBtnCancel',
            		scale: CONSTANTS.BUTTONSIZE	             
            	}]
            }]
    }],
    listeners: {
        show: function (win) {
         var el = win.getEl();
         el.setOpacity(0);
         el.fadeIn({
           duration: 800
        });
     },
      beforeclose: function (win) {
       if (!win.shouldClose) {
           win.getEl().fadeOut({
               duration: 500,
               callback: function () {
                   win.shouldClose = true;
                   win.close();
               }
           });
       }
       return win.shouldClose ? true : false;
    }
  }
});