/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.enquiry.EnquiryNewDownloadForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.enquirynewdownloadform',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'enquiryType',
                itemId: 'enquiryTypeId',
                fieldLabel: getEnquiryTranslation('ENQUIRY_TYPE'),
                store: 'enquiry.EnquiryTypeStore',
                valueField: 'id',
                displayField: 'enquiryTypeName',
                itemId: 'enquiryTypeItemId',
                typeAhead: true,
                forceSelection: true,
				editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
                width: 536,
                name: 'academyLocation',
                itemId: 'academyLocationItemId',
                fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
                store: 'common.AcademyLocationNameSeparated',
                allowBlank: false,
                valueField: 'id',
                //maxLength: 4000,
                displayField: 'value'
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
        items: [{
            xtype: 'button',
            text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
            itemId: 'downloadEnquiryNewFormItemId',
            hidden: false,
            formBind: true,
            ui: 'CustomBtnSubmit'
        }, {
            xtype: 'button',
            text: getCourseTxCommonTranslation('RESET'),
            itemId: 'resetBtn',
            //buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});