/**
 * @author Anand Verma
 */
Ext.define('Academia.view.enquiry.dashboard.CountOfEnquiriesFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.countcfenquiriesfilter',
    autoScroll: false,   
    plugins : "formlabelrequired",
    isMinWidthNotRequired: true,
    frame: false,
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programCategory',
			itemId:'programCategoryItemId',
			fieldLabel: getEnquiryTranslation('PROGRAM_CATEGORY'),
			store: 'program.ProgramCategoryByAlAndProgramStore',
			displayField: 'value',
			valueField: 'id',
			typeAhead: true
		},
		{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			//typeAhead:true,
			forceSelection:true,
            editable: false,
			//minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'assignTo',
			fieldLabel: getEnquiryTranslation('ASSIGN_TO'),
			store:'common.UsersWithDepartmentStore',
			displayField:'value',
			valueField:'id',
			queryParam: 'codeOrName',
			typeAhead:true,
			minChars:3,
			//disabled : true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 256,
            		labelAlign: 'top'
            	},
            	items: [{
            		xtype: 'customcombobox',
            		name: 'program',
            		itemId:'programItemId',
            		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            		store: 'common.ProgramsByProgramCategoryWithALStore',
            		displayField: 'valueCode',
            		valueField: 'id',
            		//typeAhead: true,
            		width:462,
            		//matchFieldWidth:true,
                    forceSelection: true,
                    triggerAction: 'all',
                    queryParam:'smartSearchValue',
                    minChars:3,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	 			listConfig: {
        	 				listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	 				loadingText: getCommonTranslation('SEARCHING'),
        	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	 				getInnerTpl: function() {
        	 					return '<div class="search-item">' +
        	 					'{code} / {value}'+ 
        	 					'</div>';
        	 				}
        	 			}
            	},{
            		xtype: 'customcombobox',
            		name: 'batch',
            		itemId:'batchItemId',
            		fieldLabel: getEnquiryTranslation('BATCH'),
            	    store:'enquiry.AcademicBatchStore',
            		displayField:'value',
            		valueField:'id',
            		disabled:true,
            		typeAhead:true
            	}]
            },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'seatType',
    		itemId:'seatTypeItemId',
    		fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
    		store:'enquiry.ProgramBatchSeatTypeStore',
    		displayField:'value',
    		valueField:'id',
    		typeAhead:true,
    		minChars:3,
    		disabled : true
    	},{
    		xtype: 'datefield',
    		name: 'countOfEnquiryStartDate',
    		//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
    		itemId:'startDateItemId',
    		editable:false,
    		allowBlank:false,
    		vtype: 'daterange',
    		endDateField: 'toDateItemId',
    		fieldLabel:getEnquiryTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
    	},{
    		xtype: 'datefield',
    		name: 'countOfEnquiryToDate',
    		//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
    		editable:false,
    		itemId:'toDateItemId',
    		allowBlank:false,
    		vtype: 'daterange',
    		startDateField: 'startDateItemId',
    		fieldLabel:getEnquiryTranslation('TO_DATE'),
    		maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
    	}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});