/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.enquiry.dashboard.FollowupScheduledForm', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.followupscheduledform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	isMinWidthNotRequired: true,
	//layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[/*{
				xtype: 'textfield',
				name:'enquiryNo',
				fieldLabel:getCommonTranslation('TRACK_ENQUIRY_NO'),
				itemId:'trackEnquiry_enquiryNo'
			},*/{
				xtype: 'customcombobox',
				name: 'ENQUIRY_TYPE',
				fieldLabel:getEnquiryTranslation('ENQUIRY_TYPE_1'),
				store: 'enquiry.EnquiryTypeStore',
				valueField: 'id',
				displayField: 'enquiryTypeName',
				itemId: 'trackEnquiry_enquiryType',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			}, {
				xtype: 'customcombobox',
				name: 'DEPARTMENT',
				fieldLabel:getEnquiryTranslation('DEPARTMENT'),
				store: 'department.ParentDepartmentStore',
				valueField: 'id',
				displayField: 'name',
				itemId: 'trackEnquiry_department',
				typeAhead:true,
				forceSelection:true
			}, {
				xtype: 'customcombobox',
				name: 'ASSIGN_TO',
				fieldLabel:getEnquiryTranslation('ASSIGN_TO'),
				store:'common.UsersWithDepartmentStore',
				displayField:'value',
				valueField:'id',
				itemId: 'trackEnquiry_assignTo',
				forceSelection:true,
				queryParam: 'codeOrName',
				minChars: 3,
				typeAhead: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',	               
			name: 'PRIORITY',
			itemId:'trackEnquiry_priority',
			fieldLabel: getEnquiryTranslation('PRIORITY'),
			store:'enquiry.Priority',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'datefield',
			name:'FROM_DATE',
			itemId:'fromDate',
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'TO_DATE',
			itemId:'toDate',
			fieldLabel: getEnquiryTranslation('TO_DATE'),
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			formBind:true,
			// buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});