/**
 * Rajkumar
 */
Ext.define('Academia.view.enquiry.enquirydetail.EnquiryDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity: CONSTANTS.ENQUIRY_RAISE_CF_DATA,
    columns: 1,
    alias: 'widget.enquirydetailform',
    autoScroll: false,
    frame: false,
    border:false,
    method: 'POST',
    standardSubmit: false,
    layout: 'anchor',
    /*layout:{
			   		type:'table',
			   		columns:2		
			   	},*/
    defaults: {
        width: 256,
        labelAlign: 'top',
        tdAttrs: {
            style: 'padding: 5px;'
        }
    },
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        id: 'enquiryDetail_id',
        name: 'id'
    }, {
        xtype: 'hidden',
        id: 'enquiryDetail_addressId',
        name: 'addressId'
    }, {
        xtype: 'hidden',
        id: 'enquiryDetail_enquiryAddressId',
        name: 'enquiryAddressId'
    }, {
        xtype: 'hidden',
        name: 'status'
    }, {
        xtype: 'hidden',
        id: 'enquiryDetail_userId',
        name: 'userId'
    }, {
        xtype: 'hidden',
        name: 'enqIntermediateTypeId'
    }, {
        xtype: 'hidden',
        name: 'enqIntermediateType'
    }, {

        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'displayfield',
            name: 'user',
            id: 'enquiryDetail_user',
            fieldLabel: getCommonTranslation('ENQUIRY_CREATED_BY')
        }, {

            xtype: 'textfield',
            // xtype: 'datefield',
            name: 'enquiryDate',
            id: 'enquiryDetail_enquiryDate',
            readOnly: true,
            //format: 'd/m/Y',
            // submitFormat: 'd-m-Y',
            fieldLabel: getCommonTranslation('ENQUIRY_DATE')
        }, {
            xtype: 'customcombobox',
            name: 'enquiryType',
            store: 'enquiry.EnquiryTypeStore',
            fieldLabel: getCommonTranslation('ENQUIRY_TYPE_1'),
            valueField: 'id',
            displayField: 'enquiryTypeName',
            id: 'enquiryDetail_enquiryType',
            method: 'POST',
            standardSubmit: false,
            readOnly: true
        }, {
            xtype: 'hidden',
            name: 'enquiryTypeId',
            id: 'enquiryDetail_enquiryTypeId'
        }, {
            xtype: 'hidden',
            name: 'followUpDate',
            id: 'enquiryDetail_followUpDate'
        }, {
            xtype: 'hidden',
            name: 'followUpUser',
            id: 'enquiryDetail_followUpUser'
        }]

    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            id: 'enquiryDetail_enquirySource',
            name: 'sourceCode',
            fieldLabel: getCommonTranslation('ENQUIRY_SOURCE'),
            store: 'enquiry.EnquirySourceStore',
            valueField: 'id',
            displayField: 'value',
            editable: false
        }, {

            xtype: 'customcombobox',
            name: 'campaign',
            id: 'enquiryDetail_campaign',
            fieldLabel: getCommonTranslation('ENQUIRY_CAMPAIGN_NAME'),
            store: 'campaign.CampaignComboStore',
            valueField: 'id',
            displayField: 'value'
        }]

    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'referredType',
            allowBlank: false,
            store: 'enquiry.ReferredTypeStore',
            fieldLabel: getCommonTranslation('REFERRER_TYPE'),
            valueField: 'id',
            id: 'enqdetail_referredType',
            displayField: 'value',
            itemId: 'referredType',
            typeAhead: true,
            forceSelection: true
        }, {
           xtype: 'customcombobox',
 		   name: 'referrerName',
 		   itemId:'referrerName',
 		   fieldLabel: getCommonTranslation('REFERRER_NAME'),
 		   hidden:true,
 		   store: 'enquiry.ReferredIdStore',
 		   valueField: 'id',
 		   displayField: 'value',
 		   queryParam:'name',
 		   id: 'enqdetail_referrerName',
 		   minChars:3,
 		   editable:true,
 		   typeAhead:true,
 		   triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
 		   enableKeyEvents  : 'true',
 		   hideTrigger:false,  
 		   forceSelection:true,
 		   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 		   triggerAction: '',
 		   allowBlank:false,
 		   listConfig: {
 			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 			   loadingText: getCommonTranslation('SEARCHING'),
 			   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 			   getInnerTpl: function() {
 				   return '<div class="search-item">' +
 				   '{value}' +
 				   '</div>';
 			   }
 		   }
            
        },{
 		   xtype: 'textfield',
		   name: 'refUserName',
		   fieldLabel: getCommonTranslation('REFERRER_NAME'),
		   allowBlank:true,
		   disabled:true
	   }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'registeredByType',
            id: 'enquiryDetail_registeredByType',
            //store: 'enquiry.EnquiryTypeStore',
            store: 'enquiry.EnquiryRegisteredBy',
            fieldLabel: getCommonTranslation('ENQUIRY_REGISTERED_BY'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            itemId: 'enquiryTypeCombo',
            allowBlank:false
        }]

    }, {
        xtype: 'fieldcontainer',
        itemId: 'enquiryDetailNamePanel',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top',
//            regex: /[a-zA-Z]+/
        },
        items: [{

            xtype: 'textfield',
            name: 'firstName',
            id: 'enquiryDetail_firstName',
            allowBlank: false,
            fieldLabel: getCommonTranslation('ENQUIRER_FIRST_NAME'),
            maxLength:100,
            maskRe:/^[a-zA-Z ]+$/,
            enforceMaxLength : true
        }, {
            xtype: 'textfield',
            name: 'middleName',
            id: 'enquiryDetail_middleName',
            fieldLabel: getCommonTranslation('ENQUIRER_MIDDLE_NAME'),
            maxLength:53,
            maskRe:/^[a-zA-Z ]+$/,
            enforceMaxLength : true
        }, {

            xtype: 'textfield',
            name: 'lastName',
            id: 'enquiryDetail_lastName',
           //allowBlank: false,
            fieldLabel: getCommonTranslation('ENQUIRER_LAST_NAME'),
            maxLength:100,	
            maskRe:/^[a-zA-Z ]+$/,
            enforceMaxLength : true
        }]

    }, {
        xtype: 'fieldcontainer',
        itemId: 'corporateEnqItemId',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top',
            regex: /[a-zA-Z0-9]+/
        },
        items: [{
            xtype: 'textfield',
            name: 'companyName',
            id: 'enquiryDetail_companyName',
            fieldLabel: getCommonTranslation('COMPANY_NAME'),
            allowBlank: false, // if entered not allow blank

        }, {
            xtype: 'textfield',
            name: 'contactPerson',
            id: 'enquiryDetail_contactPerson',
            fieldLabel: getCommonTranslation('ENQUIRY_CONTACT_PERSON'),
            maxLength:35,
            enforceMaxLength : true
            
        }, {
            xtype: 'textfield',
            name: 'totalSeats',
            id: 'enquiryDetail_totalSeats',
            fieldLabel: getCommonTranslation('ENQUIRY_TOTAL_SEAT'),
            allowBlank: false, // if entered not allow blank
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'country',
            id: 'enquiryDetail_country',
            fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
            store: 'common.CountryStore',
            valueField: 'id',
            displayField: 'countryName',
            itemId: 'country',
//         allowBlank: false

        }, {
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//    		name : 'genericField1',
    		itemId : 'genericFieldId1',
    		id : 'genericFieldId1',
    		store:'organization.CountryRegionStore',
    		valueField : 'id',
    		displayField : 'countryRegionName',
    		name : 'parentCountryRegion',
    		editable : false,
    		valueNotFoundText:"",        		        						
			forceSelection :true,
			allowBlank:false
    	},{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ADDRESS_CITY'),
            id: 'enquiryDetail_city',
            name: 'city',
            editable: false,
            allowBlank: false,
            itemId: 'city',
//            store: 'organization.CityStore',
            store: 'organization.CityByCountryRegion',
            valueField: 'id',
//            displayField: 'cityName'
            displayField: 'value'
        }, {
            xtype: 'hidden',
            id: 'enquiryDetail_parentCountryRegion',
            name: 'parentCountryRegionId'
        }, {
            xtype: 'hidden',
            id: 'enquiryDetail_countryRegion',
            name: 'countryRegionId'
        }, {
            xtype: 'hidden',
            id: 'enquiryDetail_versionId',
            name: 'version'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{

            xtype: 'customcombobox',
            id: 'enquiryDetail_cellCountrycode',
            fieldLabel: getCommonTranslation('COUNTRY_CODE'),
            valueField: 'isdCode',
            displayField: 'isdCode',
            store: 'common.CountryStore',
            triggerAction: 'all',
            name: 'cellCountrycode',
            editable: false,
            width: 100

        }, {
            xtype: 'numberfield',
            name: 'cellNo',
            id: 'enquiryDetail_cellNumber',
            fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			minLength: 6,
			maxLength: 11,
            hideTrigger: true,
            //  width: 110 //Do not put in defaults for IE

        }, {
            xtype: 'textfield',
            name: 'primaryeEmailId',
            id: 'enquiryDetail_primaryeEmailId',
            vtype: 'email',
            fieldLabel: getCommonTranslation('EMAIL'),
            maxLength:100,
            enforceMaxLength : true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        fieldLabel: getCommonTranslation('OTHER_CONTACT'),
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256
        },

        items: [{
            xtype: 'customcombobox',
            id: 'enquiryDetail_phoneCountryCode',
            valueField: 'isdCode',
            displayField: 'isdCode',
            store: 'common.CountryStore',
            triggerAction: 'all',
            name: 'phoneCountryCode',
            editable: false,
            width: 100

        }, {
            xtype: 'numberfield',
            name: 'phoneAreaCode',
            store: 'common.CountryStore',
            width: 115, //Do not put in defaults for IE
            id: 'enquiryDetail_areaCode',
            enforceMaxLength: true,
            minValue: 0,
            maxLength: 5,
            hideTrigger: true
        }, {
            xtype: 'numberfield',
            id: 'enquiryDetail_regdPhoneNo',
            name: 'phoneNo',
            itemId: 'phoneNoField',
            minValue: 0,
            minLength: 5,
            hideTrigger: true,
            width: 256 //Do not put in defaults for IE
        }]
    }, {
        xtype: 'textareafield',
        name: 'remark',
        width:CONSTANTS.DEFAULT_TEXTAREA_SIZE,
        id: 'enquiryDetail_remark',
        itemId: 'enquiryDetail_remark',
        fieldLabel: getCommonTranslation('ENQUIRY_REMARKS'),
//        maxLength:255,
        enforceMaxLength : true
    }, {
		border : false,
		layout : {
			type : 'hbox',
			width : '100%'
		},
		style:{
			marginLeft:'0px'
		},
        items: [{
            xtype: 'button',
            name:'enquirydetail_SubmitButtonId',
            action: 'Submit',
            id: 'enquirydetail_SubmitButtonId',
            formBind: false,
            text: getCommonTranslation('SAVE'),
            itemId: 'enquirydetail_SubmitButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'enquirydetail_EditButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});