/**
 * Rajkumar
 */
var followUpDetailStore = Ext.create('Academia.store.enquiry.followup.FollowUpDetailStore');
Ext.define('Academia.view.enquiry.followup.FollowUpDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.followupdetailgrid',
    store:'enquiry.followup.FollowUpDetailStore',
    title: getEnquiryTranslation('LIST_OF_FOLLOWUP_DETAILS'),
    border: true,
    refreshStoreData:true,
    id:'followUpDetailGridId',
    autoScroll: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS,
	loadMask: false
    },
    isGridConfigurable : true,
    enableColumnHide: false,
    isFixHeightGrid: true,
    minHeight: 0,
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
        emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    store : 'enquiry.followup.FollowUpDetailStore',
	    displayInfo : true
	}]
    }],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar : [{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}],
    /**
     * 
     */
    columns : [/*{
	    header :getCommonTranslation('ID'),
        hidden:true, 
	    dataIndex : 'id',
	    flex:1
	    renderer: function(date) {
            return dateRender(date);
        }
	},*/{
	    header :getCommonTranslation('FOLLOW_UP_SCHEDULE'),
	    dataIndex : 'followUpDate',
	    flex:1,
	   // defaultSortable: false,
	 //   sortable:false,
	    //sortOnLoad : false,
		renderer:function(date) {
		return dateRender(date);
		}
	},{
	    header :getEnquiryTranslation('FOLLOW_UP_STATUS_UPDATE_DATE_AND_TIME'),
	    dataIndex : 'followupStatusUpdateTime',
	    flex:1,
	    renderer:function(date) {
            if(!isNullOrEmpty(date)){
            var newDateTIme=    Ext.Date.parse(date,'d-m-Y H:i:s').getTime();
             return '<div>'+dateRender(newDateTIme)+'</div>'+" "+'<div>'+timeRender(newDateTIme)+'</div>';
            }else{
                return null;
                                            
           }}
	}, {
	    header :getCommonTranslation('FOLLOW_UP_DATE'),
	    dataIndex : 'actualFollowUpDate',
	    flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
	    header : getCommonTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
	    dataIndex : 'followUpActivityType',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getCommonTranslation('REASON_FOR_FOLLOW-UP'),
	    dataIndex : 'reasonForFollowUp',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getCommonTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
	    dataIndex : 'followUpActivityStatus',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	}, {
	    header : getCommonTranslation('FOLLOW_UP_USER'),
	    dataIndex : 'users',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},/*{
	    header : getEnquiryTranslation('INTERMEDIATE_STAGE'),
	    dataIndex : 'enqIntermediateType',
	    flex:1,
	    hidden: true,
	    renderer:function(value,meta){
	    	if(value!=null){
            return value.value;
	    	}else{
	    		return '';
	    	}
	    }
	},*/ {
	    header : getCommonTranslation('FOLLOW_UP_REMARK'),
	    dataIndex : 'remark',
	    flex:1,
	    renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    	if(val!=null){
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 55px;min-width: 16ch;max-width: 17ch;';
	    		return val;
	    	}
	    }
	}, {
	    header : getCommonTranslation('STATUS'),
	    dataIndex : 'status',
	    hidden:true,
	    flex:1,
	    renderer:function(val, meta, record, rowIndex){
	    	return val;
	    }
	}]

});