/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.followup.FollowUpDetailGrid_2', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.followupdetailgrid',
    store:[],
    border: true,
    autoScroll: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
        emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    store : '',
	    displayInfo : true
	}]
    }],
    tbar : [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		 xtype: 'button',
         itemId: 'btnView',
         tooltip: getCommonTranslation('VIEW'),
         iconCls: 'view-icon'
	}],
    columns : [{
	    header :getCommonTranslation('FOLLOWUP_PLANNED_DATE'),
	    dataIndex : 'plannedDate',
	    flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
	    header :getCommonTranslation('FOLLOWUP_ACTUAL_DATE'),
	    dataIndex : 'actualDate',
	    flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
	    header : getCommonTranslation('NAME'),
	    dataIndex : 'name',
	    flex:1
	}, {
	    header : getCommonTranslation('REMARKS'),
	    dataIndex : 'remarks',
	    flex:1
	}, {
	    header : getCommonTranslation('STATUS'),
	    dataIndex : 'status',
	    flex:1
	}]

});