Ext.define('Academia.view.enquiry.import.EnquiryImportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.enquiryimportform',
	title : getCommonTranslation('IMPORT_PROSPECTS'),
	autoScroll : true,
	frame : false,
	border : false,
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	defaults: {
	        width: 256,
	        labelAlign: 'top'
	},
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype: 'customcombobox',
	    name: 'academyId',
	    itemId:'academyId',
	    emptyText: getCommonTranslation('SELECT_COMBOBOX_EMPTY_TEXT'),
	    fieldLabel: getCommonTranslation('ACADEMY'),
	    store: 'common.AcademyStore',
	    valueField: 'id',
	    displayField: 'value',
	    allowBlank:false,
	    typeAhead:true,
	    forceSelection:true
	}, {
	    xtype: 'customcombobox',
	    name: 'locationId',
	    itemId:'locationId',
	    emptyText: getCommonTranslation('SELECT_COMBOBOX_EMPTY_TEXT'),
	    fieldLabel: getCommonTranslation('LOCATION'),
	    store: 'common.AcademyLocationByAcademyId',
	   // editable: false,        
	    valueField: 'id',
	    displayField: 'locationName',
	    allowBlank: false,
	    typeAhead:true,
	    forceSelection:true
	},{
		xtype: 'filefield',
        name: 'filefield',
        fieldLabel:getCommonTranslation('UPLOAD_DOC'),
        allowBlank: false        
    },{
            xtype: 'button',            
            text: getCommonTranslation('SAVE'),
            style:{marginTop:'10px'},
            itemId: 'importEnqUploadBtnId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,   
            formBind: true
                 
	 }]
});
